/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.settings.model.ICStorageElement;
import org.eclipse.cdt.internal.core.SafeStringInterner;
import org.eclipse.core.runtime.CoreException;

public class MapStorageElement
implements ICStorageElement {
    private HashMap<String, String> fMap;
    private String fName;
    private MapStorageElement fParent;
    private static final String CHILDREN_KEY = "?children?";
    private static final String NAME_KEY = "?name?";
    private static final String VALUE_KEY = "?value?";
    private List<MapStorageElement> fChildren = new ArrayList<MapStorageElement>();
    private String fValue;

    public MapStorageElement(String name, MapStorageElement parent) {
        this.fName = name;
        this.fParent = parent;
        this.fMap = new HashMap();
    }

    public MapStorageElement(Map<String, String> map, MapStorageElement parent) {
        List<String> childrenStrList;
        int size;
        this.fName = map.get(this.getMapKey(NAME_KEY));
        this.fValue = map.get(this.getMapKey(VALUE_KEY));
        this.fMap = new HashMap<String, String>(map);
        this.fParent = parent;
        String children = map.get(this.getMapKey(CHILDREN_KEY));
        if (children != null && (size = (childrenStrList = MapStorageElement.decodeList(children)).size()) != 0) {
            int i = 0;
            while (i < size) {
                HashMap<String, String> childMap = MapStorageElement.decodeMap(childrenStrList.get(i));
                MapStorageElement child = this.createChildElement(childMap);
                this.fChildren.add(child);
                ++i;
            }
        }
    }

    protected MapStorageElement createChildElement(Map<String, String> childMap) {
        return new MapStorageElement(childMap, this);
    }

    protected String getMapKey(String name) {
        return name;
    }

    public Map<String, String> toStringMap() {
        Map map = (Map)this.fMap.clone();
        if (this.fName != null) {
            map.put(this.getMapKey(NAME_KEY), this.fName);
        } else {
            map.remove(this.getMapKey(NAME_KEY));
        }
        if (this.fValue != null) {
            map.put(this.getMapKey(VALUE_KEY), this.fValue);
        } else {
            map.remove(this.getMapKey(VALUE_KEY));
        }
        int size = this.fChildren.size();
        if (size != 0) {
            ArrayList<String> childrenStrList = new ArrayList<String>(size);
            int i = 0;
            while (i < size) {
                MapStorageElement child = this.fChildren.get(i);
                Map<String, String> childStrMap = child.toStringMap();
                String str = MapStorageElement.encodeMap(childStrMap);
                childrenStrList.add(str);
                ++i;
            }
            String childrenStr = MapStorageElement.encodeList(childrenStrList);
            map.put(this.getMapKey(CHILDREN_KEY), childrenStr);
        } else {
            map.remove(this.getMapKey(CHILDREN_KEY));
        }
        return map;
    }

    protected boolean isSystemKey(String key) {
        return key.indexOf(63) == 0 && key.lastIndexOf(63) == key.length() - 1;
    }

    public void clear() {
        this.fMap.clear();
    }

    public ICStorageElement createChild(String name) {
        MapStorageElement child = this.createChildElement(name);
        this.fChildren.add(child);
        return child;
    }

    protected MapStorageElement createChildElement(String name) {
        return new MapStorageElement(name, this);
    }

    public String getAttribute(String name) {
        String o = this.fMap.get(this.getMapKey(name));
        if (o instanceof String) {
            return o;
        }
        return null;
    }

    public boolean hasAttribute(String name) {
        return this.fMap.containsKey(this.getMapKey(name));
    }

    public ICStorageElement[] getChildren() {
        return this.fChildren.toArray(new MapStorageElement[this.fChildren.size()]);
    }

    public ICStorageElement[] getChildrenByName(String name) {
        ArrayList<ICStorageElement> children = new ArrayList<ICStorageElement>();
        for (ICStorageElement iCStorageElement : this.fChildren) {
            if (!name.equals(iCStorageElement.getName())) continue;
            children.add(iCStorageElement);
        }
        return new ICStorageElement[children.size()];
    }

    public boolean hasChildren() {
        return !this.fChildren.isEmpty();
    }

    public String getName() {
        return this.fName;
    }

    public ICStorageElement getParent() {
        return this.fParent;
    }

    public void removeChild(ICStorageElement child) {
        this.fChildren.remove(child);
        if (child instanceof MapStorageElement) {
            ((MapStorageElement)child).removed();
        }
    }

    private void removed() {
        this.fParent = null;
    }

    public void removeAttribute(String name) {
        this.fMap.remove(this.getMapKey(name));
    }

    public void setAttribute(String name, String value) {
        this.fMap.put(this.getMapKey(name), value);
    }

    public static HashMap<String, String> decodeMap(String value) {
        List<String> list = MapStorageElement.decodeList(value);
        HashMap<String, String> map = new HashMap<String, String>();
        char escapeChar = '\\';
        int i = 0;
        while (i < list.size()) {
            StringBuilder line = new StringBuilder(list.get(i));
            int lndx = 0;
            while (lndx < line.length()) {
                if (line.charAt(lndx) == '=') {
                    if (line.charAt(lndx - 1) != escapeChar) break;
                    line.deleteCharAt(lndx - 1);
                }
                ++lndx;
            }
            map.put(SafeStringInterner.safeIntern((String)line.substring(0, lndx)), SafeStringInterner.safeIntern((String)line.substring(lndx + 1)));
            ++i;
        }
        return map;
    }

    public static List<String> decodeList(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value != null) {
            StringBuilder envStr = new StringBuilder(value);
            String escapeChars = "|\\";
            char escapeChar = '\\';
            try {
                while (envStr.length() > 0) {
                    int ndx = 0;
                    while (ndx < envStr.length()) {
                        if (escapeChars.indexOf(envStr.charAt(ndx)) != -1) {
                            if (envStr.charAt(ndx - 1) == escapeChar) {
                                envStr.deleteCharAt(ndx - 1);
                                if (ndx == envStr.length()) break;
                            }
                            if (envStr.charAt(ndx) == '|') break;
                        }
                        ++ndx;
                    }
                    StringBuilder line = new StringBuilder(envStr.substring(0, ndx));
                    list.add(SafeStringInterner.safeIntern((String)line.toString()));
                    envStr.delete(0, ndx + 1);
                }
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
        }
        return list;
    }

    public static String encodeMap(Map<String, String> values) {
        Iterator<Map.Entry<String, String>> entries = values.entrySet().iterator();
        StringBuilder str = new StringBuilder();
        while (entries.hasNext()) {
            Map.Entry<String, String> entry = entries.next();
            str.append(MapStorageElement.escapeChars(entry.getKey(), "=|\\", '\\'));
            str.append("=");
            str.append(MapStorageElement.escapeChars(entry.getValue(), "|\\", '\\'));
            str.append("|");
        }
        return str.toString();
    }

    public static String encodeList(List<String> values) {
        StringBuilder str = new StringBuilder();
        for (String entry : values) {
            str.append(MapStorageElement.escapeChars(entry, "|\\", '\\'));
            str.append("|");
        }
        return str.toString();
    }

    public static String escapeChars(String string, String escapeChars, char escapeChar) {
        StringBuilder str = new StringBuilder(string);
        int i = 0;
        while (i < str.length()) {
            if (escapeChars.indexOf(str.charAt(i)) != -1) {
                str.insert(i, escapeChar);
                ++i;
            }
            ++i;
        }
        return str.toString();
    }

    public String getValue() {
        return this.fValue;
    }

    public void setValue(String value) {
        this.fValue = value;
    }

    public ICStorageElement importChild(ICStorageElement el) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String[] getAttributeNames() {
        ArrayList<String> list = new ArrayList<String>(this.fMap.size());
        Set<Map.Entry<String, String>> entrySet = this.fMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            if (this.isSystemKey(key)) continue;
            list.add(key);
        }
        return list.toArray(new String[list.size()]);
    }

    public ICStorageElement createCopy() throws UnsupportedOperationException, CoreException {
        throw new UnsupportedOperationException();
    }

    public boolean equals(ICStorageElement other) {
        throw new UnsupportedOperationException();
    }
}

