/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.managedbuilder.internal.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSettingEntry;
import org.eclipse.cdt.core.settings.model.util.CDataUtil;
import org.eclipse.cdt.internal.core.envvar.EnvironmentVariableManager;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IHoldsOptions;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.managedbuilder.core.ManagedBuilderCorePlugin;
import org.eclipse.cdt.managedbuilder.internal.core.BuilderFactory;
import org.eclipse.cdt.managedbuilder.internal.core.CommonBuilder;
import org.eclipse.cdt.managedbuilder.internal.core.HeadlessBuildMessages;
import org.eclipse.cdt.managedbuilder.internal.core.HeadlessBuilderExternalSettingsProvider;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.osgi.service.datalocation.Location;

public class HeadlessBuilder
implements IApplication {
    public static final Integer ERROR = 1;
    public static final Integer OK = IApplication.EXIT_OK;
    private final Set<String> projectsToImport = new HashSet<String>();
    private final Set<String> projectTreeToImport = new HashSet<String>();
    private final Set<String> projectRegExToBuild = new HashSet<String>();
    private final Set<String> projectRegExToClean = new HashSet<String>();
    private boolean buildAll = false;
    private boolean cleanAll = false;
    private boolean disableIndexer = false;
    private List<ToolOption> toolOptions = new ArrayList<ToolOption>();
    private Map<String, Set<SavedToolOption>> savedToolOptions = new HashMap<String, Set<SavedToolOption>>();
    private static final String MATCH_ALL_CONFIGS = ".*";

    private Map<IProject, Set<ICConfigurationDescription>> matchConfigurations(String regularExpression, IProject[] projectList, Map<IProject, Set<ICConfigurationDescription>> cfgMap) {
        try {
            String configRegEx;
            String projectRegEx;
            int separatorIndex = regularExpression.indexOf(47);
            if (separatorIndex == -1 || separatorIndex == regularExpression.length() - 1) {
                projectRegEx = regularExpression;
                configRegEx = MATCH_ALL_CONFIGS;
            } else {
                projectRegEx = regularExpression.substring(0, separatorIndex);
                configRegEx = regularExpression.substring(separatorIndex + 1, regularExpression.length());
            }
            Pattern projectPattern = Pattern.compile(projectRegEx);
            Pattern configPattern = Pattern.compile(configRegEx);
            boolean projectMatched = false;
            boolean configMatched = false;
            IProject[] iProjectArray = projectList;
            int n = projectList.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                Matcher projectMatcher = projectPattern.matcher(project.getName());
                if (projectMatcher.matches()) {
                    projectMatched = true;
                    ICProjectDescription desc = CoreModel.getDefault().getProjectDescription(project, false);
                    if (desc == null) {
                        System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_project) + project.getName() + HeadlessBuildMessages.HeadlessBuilder_Not_CDT_Proj);
                    } else {
                        ICConfigurationDescription[] cfgs;
                        ICConfigurationDescription[] iCConfigurationDescriptionArray = cfgs = desc.getConfigurations();
                        int n3 = cfgs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ICConfigurationDescription cfg = iCConfigurationDescriptionArray[n4];
                            Matcher cfgMatcher = configPattern.matcher(cfg.getName());
                            if (cfgMatcher.matches()) {
                                configMatched = true;
                                Set<ICConfigurationDescription> set = cfgMap.get(project);
                                if (set == null) {
                                    set = new HashSet<ICConfigurationDescription>();
                                }
                                set.add(cfg);
                                cfgMap.put(project, set);
                            }
                            ++n4;
                        }
                    }
                }
                ++n2;
            }
            if (!projectMatched) {
                System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_NoProjectMatched) + regularExpression + HeadlessBuildMessages.HeadlessBuilder_Skipping2);
            } else if (!configMatched) {
                System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_NoConfigMatched) + regularExpression + HeadlessBuildMessages.HeadlessBuilder_Skipping2);
            }
        }
        catch (PatternSyntaxException e) {
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_RegExSyntaxError) + e.toString());
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_Skipping) + regularExpression + HeadlessBuildMessages.HeadlessBuilder_Quote);
        }
        return cfgMap;
    }

    private void buildConfigurations(Map<IProject, Set<ICConfigurationDescription>> projConfigs, IProgressMonitor monitor, final int buildType) throws CoreException {
        for (Map.Entry<IProject, Set<ICConfigurationDescription>> entry : projConfigs.entrySet()) {
            final IProject proj = entry.getKey();
            Set<ICConfigurationDescription> cfgDescs = entry.getValue();
            IConfiguration[] configs = new IConfiguration[cfgDescs.size()];
            int i = 0;
            for (ICConfigurationDescription cfgDesc : cfgDescs) {
                configs[i++] = ManagedBuildManager.getConfigurationForDescription(cfgDesc);
            }
            final Map<String, String> map = BuilderFactory.createBuildArgs(configs);
            IWorkspaceRunnable op = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    ICommand[] commands = proj.getDescription().getBuildSpec();
                    monitor.beginTask("", commands.length);
                    int i = 0;
                    while (i < commands.length) {
                        if (commands[i].getBuilderName().equals(CommonBuilder.BUILDER_ID)) {
                            proj.build(buildType, CommonBuilder.BUILDER_ID, map, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        } else {
                            proj.build(buildType, commands[i].getBuilderName(), commands[i].getArguments(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        ++i;
                    }
                    monitor.done();
                }
            };
            try {
                ResourcesPlugin.getWorkspace().run(op, monitor);
            }
            finally {
                monitor.done();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private int importProject(String projURIStr, boolean recurse) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [32[WHILELOOP]], but top level block is 7[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean isProjectSuccesfullyBuild(IProject project) {
        boolean result = false;
        try {
            result = project.findMaxProblemSeverity("org.eclipse.core.resources.problemmarker", true, 2) < 2;
        }
        catch (CoreException e) {
            ManagedBuilderCorePlugin.log(e);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public Object start(IApplicationContext context) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 11[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean checkInstanceLocation() {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc == null || !instanceLoc.isSet()) {
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_MustSpecifyWorkspace);
            return false;
        }
        try {
            if (!instanceLoc.lock()) {
                System.err.println(HeadlessBuildMessages.HeadlessBuilder_WorkspaceInUse);
                return false;
            }
            return true;
        }
        catch (IOException iOException) {
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_CouldntLockWorkspace);
            return false;
        }
    }

    public boolean getArguments(String[] args) {
        try {
            if (args == null || args.length == 0) {
                throw new Exception(HeadlessBuildMessages.HeadlessBuilder_no_arguments);
            }
            int i = 0;
            while (i < args.length) {
                String option;
                String toolId;
                if ("-import".equals(args[i])) {
                    this.projectsToImport.add(args[++i]);
                } else if ("-importAll".equals(args[i])) {
                    this.projectTreeToImport.add(args[++i]);
                } else if ("-build".equals(args[i])) {
                    this.projectRegExToBuild.add(args[++i]);
                } else if ("-cleanBuild".equals(args[i])) {
                    this.projectRegExToClean.add(args[++i]);
                } else if ("-D".equals(args[i])) {
                    String macro = args[++i];
                    String macroVal = "";
                    if (macro.indexOf(61) != -1) {
                        macroVal = macro.substring(macro.indexOf(61) + 1);
                        macro = macro.substring(0, macro.indexOf(61));
                    }
                    HeadlessBuilderExternalSettingsProvider.additionalSettings.add((ICSettingEntry)CDataUtil.createCMacroEntry((String)macro, (String)macroVal, (int)0));
                } else if ("-I".equals(args[i])) {
                    HeadlessBuilderExternalSettingsProvider.additionalSettings.add((ICSettingEntry)CDataUtil.createCIncludePathEntry((String)args[++i], (int)0));
                } else if ("-include".equals(args[i])) {
                    HeadlessBuilderExternalSettingsProvider.additionalSettings.add((ICSettingEntry)CDataUtil.createCIncludeFileEntry((String)args[++i], (int)0));
                } else if ("-E".equals(args[i])) {
                    this.addEnvironmentVariable(args[++i], 1);
                } else if ("-Ea".equals(args[i])) {
                    this.addEnvironmentVariable(args[++i], 4);
                } else if ("-Ep".equals(args[i])) {
                    this.addEnvironmentVariable(args[++i], 3);
                } else if ("-Er".equals(args[i])) {
                    this.addEnvironmentVariable(args[++i], 2);
                } else if ("-T".equals(args[i])) {
                    toolId = args[++i];
                    option = args[++i];
                    this.addToolOption(toolId, option, 0);
                } else if ("-Ta".equals(args[i])) {
                    toolId = args[++i];
                    option = args[++i];
                    this.addToolOption(toolId, option, 1);
                } else if ("-Tp".equals(args[i])) {
                    toolId = args[++i];
                    option = args[++i];
                    this.addToolOption(toolId, option, 2);
                } else if ("-Tr".equals(args[i])) {
                    toolId = args[++i];
                    option = args[++i];
                    this.addToolOption(toolId, option, 3);
                } else if ("-no-indexer".equals(args[i])) {
                    this.disableIndexer = true;
                } else {
                    throw new Exception(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_unknown_argument) + args[i]);
                }
                ++i;
            }
        }
        catch (Exception e) {
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_invalid_argument) + args != null ? Arrays.toString(args) : "");
            System.err.println(String.valueOf(HeadlessBuildMessages.HeadlessBuilder_Error) + e.getMessage());
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_import);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_importAll);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_build);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_clean_build);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_usage_no_indexer);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_InlucdePath);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_IncludeFile);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_PreprocessorDefine);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_EnvVar_Replace);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_EnvVar_Append);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_EnvVar_Prepend);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_EnvVar_Remove);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_ToolOption_Replace);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_ToolOption_Append);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_ToolOption_Prepend);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_ToolOption_Remove);
            System.err.println(HeadlessBuildMessages.HeadlessBuilder_ToolOption_Types);
            return false;
        }
        if (this.projectRegExToClean.contains("all") || this.projectRegExToClean.contains("*")) {
            this.cleanAll = true;
            this.buildAll = true;
            this.projectRegExToClean.remove("all");
            this.projectRegExToClean.remove("*");
        }
        if (this.projectRegExToBuild.contains("all") || this.projectRegExToBuild.contains("*")) {
            this.buildAll = true;
            this.projectRegExToBuild.remove("all");
            this.projectRegExToBuild.remove("*");
        }
        return true;
    }

    private void addEnvironmentVariable(String string, int op) throws Exception {
        String[] parts = string.split("=", 2);
        String name = parts[0];
        String value = "";
        if (parts.length > 1) {
            value = parts[1];
        }
        EnvironmentVariableManager.fUserSupplier.createOverrideVariable(name, value, op, null);
    }

    private void addToolOption(String toolId, String option, int operation) {
        String optionId = option;
        String value = "";
        if (option.indexOf(61) != -1) {
            value = option.substring(option.indexOf(61) + 1);
            optionId = option.substring(0, option.indexOf(61));
        }
        this.toolOptions.add(new ToolOption(toolId, optionId, value, operation));
    }

    private void setToolOptions(IConfiguration configuration) throws BuildException {
        if (!this.savedToolOptions.containsKey(configuration.getId())) {
            this.savedToolOptions.put(configuration.getId(), new HashSet());
        }
        Set<SavedToolOption> savedToolOptionsSet = this.savedToolOptions.get(configuration.getId());
        for (ToolOption toolOption : this.toolOptions) {
            ITool[] tools;
            ITool[] iToolArray = tools = configuration.getToolsBySuperClassId(toolOption.toolId);
            int n = tools.length;
            int n2 = 0;
            while (n2 < n) {
                ITool tool = iToolArray[n2];
                IOption option = tool.getOptionBySuperClassId(toolOption.optionId);
                if (option != null) {
                    savedToolOptionsSet.add(new SavedToolOption(tool.getId(), option.getId(), option.getValue()));
                    switch (option.getValueType()) {
                        case 0: {
                            boolean booleanValue = (Boolean)option.getDefaultValue();
                            if (toolOption.operation != 3) {
                                booleanValue = Boolean.parseBoolean(toolOption.value);
                            }
                            ManagedBuildManager.setOption(configuration, (IHoldsOptions)tool, option, booleanValue);
                            break;
                        }
                        case -11: 
                        case -10: 
                        case -9: 
                        case -8: 
                        case -5: 
                        case -4: 
                        case 3: 
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: {
                            List<Object> listValue = new ArrayList<String>();
                            switch (toolOption.operation) {
                                case 1: {
                                    listValue.addAll((List)option.getValue());
                                    listValue.addAll(Arrays.asList(toolOption.value.split(",")));
                                    break;
                                }
                                case 2: {
                                    listValue.addAll(Arrays.asList(toolOption.value.split(",")));
                                    listValue.addAll((List)option.getValue());
                                    break;
                                }
                                case 3: {
                                    listValue = (List)option.getDefaultValue();
                                    break;
                                }
                                default: {
                                    listValue = Arrays.asList(toolOption.value.split(","));
                                }
                            }
                            ManagedBuildManager.setOption(configuration, (IHoldsOptions)tool, option, listValue == null ? new String[]{} : listValue.toArray(new String[listValue.size()]));
                            break;
                        }
                        default: {
                            String stringValue = toolOption.value;
                            switch (toolOption.operation) {
                                case 1: {
                                    stringValue = option.getValue() + stringValue;
                                    break;
                                }
                                case 2: {
                                    stringValue = String.valueOf(stringValue) + option.getValue();
                                    break;
                                }
                                case 3: {
                                    stringValue = (String)option.getDefaultValue();
                                }
                            }
                            ManagedBuildManager.setOption(configuration, (IHoldsOptions)tool, option, stringValue);
                        }
                    }
                }
                ++n2;
            }
        }
    }

    private void resetToolOptions(IConfiguration configuration) throws BuildException {
        for (SavedToolOption toolOption : this.savedToolOptions.get(configuration.getId())) {
            IOption option = configuration.getTool(toolOption.toolId).getOptionById(toolOption.optionId);
            option.setValue(toolOption.value);
        }
    }

    public void stop() {
    }

    private static class PrintingProgressMonitor
    extends NullProgressMonitor {
        private PrintingProgressMonitor() {
        }

        public void beginTask(String name, int totalWork) {
            if (name != null && name.length() > 0) {
                System.out.println(name);
            }
        }
    }

    private static class SavedToolOption {
        final String toolId;
        final String optionId;
        final Object value;

        SavedToolOption(String toolId, String optionId, Object value) {
            this.toolId = toolId;
            this.optionId = optionId;
            this.value = value;
        }

        public int hashCode() {
            return this.toolId.hashCode() + this.optionId.hashCode();
        }

        public boolean equals(Object obj) {
            SavedToolOption option = (SavedToolOption)obj;
            return this.toolId.equals(option.toolId) && this.optionId.equals(option.optionId);
        }
    }

    private static class ToolOption {
        public static final int REPLACE = 0;
        public static final int APPEND = 1;
        public static final int PREPEND = 2;
        public static final int REMOVE = 3;
        final String toolId;
        final String optionId;
        final String value;
        final int operation;

        ToolOption(String toolId, String optionId, String value, int operation) {
            this.toolId = toolId;
            this.optionId = optionId;
            this.value = value;
            this.operation = operation;
        }
    }
}

