/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core;

import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ISourceLocator;

public class S32DSGdbLaunch
extends GdbLaunch {
    private static final String PYTHON_PATH = "PYTHONPATH";
    private static final String S32DS_PYTHON_PATH = "${S32DS_PYTHONPATH}";
    private static List<S32DSGdbLaunch> allLaunches = new ArrayList<S32DSGdbLaunch>();

    public S32DSGdbLaunch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        super(launchConfiguration, mode, locator);
        allLaunches.add(this);
    }

    public String[] getLaunchEnvironment() throws CoreException {
        String[] launchEnvironment = super.getLaunchEnvironment();
        ArrayList<String> environmentList = new ArrayList<String>();
        if (launchEnvironment.length == 0) {
            Map<String, String> environment = System.getenv();
            for (String key : environment.keySet()) {
                this.addEnvironmentVariable(environmentList, key, environment.get(key));
            }
        } else {
            String[] stringArray = launchEnvironment;
            int n = launchEnvironment.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                environmentList.add(value);
                ++n2;
            }
        }
        if ("win32".equals(Platform.getOS())) {
            this.addEnvironmentVariable(environmentList, PYTHON_PATH, S32DS_PYTHON_PATH);
        }
        return environmentList.toArray(new String[environmentList.size()]);
    }

    public void shutdownSession(RequestMonitor rm) {
        if (!S32DSGdbLaunch.isShutdowned(this)) {
            allLaunches.remove((Object)this);
            super.shutdownSession(rm);
        } else {
            rm.done();
        }
    }

    public static boolean isShutdowned(S32DSGdbLaunch launch) {
        return !allLaunches.contains((Object)launch);
    }

    private void addEnvironmentVariable(List<String> environment, String variableName, String variableValue) {
        StringBuilder builder = new StringBuilder();
        builder.append(variableName);
        builder.append("=");
        builder.append(DebuggerUtils.substitute(variableValue));
        boolean isVariableFound = false;
        int i = 0;
        while (i < environment.size()) {
            if (environment.get(i).startsWith(variableName)) {
                environment.set(i, builder.toString());
                isVariableFound = true;
                break;
            }
            ++i;
        }
        if (!isVariableFound) {
            environment.add(builder.toString());
        }
    }
}

