/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core;

import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceCoreDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.DeviceDebuggerDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.CoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.USBDeviceAccessor;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.variables.VariablesPlugin;

public class DebuggerUtils {
    private static final String VALUE_EMPTY = "";

    public static String substitute(String pathVariable) {
        try {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(pathVariable);
        }
        catch (CoreException e) {
            DebuggerCoreActivator.log(e.getStatus());
            return VALUE_EMPTY;
        }
    }

    public static Collection<String> getActiveUSBS32DebuggerTapDevices() {
        USBDeviceAccessor usbDeviceAccessor = DebuggerCoreActivator.getDefault().getUSBDeviceAccessor();
        if (usbDeviceAccessor == null) {
            return Collections.emptyList();
        }
        return usbDeviceAccessor.getActiveTAPDevices();
    }

    public static Collection<String> getActiveUSBCmsisDapDevices() {
        USBDeviceAccessor usbDeviceAccessor = DebuggerCoreActivator.getDefault().getUSBDeviceAccessor();
        if (usbDeviceAccessor == null) {
            return Collections.emptyList();
        }
        return usbDeviceAccessor.getActiveCMSISDAPDevices();
    }

    public static DeviceCoreDescriptor[] retrieveDeviceCoreDebuggerDescriptors(String debuggerId) {
        List descriptors = DeviceCoreDebuggerDescriptors.getDeviceCoreDebuggerDescriptorById((String)debuggerId);
        ArrayList<DeviceCoreDescriptor> resultDeviceCoreDesriptors = new ArrayList<DeviceCoreDescriptor>();
        for (DeviceCoreDebuggerDescriptor debuggerDescriptor : descriptors) {
            DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)debuggerDescriptor.getDeviceCoreId());
            resultDeviceCoreDesriptors.add(deviceCoreDescriptor);
        }
        return resultDeviceCoreDesriptors.toArray(new DeviceCoreDescriptor[resultDeviceCoreDesriptors.size()]);
    }

    public static DeviceDescriptor[] retrieveDeviceDescriptors(String debuggerId) {
        ArrayList<DeviceDescriptor> deviceDescriptors = new ArrayList<DeviceDescriptor>();
        List deviceDebuggerDescriptors = DeviceDebuggerDescriptors.getDeviceDebuggerRegistry().getDeviceDebuggerDescriptorsByDebuggerId(debuggerId);
        for (DeviceDebuggerDescriptor iter : deviceDebuggerDescriptors) {
            DeviceDescriptor deviceDescriptor = DeviceDescriptors.getDeviceRegistry().getDeviceDescriptor(iter.getDeviceId());
            if (deviceDescriptor == null) continue;
            deviceDescriptors.add(deviceDescriptor);
        }
        return deviceDescriptors.toArray(new DeviceDescriptor[0]);
    }

    public static String retrieveDeviceName(DeviceCoreDebuggerDescriptor deviceDebuggerCoreDescriptor) {
        DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceDebuggerCoreDescriptor.getDeviceCoreId());
        if (deviceCoreDescriptor != null) {
            String deviceId = deviceCoreDescriptor.getDeviceId();
            return DeviceDescriptors.getDeviceDescriptor((String)deviceId).getName();
        }
        return VALUE_EMPTY;
    }

    public static String retrieveCoreName(DeviceCoreDebuggerDescriptor deviceDebuggerCoreDescriptor) {
        DeviceCoreDescriptor deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceDebuggerCoreDescriptor.getDeviceCoreId());
        if (deviceCoreDescriptor != null) {
            return deviceCoreDescriptor.getName();
        }
        return VALUE_EMPTY;
    }

    public static String retrieveGdbClientVariable(String coreType, String debuggerId) {
        return CoreDebuggerDescriptors.getClientPath((String)coreType, (String)debuggerId);
    }

    public static String retrieveCoreType(DeviceCoreDescriptor deviceCoreDescriptor) {
        if (deviceCoreDescriptor != null) {
            return deviceCoreDescriptor.getCoreId();
        }
        return VALUE_EMPTY;
    }

    public static String retrieveInitializationScriptPath(DeviceCoreDescriptor deviceCoreDescriptor, String debuggerId) {
        return DeviceCoreDebuggerDescriptors.getInitScript((String)deviceCoreDescriptor.getId(), (String)debuggerId);
    }

    public static String retrieveDefaultInitializationScriptPath(DeviceCoreDescriptor deviceCoreDescriptor, String debuggerId) {
        return DeviceDebuggerDescriptors.getInitializationScriptPath((String)deviceCoreDescriptor.getId(), (String)debuggerId);
    }

    public static String retrieveDefaultInitializationScriptPath(DeviceDescriptor deviceDescriptor, String debuggerId) {
        return DeviceDebuggerDescriptors.getInitializationScriptPath((String)deviceDescriptor.getId(), (String)debuggerId);
    }

    public static IBinary[] getProjectBinaries(ICProject cproject) throws CModelException {
        return cproject.getBinaryContainer().getBinaries();
    }

    public static String getProjectBinary(ICProject cProject) throws CModelException {
        String binary = VALUE_EMPTY;
        IBinary[] bins = DebuggerUtils.getProjectBinaries(cProject);
        if (bins != null && bins.length > 0) {
            binary = bins[0].getResource().getProjectRelativePath().toString();
        }
        return binary;
    }

    public static ICProject searchForProjectByBinary(String binaryPath) throws CModelException {
        ICProject[] projects;
        ICProject[] iCProjectArray = projects = CoreModel.getDefault().getCModel().getCProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IBinary[] bins;
            ICProject curProject = iCProjectArray[n2];
            IBinary[] iBinaryArray = bins = DebuggerUtils.getProjectBinaries(curProject);
            int n3 = bins.length;
            int n4 = 0;
            while (n4 < n3) {
                String binaryInProjectPath;
                IBinary bin = iBinaryArray[n4];
                IPath projectPath = curProject.getProject().getLocation();
                String fullBinaryPath = projectPath.append(binaryInProjectPath = bin.getResource().getProjectRelativePath().toString()).toString();
                if (fullBinaryPath.equals(binaryPath)) {
                    return curProject;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public static String getAbsoluteBinaryPathByProjectName(String projectName, String binaryPath) {
        if (binaryPath == null) {
            return null;
        }
        if (projectName == null || projectName.isEmpty() || binaryPath.isEmpty()) {
            return binaryPath;
        }
        try {
            IPath projectLocation = CoreModel.getDefault().getCModel().getCProject(projectName).getProject().getLocation();
            return new File(binaryPath).exists() || projectLocation == null ? binaryPath : projectLocation.append(binaryPath).toString();
        }
        catch (Exception exception) {
            return binaryPath;
        }
    }

    public static String getVirtualIPFromDevice(String device) {
        USBDeviceAccessor usbDeviceAccessor = DebuggerCoreActivator.getDefault().getUSBDeviceAccessor();
        if (usbDeviceAccessor == null) {
            return null;
        }
        return usbDeviceAccessor.getVirtualIP(device);
    }

    public static String getVirtualIPFromHostOrIP(String hostOrIP) {
        USBDeviceAccessor usbDeviceAccessor = DebuggerCoreActivator.getDefault().getUSBDeviceAccessor();
        if (usbDeviceAccessor == null) {
            return null;
        }
        return "s32dbg:" + hostOrIP;
    }
}

