/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core;

import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.util.Map;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.gdb.launching.FinalLaunchSequence_7_12;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunch;

public abstract class DebuggerLaunchSequence
extends FinalLaunchSequence_7_12 {
    protected static final String PY_SECURE_TYPE = "py _SECURE_TYPE = \"%s\"";
    protected static final String PY_SECURE_KEY = "py _SECURE_KEY = \"%s\"";
    protected DsfServicesTracker tracker;
    protected S32DSGdbLaunch launch;
    protected String keyWord;

    public DebuggerLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        Object curLaunch = session.getModelAdapter(ILaunch.class);
        if (curLaunch != null && curLaunch instanceof S32DSGdbLaunch) {
            this.launch = (S32DSGdbLaunch)((Object)curLaunch);
        } else {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.ui.handlers.noLaunchFailureStatusHandler", ErrorStatuses.getGDBNoLaunchStatus());
        }
        this.keyWord = "";
    }

    protected String getSecureDebuggingKeyWord() {
        try {
            Object result = RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.ui.handlers.passwordEnterStatusHandler").handleStatus(null, (Object)this);
            if (result instanceof String) {
                this.keyWord = (String)result;
            }
        }
        catch (CoreException ex) {
            DebuggerCoreActivator.log(ex.getStatus());
        }
        return this.keyWord;
    }

    protected void cleanUp() {
        if (this.tracker != null) {
            this.tracker.dispose();
            this.tracker = null;
        }
    }

    public void shutdownOnError(String handlerId, IStatus status) {
        if (this.launch != null) {
            this.launch.shutdownSession((RequestMonitor)new ImmediateRequestMonitor());
        } else {
            this.getSession().getExecutor().shutdown();
        }
        if (status != null) {
            try {
                RcpStatusHandlers.getStatusHandlerService().getStatusHandler(handlerId).handleStatus(status, (Object)this);
                RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.s32debugger.group.launch.s32DebuggerGroupLaunchNetworkErrorHandler").handleStatus(null, (Object)this.launch);
            }
            catch (CoreException ex) {
                DebuggerCoreActivator.log(ex.getStatus());
            }
        }
    }
}

