/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core;

import com.nxp.s32ds.debug.ide.core.USBDeviceAccessor;
import com.nxp.s32ds.ext.rcp.runtime.Extensions;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class DebuggerCoreActivator
implements BundleActivator {
    public static final String BUNDLE_ID = "com.nxp.s32ds.debug.ide.core";
    public static final String DEBUGGER_BACKEND_PROCEESS_NAME = "S32 Debugger";
    private static final String USB_DEVICE_EXTENSION_POINT = "usbDevice";
    private static final String USB_DEVICE_ACCESSOR_ELEMENT = "accessor";
    private static final String USB_DEVICE_ACCESSOR_CLASS = "class";
    public static final String DEBUGGER_ERROR_STATUS_HANDLER_ID = "com.nxp.s32ds.debug.ide.ui.handlers.noLaunchFailureStatusHandler";
    public static final String HANDLER_CONSOLE_KILLER = "com.nxp.s32ds.debug.ide.ui.handlers.consolesKillerStatusHandler";
    public static final String GROUP_LAUNCH_ERROR_HANDLER = "com.nxp.s32ds.debug.ide.s32debugger.group.launch.s32DebuggerGroupLaunchNetworkErrorHandler";
    public static final String HANDLER_ID_PASSWORD_ENTER = "com.nxp.s32ds.debug.ide.ui.handlers.passwordEnterStatusHandler";
    private static BundleContext context;
    private static DebuggerCoreActivator activator;
    private USBDeviceAccessor usbDeviceAccessor;

    public static DebuggerCoreActivator getDefault() {
        return activator;
    }

    public static boolean debuggerStopped() {
        return activator == null;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        activator = this;
        String extensionPointName = USB_DEVICE_EXTENSION_POINT;
        String elementName = USB_DEVICE_ACCESSOR_ELEMENT;
        String attributeName = USB_DEVICE_ACCESSOR_CLASS;
        this.usbDeviceAccessor = (USBDeviceAccessor)Extensions.createImplementation((String)BUNDLE_ID, (String)extensionPointName, (String)elementName, (String)attributeName, USBDeviceAccessor.class);
        if (this.usbDeviceAccessor == null) {
            DebuggerCoreActivator.logError("USB Device accessor implementation not found");
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.usbDeviceAccessor = null;
        activator = null;
        context = null;
    }

    public USBDeviceAccessor getUSBDeviceAccessor() {
        return this.usbDeviceAccessor;
    }

    public static IStatus log(IStatus status) {
        if (context != null) {
            Platform.getLog((Bundle)context.getBundle()).log(status);
        }
        return status;
    }

    public static void logError(String message) {
        DebuggerCoreActivator.log((IStatus)new Status(4, BUNDLE_ID, message));
    }

    public static void logWarning(String message) {
        DebuggerCoreActivator.log((IStatus)new Status(2, BUNDLE_ID, message));
    }

    public static IStatus createError(String message) {
        return new Status(4, BUNDLE_ID, message);
    }
}

