/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core;

import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.S32DSGdbLaunch;
import com.nxp.s32ds.debug.ide.core.S32DSGdbServerProcess;
import com.nxp.s32ds.debug.ide.internal.core.ErrorMessages;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.gdb.service.GDBBackend_7_12;
import org.eclipse.cdt.dsf.gdb.service.SessionType;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.debug.core.model.IStreamsProxy;

public abstract class DebuggerBackend
extends GDBBackend_7_12 {
    private static final Pattern PATTERN_GTA_LOADED = Pattern.compile(".*gta is listening on port.*");
    private static final Pattern PATTERN_NETWORK_ERROR = Pattern.compile(".*ccs:Cable disconnected.*|.*ccs:Network fault.*|.*ccs:CC communications fault.*");
    private static final Pattern PATTERN_ADDRESS_IS_BUSY = Pattern.compile(".*address already in use.*");
    private static final String HANDLER_DEBUGGER_ERROR = "com.nxp.s32ds.debug.ide.s32debugger.ui.debuggerFailureStatusHandler";
    private static final String HANDLER_NETWORK_ERROR = "com.nxp.s32ds.debug.ide.s32debugger.ui.networkErrorStatusHandler";
    protected S32DSGdbServerProcess server;
    protected S32DSGdbLaunch s32dsGdbLaunch;
    protected ILaunchConfiguration lc;
    private boolean streamsContol;
    private static DebuggerBackend backendSuspended = null;
    private static RequestMonitor initialCoreMonitor = null;
    private RcpStatusHandler consoleCloserHandler;
    private final IStreamListener errorStreamListener;
    private IStreamMonitor errorStreamMonitor;

    public DebuggerBackend(DsfSession session, ILaunchConfiguration lc) {
        super(session, lc);
        this.lc = lc;
        this.server = null;
        this.errorStreamListener = new IStreamListener(){

            public void streamAppended(String text, IStreamMonitor monitor) {
                if (DebuggerBackend.this.streamsContol) {
                    DebuggerBackend.this.checkLineForPatterns(text);
                }
            }
        };
        this.s32dsGdbLaunch = null;
        Object launch = session.getModelAdapter(ILaunch.class);
        if (launch instanceof S32DSGdbLaunch) {
            this.s32dsGdbLaunch = (S32DSGdbLaunch)((Object)launch);
        }
    }

    public abstract String getCommandLine();

    public abstract File getWorkingDirectory();

    public abstract String getProcessName();

    public S32DSGdbServerProcess launchGdbServer(String[] commands, File workingDirectory) throws CoreException {
        if (this.s32dsGdbLaunch != null) {
            return S32DSGdbServerProcess.getInstance(commands, this.s32dsGdbLaunch.getLaunchEnvironment(), workingDirectory);
        }
        return null;
    }

    public void shutdown(RequestMonitor rm) {
        S32DSGdbServerProcess.removeLaunch(this.s32dsGdbLaunch);
        if (this.server != null) {
            boolean forceShutdown = DebuggerCoreActivator.debuggerStopped() || this.server.isServerTerminated();
            boolean hasInitialLaunch = S32DSGdbServerProcess.hasInitialLaunch();
            boolean hasLaunches = S32DSGdbServerProcess.hasLaunches();
            if (!forceShutdown && !hasInitialLaunch && hasLaunches) {
                backendSuspended = this;
                initialCoreMonitor = rm;
                return;
            }
            this.interrupt();
            super.shutdown(rm);
            if (DebuggerCoreActivator.debuggerStopped()) {
                try {
                    this.consoleCloserHandler.handleStatus(null, (Object)this);
                }
                catch (CoreException ex) {
                    DebuggerCoreActivator.log(ex.getStatus());
                }
                this.consoleCloserHandler = null;
            }
            if (this.errorStreamMonitor != null) {
                this.errorStreamMonitor.removeListener(this.errorStreamListener);
                this.errorStreamMonitor = null;
            }
            if (!this.server.isServerTerminated()) {
                this.server.terminate();
            }
        } else {
            this.interrupt();
            super.shutdown(rm);
            if (!S32DSGdbServerProcess.hasLaunches() && backendSuspended != null) {
                backendSuspended.shutdown(initialCoreMonitor);
                backendSuspended = null;
                initialCoreMonitor = null;
            }
        }
    }

    public void initialize(RequestMonitor rm) {
        super.initialize(rm);
        this.register(new String[]{DebuggerBackend.class.getName()}, new Hashtable());
        if (this.server == null) {
            S32DSGdbServerProcess.addLaunch(this.s32dsGdbLaunch);
        } else {
            this.consoleCloserHandler = RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.ui.handlers.consolesKillerStatusHandler");
        }
    }

    public void interrupt() {
        if (this.server != null) {
            if (this.getSessionType() == SessionType.REMOTE) {
                this.server.interrupt();
            } else {
                this.server.interruptCTRLC();
            }
        }
    }

    public boolean initializeGdbServerProcess() {
        boolean serverAttached = false;
        if (this.server != null) {
            if (!this.server.isAlive()) {
                this.handleProcessStartup(this.server.getErrorStream());
            } else if (this.handleProcessStartup(this.server.getInputStreamEx())) {
                IProcess consoleProcess = DebugPlugin.newProcess((ILaunch)this.s32dsGdbLaunch, (Process)((Object)this.server), (String)this.getProcessName());
                consoleProcess.setAttribute(IProcess.ATTR_CMDLINE, this.getCommandLine());
                consoleProcess.setAttribute("org.eclipse.cdt.dsf.gdb.createProcessType", "org.eclipse.cdt.dsf.gdb.gdbProcess");
                serverAttached = this.attachErrorControlToProcess(consoleProcess.getStreamsProxy());
                if (!serverAttached) {
                    this.postStatus(HANDLER_DEBUGGER_ERROR, ErrorMessages.DebuggerCannotStart_reason_no_error_control_message);
                } else {
                    S32DSGdbServerProcess.addLaunch(this.s32dsGdbLaunch);
                    this.streamsContol = true;
                }
            }
        }
        return serverAttached;
    }

    private boolean matchPattern(String value, Pattern pattern) {
        return pattern.matcher(value).find();
    }

    private void checkLineForPatterns(String line) {
        if (this.matchPattern(line, PATTERN_NETWORK_ERROR)) {
            this.streamsContol = false;
            Boolean result = Boolean.FALSE;
            try {
                result = (Boolean)RcpStatusHandlers.getStatusHandlerService().getStatusHandler("com.nxp.s32ds.debug.ide.s32debugger.group.launch.s32DebuggerGroupLaunchNetworkErrorHandler").handleStatus((IStatus)new Status(4, "com.nxp.s32ds.debug.ide.core", ErrorMessages.NetworkErrorStatusHandler_reason_message), (Object)this.s32dsGdbLaunch);
            }
            catch (CoreException ex) {
                DebuggerCoreActivator.log(ex.getStatus());
            }
            if (!result.booleanValue()) {
                S32DSGdbServerProcess.shutdownOnError();
            }
            this.postStatus(HANDLER_NETWORK_ERROR, ErrorMessages.NetworkErrorStatusHandler_reason_message);
        }
    }

    private void postStatus(String handlerId, String message) {
        try {
            RcpStatusHandlers.handleStatus((String)handlerId, (IStatus)new Status(4, "com.nxp.s32ds.debug.ide.core", message), (Object)((Object)this.s32dsGdbLaunch));
        }
        catch (CoreException coreException) {
            DebuggerCoreActivator.logError(ErrorMessages.DebuggerCannotHandleError_message);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean handleProcessStartup(InputStream processStream) {
        boolean serverOutputFound;
        block20: {
            serverOutputFound = false;
            if (processStream != null) {
                try {
                    Throwable throwable = null;
                    Object var4_6 = null;
                    try {
                        InputStreamReader inputStreamReader = new InputStreamReader(processStream);
                        try {
                            try (BufferedReader bufReader = new BufferedReader(inputStreamReader);){
                                String line;
                                while (!serverOutputFound && (line = bufReader.readLine()) != null) {
                                    if (this.matchPattern(line, PATTERN_ADDRESS_IS_BUSY)) {
                                        this.postStatus(HANDLER_DEBUGGER_ERROR, ErrorMessages.BusyAddressFailureStatusHandler_reason_message);
                                        serverOutputFound = true;
                                    }
                                    if (!this.matchPattern(line, PATTERN_GTA_LOADED)) continue;
                                    serverOutputFound = true;
                                }
                            }
                            if (inputStreamReader == null) break block20;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputStreamReader == null) throw throwable;
                            inputStreamReader.close();
                            throw throwable;
                        }
                        inputStreamReader.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException ex) {
                    DebuggerCoreActivator.logError(ex.getMessage());
                }
            }
        }
        try {
            processStream.close();
        }
        catch (IOException iOException) {}
        if (serverOutputFound) return serverOutputFound;
        this.postStatus(HANDLER_DEBUGGER_ERROR, ErrorMessages.DebuggerCannotStart_reason_unknown_message);
        return serverOutputFound;
    }

    private boolean attachErrorControlToProcess(IStreamsProxy proxy) {
        boolean result = false;
        if (proxy != null) {
            this.errorStreamMonitor = proxy.getErrorStreamMonitor();
            if (this.errorStreamMonitor != null) {
                this.errorStreamMonitor.addListener(this.errorStreamListener);
                result = true;
            }
        }
        return result;
    }
}

