/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.loader;

import com.nxp.swtools.common.ui.utils.services.Rap;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.provider.sdk.ISdkFileProvider;
import com.nxp.swtools.provider.sdk.SdkFileProvider;
import com.nxp.swtools.sdkmanifest.Messages;
import com.nxp.swtools.sdkmanifest.descriptors.SdkBoardsDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkManifestDescriptor;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoader;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class SdkAllManifestsInPckg {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SdkAllManifestsInPckg.class);
    @Nullable
    final String sdkRootAbsolutePath;
    final Collection<SdkManifestDescriptor> allManifests;
    @NonNull
    String sdkPathValidationProblem = "";
    private Map<@NonNull String, SdkDeviceDescriptor> supportedDevices = null;
    Map<String, SdkBoardsDescriptor.SdkBoardDescriptor> boardDescriptorsCache = new HashMap<String, SdkBoardsDescriptor.SdkBoardDescriptor>();

    private @NonNull Collection<SdkManifestDescriptor> loadAllManifests() {
        ArrayList<SdkManifestDescriptor> result = new ArrayList<SdkManifestDescriptor>();
        Collection<@NonNull String> manifestsPaths = ManifestLoaderUtils.findManifestsInDir(this.sdkRootAbsolutePath);
        if (manifestsPaths.isEmpty()) {
            File dir = new File(this.sdkRootAbsolutePath);
            if (!dir.exists()) {
                this.setPathValidationProblem(String.format(Messages.get().MNFST_INVALID_SDK_PATH, this.sdkRootAbsolutePath));
            } else {
                this.setPathValidationProblem(Messages.get().MNFST_NO_MANIFEST_FOUND);
            }
            return result;
        }
        String curSdkAbsolutePath = this.sdkRootAbsolutePath;
        assert (curSdkAbsolutePath != null);
        ArrayList<@NonNull String> errMsgs = new ArrayList<String>();
        for (String path : manifestsPaths) {
            File file = new File(path);
            Object loadResult = ManifestLoader.loadManifestDocIfValid(file, false);
            if (loadResult instanceof Document) {
                SdkManifestDescriptor manifestDescr = ManifestLoader.loadManifestDocument((Document)loadResult, (ISdkFileProvider)new SdkFileProvider(curSdkAbsolutePath), curSdkAbsolutePath);
                result.add(manifestDescr);
                continue;
            }
            if (!(loadResult instanceof String)) continue;
            errMsgs.add((String)loadResult);
            LOGGER.log(Level.WARNING, String.valueOf((String)loadResult) + '-' + file.getAbsolutePath());
        }
        if (result.isEmpty()) {
            String errMsg = Messages.get().MNFST_NO_VALID_MANIFEST;
            errMsg = errMsgs.size() == 1 ? String.valueOf(errMsg) + " " + (String)errMsgs.get(0) : String.valueOf(errMsg) + " " + Messages.get().MNFST_SEE_LOG_FOR_DETAILS;
            this.setPathValidationProblem(errMsg);
        }
        return CollectionsUtils.unmodifiableList(result);
    }

    public SdkAllManifestsInPckg(@Nullable String sdkRootAbsolutePath) {
        if (Rap.isActive()) assert (false);
        this.sdkRootAbsolutePath = sdkRootAbsolutePath;
        this.allManifests = this.loadAllManifests();
    }

    public @Nullable String getSdkRoot() {
        return this.sdkRootAbsolutePath;
    }

    public Collection<SdkManifestDescriptor> getAllManifests() {
        return this.allManifests;
    }

    public @NonNull String getPathValidationProblem() {
        return this.sdkPathValidationProblem;
    }

    private void setPathValidationProblem(@Nullable String message) {
        if (message == null || message.isEmpty()) {
            assert (false);
            message = "Unknwon error";
        }
        assert (this.sdkPathValidationProblem.isEmpty());
        this.sdkPathValidationProblem = message;
    }

    public boolean isEmpty() {
        return this.sdkRootAbsolutePath == null || this.allManifests.isEmpty();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @NonNull Map<@NonNull String, SdkDeviceDescriptor> getSupportedDevices() {
        @NonNull Map result = this.supportedDevices;
        if (result == null) {
            result = new HashMap<String, SdkDeviceDescriptor>();
            for (SdkManifestDescriptor curManifest : this.getAllManifests()) {
                for (SdkDeviceDescriptor device : curManifest.getSdkDevicesDescriptor().getSdkDeviceDescriptors()) {
                    SdkDeviceDescriptor curDevice = (SdkDeviceDescriptor)result.get(device.getId());
                    if (curDevice != null) {
                        if (device.getVersion().compareTo(curDevice.getVersion()) <= 0) continue;
                        result.put(device.getId(), device);
                        continue;
                    }
                    result.put(device.getId(), device);
                }
            }
            this.supportedDevices = result = CollectionsUtils.unmodifiableMap(result);
        }
        return result;
    }

    public @NonNull Map<@NonNull String,  @NonNull SdkBoardsDescriptor.SdkBoardDescriptor> getSupportedBoards() {
        HashMap<@NonNull String,  @NonNull SdkBoardsDescriptor.SdkBoardDescriptor> result = new HashMap<String, SdkBoardsDescriptor.SdkBoardDescriptor>();
        for (SdkManifestDescriptor manifest : this.getAllManifests()) {
            for (SdkBoardsDescriptor.SdkBoardDescriptor board : manifest.getSdkBoardsDescriptor().getSdkBoardDescriptors()) {
                if (board.getProcessor() == null) continue;
                result.put(board.getId(), board);
            }
        }
        return result;
    }

    public  @Nullable SdkBoardsDescriptor.SdkBoardDescriptor getBoardDescriptor(@NonNull String boardName) {
        SdkBoardsDescriptor.SdkBoardDescriptor result = this.boardDescriptorsCache.get(boardName);
        if (result == null) {
            for (SdkManifestDescriptor manifest : this.getAllManifests()) {
                SdkBoardsDescriptor.SdkBoardDescriptor curBoard = manifest.getSdkBoardsDescriptor().findBoardByName(boardName);
                if (curBoard == null) continue;
                if (result == null) {
                    result = curBoard;
                    continue;
                }
                SdkDeviceDescriptor processor = result.getProcessor();
                String processorFullName = processor == null ? result.getPartNumber() : processor.getFullName();
                SdkManifestDescriptor brdManifest = ManifestLoader.manifestMergeAndLoad(this.sdkRootAbsolutePath, processorFullName, result.getSubDir());
                SdkBoardsDescriptor.SdkBoardDescriptor brd = brdManifest.getSdkBoardsDescriptor().findBoardByName(boardName);
                if (brd == null) break;
                result = brd;
                break;
            }
            this.boardDescriptorsCache.put(boardName, result);
        }
        return result;
    }
}

