/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.sdkmanifest.descriptors.SdkManifestDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkSourceBase;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Element;

public class SdkSourceFile
extends SdkSourceBase {
    @NonNull
    private final String type;
    @Nullable
    private final String targetPath;
    @NonNull
    private final String variant;
    @NonNull
    private final String compilerId;
    @Deprecated
    @NonNull
    private final String coreType;
    @Nullable
    private final Collection<@NonNull String> deviceCoreIds;
    @Nullable
    private final Collection<@NonNull String> toolchains;
    private final boolean excluded;
    @NonNull
    private final Collection<String> conditionComponents;

    public SdkSourceFile(@NonNull String path, @Nullable String targetPath, @NonNull String fileMask, @NonNull String type, @Nullable String variant, @Nullable String compilerId, @Nullable String coreType, @Nullable Collection<@NonNull String> deviceCoreIds, @Nullable Collection<@NonNull String> toolchains, boolean excluded, @NonNull Collection<String> condition) {
        super(path, fileMask);
        this.type = type;
        this.targetPath = targetPath;
        this.variant = UtilsText.safeString((String)variant);
        this.compilerId = UtilsText.safeString((String)compilerId);
        this.coreType = UtilsText.safeString((String)coreType);
        this.deviceCoreIds = deviceCoreIds != null ? CollectionsUtils.unmodifiableCollection(deviceCoreIds) : null;
        this.toolchains = toolchains;
        if (toolchains != null) {
            toolchains.forEach(t -> {
                if (!ManifestLoaderUtils.isKnownToolchain(t)) {
                    LOGGER.severe("Unsupported toolchain ID in `source` XML element: " + t);
                }
            });
        }
        this.excluded = excluded;
        this.conditionComponents = CollectionsUtils.unmodifiableCollection(condition);
    }

    public SdkSourceFile(@NonNull SdkSourceFile source, @NonNull SdkManifestDescriptor.ManifestHelper variableResolver) {
        super(variableResolver.resolveVariables(source.getPath()), variableResolver.resolveVariables(source.getFileMask()));
        this.type = source.type;
        this.targetPath = source.targetPath;
        this.compilerId = source.compilerId;
        this.toolchains = source.toolchains;
        this.coreType = source.coreType;
        this.deviceCoreIds = source.deviceCoreIds;
        this.variant = source.variant;
        this.excluded = source.excluded;
        this.conditionComponents = source.conditionComponents;
    }

    public @NonNull SdkSourceFile cloneToExcluded() {
        assert (!this.excluded);
        return new SdkSourceFile(this.getPath(), this.targetPath, this.getFileMask(), this.type, this.variant, this.compilerId, this.coreType, this.deviceCoreIds, this.toolchains, true, this.conditionComponents);
    }

    public @NonNull String getVariant() {
        return this.variant;
    }

    public @NonNull String getCompilerId() {
        return this.compilerId;
    }

    public @Nullable Collection<@NonNull String> getToolchains() {
        return this.toolchains;
    }

    public boolean isForToolchain(@NonNull String toolchainId) {
        return this.toolchains != null ? this.toolchains.contains(toolchainId) : true;
    }

    public @NonNull String getCoreType() {
        return this.coreType;
    }

    public boolean isDeviceCoreSupported(@NonNull String coreId) {
        return this.deviceCoreIds != null ? this.deviceCoreIds.contains(coreId) : true;
    }

    public @NonNull String getType() {
        return this.type;
    }

    public @Nullable String getTargetPath() {
        return this.targetPath;
    }

    public boolean isExcludedFromBuild() {
        return this.excluded;
    }

    public @NonNull Collection<String> getConditionComponents() {
        return this.conditionComponents;
    }

    public static @NonNull List<@NonNull SdkSourceFile> loadSourceFiles(@NonNull Element parElem, int majorFormatVersion, boolean applyFreeRTOSheapExcludeWorkaround) {
        ArrayList<@NonNull SdkSourceFile> result = new ArrayList<SdkSourceFile>();
        String toolchainAttrName = majorFormatVersion <= 2 ? "tool" : "toolchain";
        boolean containsExcludeAttr = false;
        List<Element> sourcesNodeList = ManifestLoaderUtils.getChildrenElements(parElem, "source");
        for (Element elemSource : sourcesNodeList) {
            if (elemSource.hasAttribute("path") && elemSource.hasAttribute("type")) {
                boolean excluded;
                String targetPath;
                String type = elemSource.getAttribute("type");
                String path = elemSource.getAttribute("path");
                String string = targetPath = elemSource.hasAttribute("target_path") ? elemSource.getAttribute("target_path") : null;
                if (elemSource.hasAttribute("excluded") || elemSource.hasAttribute("exclude")) {
                    containsExcludeAttr = true;
                    excluded = ManifestLoaderUtils.isXmlTrue(elemSource.getAttribute("excluded")) || ManifestLoaderUtils.isXmlTrue(elemSource.getAttribute("exclude"));
                } else {
                    excluded = false;
                }
                List<Element> childrenNodeList = ManifestLoaderUtils.getChildrenElements(elemSource, "files");
                for (Element elemFiles : childrenNodeList) {
                    List<String> conditionComps;
                    String conditionCompsStr;
                    assert (type != null && path != null);
                    String mask = UtilsText.safeString((String)elemFiles.getAttribute("mask"));
                    String string2 = conditionCompsStr = majorFormatVersion >= 3 ? UtilsText.safeString((String)elemSource.getAttribute("condition")) : "";
                    if (conditionCompsStr.isEmpty()) {
                        conditionComps = CollectionsUtils.emptyList();
                    } else {
                        conditionComps = Arrays.asList(conditionCompsStr.split(" "));
                        assert (conditionComps != null);
                    }
                    List<String> deviceCoreIds = null;
                    if (elemSource.hasAttribute("device_cores")) {
                        deviceCoreIds = Arrays.asList(elemSource.getAttribute("device_cores").split(" "));
                    }
                    List<String> toolchains = null;
                    if (elemSource.hasAttribute(toolchainAttrName)) {
                        toolchains = Arrays.asList(elemSource.getAttribute(toolchainAttrName).split(" "));
                    }
                    SdkSourceFile componentSource = new SdkSourceFile(path, targetPath, mask, type, elemSource.getAttribute("variant"), elemSource.getAttribute("compiler"), elemSource.getAttribute("core"), deviceCoreIds, toolchains, excluded, conditionComps);
                    result.add(componentSource);
                }
                continue;
            }
            assert (false);
        }
        if (applyFreeRTOSheapExcludeWorkaround && !containsExcludeAttr) {
            Iterator iter = result.iterator();
            ArrayList<@NonNull SdkSourceFile> excludedFiles = new ArrayList<SdkSourceFile>();
            while (iter.hasNext()) {
                SdkSourceFile file = (SdkSourceFile)iter.next();
                if (!file.getFileMask().startsWith("heap_") || !file.getFileMask().endsWith(".c") || file.getFileMask().equals("heap_4.c")) continue;
                excludedFiles.add(file.cloneToExcluded());
                iter.remove();
            }
            result.addAll(excludedFiles);
        }
        return result;
    }

    @Override
    public String toString() {
        String result = super.toString();
        return this.excluded ? "[excluded]" + result : result;
    }
}

