/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.sdkmanifest.descriptors.SdkManifestDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkOptionSimple;
import com.nxp.swtools.sdkmanifest.descriptors.SdkOptionStrList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class SdkOptionBase {
    @NonNull
    protected final String optionId;
    @NonNull
    protected final String name;
    @NonNull
    protected final String typeString;
    @NonNull
    protected final SdkOptionType type;
    @NonNull
    protected final @NonNull String @NonNull [] variants;
    @NonNull
    public static final String[] PROJECT_BUILD_CONFIGURATIONS = new String[]{"Debug", "Release"};
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SdkOptionBase.class);
    @NonNull
    public static final String CONFIGURATION_VARIANT_PREFIX = "Configuration_";
    @NonNull
    public static final @NonNull String @NonNull [] DEBUG_CONFIGURATION_VARIANT = new String[]{"Configuration_Debug"};
    @NonNull
    public static final @NonNull String @NonNull [] RELEASE_CONFIGURATION_VARIANT = new String[]{"Configuration_Release"};
    private static final Set<String> sortableStringListIds = new HashSet<String>();

    public static SdkOptionBase createSdkOption(@NonNull String id, @NonNull String name, @NonNull List<@NonNull String> values, @NonNull String typeStr, @NonNull String @NonNull [] variants) {
        SdkOptionType type = SdkOptionType.getSdkOptionById(typeStr);
        switch (type) {
            case STRING_LIST: 
            case UNKNOWN: {
                return new SdkOptionStrList(id, name, values, null, typeStr, variants, false);
            }
        }
        if (values.size() != 1) {
            throw new IllegalArgumentException("Invalid option argument, expected just one value: " + id);
        }
        return new SdkOptionSimple(id, name, values.get(0), type, variants);
    }

    public SdkOptionBase(@NonNull String optionId, @NonNull String name, @NonNull String type, @NonNull String @NonNull [] variants) {
        this.optionId = optionId;
        this.name = name;
        this.typeString = type;
        this.variants = variants;
        this.type = SdkOptionType.getSdkOptionById(type);
    }

    public abstract @NonNull SdkOptionBase clone4Configuration(@NonNull String var1);

    public abstract @NonNull SdkOptionBase resolveVariables(@NonNull SdkManifestDescriptor.ManifestHelper var1);

    public @NonNull String getId() {
        return this.optionId;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String @NonNull [] getVariants() {
        @NonNull String[] result = Arrays.copyOf(this.variants, this.variants.length);
        assert (result != null);
        return result;
    }

    public @NonNull String getConfigurationName() {
        String[] stringArray = this.getVariants();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String variant = stringArray[n2];
            if (variant.startsWith(CONFIGURATION_VARIANT_PREFIX) && variant.length() > CONFIGURATION_VARIANT_PREFIX.length()) {
                return variant.substring(14);
            }
            ++n2;
        }
        return "";
    }

    public @NonNull String getTypeAsString() {
        return this.typeString;
    }

    public @NonNull SdkOptionType getType() {
        return this.type;
    }

    public static void registerSortableStringListId(@NonNull String optionId) {
        sortableStringListIds.add(optionId);
    }

    public boolean isArrayValuesSortable() {
        return SdkOptionType.STRING_LIST.equals((Object)this.getType()) && sortableStringListIds.contains(this.getId());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SdkOptionBase)) {
            return false;
        }
        assert (obj != this);
        SdkOptionBase opt = (SdkOptionBase)obj;
        return this.optionId.equals(opt.optionId) && this.name.equals(opt.name) && this.typeString.equals(this.typeString) && this.type.equals((Object)opt.type) && Arrays.deepEquals(this.variants, opt.variants);
    }

    public int hashCode() {
        return ((this.optionId.hashCode() * 17 + this.name.hashCode()) * 17 + this.type.hashCode()) * 17 + Arrays.deepHashCode(this.variants);
    }

    static SdkOptionBase mergeOptions(@NonNull SdkOptionBase opt1, @NonNull SdkOptionBase opt2) {
        ArrayList<String> prevValues;
        assert (opt1.getId().equals(opt1.getId()) && opt1.getName().equals(opt1.getName()));
        if (!opt1.getType().equals((Object)opt2.getType())) {
            assert (false);
            return null;
        }
        if (!opt1.getType().equals((Object)SdkOptionType.STRING_LIST) || !opt2.getType().equals((Object)SdkOptionType.STRING_LIST)) {
            if (opt1.equals(opt2)) {
                return opt1;
            }
            return null;
        }
        SdkOptionStrList optSL1 = (SdkOptionStrList)opt1;
        SdkOptionStrList optSL2 = (SdkOptionStrList)opt2;
        ArrayList<@NonNull String> mergedValues = new ArrayList<String>();
        mergedValues.addAll(optSL1.getValues());
        for (String value : optSL2.getValues()) {
            if (mergedValues.contains(value)) continue;
            mergedValues.add(value);
        }
        if (opt1.isArrayValuesSortable() && opt2.isArrayValuesSortable()) {
            Collections.sort(mergedValues);
        }
        if (optSL1.prevValues != null || optSL2.prevValues != null) {
            prevValues = new ArrayList<String>();
            if (optSL1.prevValues != null) {
                prevValues.addAll(optSL1.prevValues);
            }
            if (optSL2.prevValues != null) {
                prevValues.addAll(optSL2.prevValues);
            }
        } else {
            prevValues = null;
        }
        SdkOptionStrList result = new SdkOptionStrList(opt1.getId(), opt1.getName(), mergedValues, prevValues, opt1.getTypeAsString(), opt1.getVariants(), optSL1.replaceAllValues() || optSL2.replaceAllValues());
        String valuesDelimiter = optSL1.getValuesDelimiter();
        if (valuesDelimiter != null) {
            assert (valuesDelimiter.equals(optSL2.getValuesDelimiter()));
            result.setValuesDelimiter(valuesDelimiter);
        }
        return result;
    }

    public static void mergeOptionToMap(@NonNull Map<String, SdkOptionBase> optionsMap, @NonNull SdkOptionBase option, @NonNull Collection<@NonNull String> projectBuildConfigs) {
        for (String configuration : projectBuildConfigs) {
            assert (configuration != null);
            String optConfigName = option.getConfigurationName();
            if (!optConfigName.isEmpty() && !optConfigName.equals(configuration)) continue;
            SdkOptionBase option4Cfg = optConfigName.isEmpty() ? option.clone4Configuration(configuration) : option;
            String key = String.valueOf(option4Cfg.getId()) + '#' + configuration;
            SdkOptionBase existOpt = optionsMap.get(key);
            if (existOpt != null) {
                SdkOptionBase mergedOpt = SdkOptionBase.mergeOptions(option4Cfg, existOpt);
                if (mergedOpt != null) {
                    optionsMap.put(key, mergedOpt);
                    continue;
                }
                LOGGER.log(Level.SEVERE, "Duplicated toolchain option id: " + key);
                continue;
            }
            optionsMap.put(key, option4Cfg);
        }
    }

    public static enum SdkOptionType {
        BOOLEAN("boolean"),
        STRING("string"),
        STATE("state"),
        ENUM("enum"),
        STRING_LIST("stringList"),
        UNKNOWN("?");

        @NonNull
        private final String id;

        private SdkOptionType(String id) {
            this.id = id;
        }

        public @NonNull String getId() {
            return this.id;
        }

        static @NonNull SdkOptionType getSdkOptionById(@NonNull String id) {
            SdkOptionType[] sdkOptionTypeArray = SdkOptionType.values();
            int n = sdkOptionTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                SdkOptionType type = sdkOptionTypeArray[n2];
                if (type.id.equals(id)) {
                    return type;
                }
                ++n2;
            }
            return UNKNOWN;
        }
    }
}

