/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.sdkmanifest.descriptors.SdkManifestDescriptor;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Element;

public class SdkMetaData {
    @NonNull
    public static final String KEY_HTML = "html";
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SdkManifestDescriptor.class);
    @Nullable
    private final String imagePath;
    @Nullable
    private final String description;
    @NonNull
    private final @NonNull Map<@NonNull String, String> metaData;

    public static @NonNull SdkMetaData valueOf(@NonNull Element deviceElem) {
        return new SdkMetaData(deviceElem);
    }

    SdkMetaData(@NonNull Element element) {
        String descrContent;
        String imgPath = null;
        List<Element> imageElems = ManifestLoaderUtils.getChildrenElements(element, "image");
        for (Element imgElem : imageElems) {
            Element filesElem;
            if (!"image".equals(imgElem.getAttribute("type")) || (filesElem = ManifestLoaderUtils.getChildElementByName(imgElem, "files")) == null) continue;
            imgPath = String.valueOf(imgElem.getAttribute("path").replace('/', File.separatorChar)) + File.separator + filesElem.getAttribute("mask");
        }
        this.imagePath = imgPath;
        Element descriptionElem = ManifestLoaderUtils.getChildElementByName(element, "description");
        this.description = descriptionElem != null ? ((descrContent = descriptionElem.getTextContent()) != null && !descrContent.trim().isEmpty() ? descrContent : null) : null;
        HashMap<@NonNull String, String> mData = new HashMap<String, String>();
        Element mDtaSetElem = ManifestLoaderUtils.getChildElementByName(element, "metadataSet");
        if (mDtaSetElem != null) {
            List<Element> mDtaElems = ManifestLoaderUtils.getChildrenElements(mDtaSetElem, "metadata");
            for (Element mDtaElem : mDtaElems) {
                Element contentElem;
                Element specificElem;
                String key = mDtaElem.getAttribute("key");
                String value = mDtaElem.hasAttribute("value") ? mDtaElem.getAttribute("value") : ((specificElem = ManifestLoaderUtils.getChildElementByName(mDtaElem, "specific")) != null ? ((contentElem = ManifestLoaderUtils.getChildElementByName(specificElem, "content")) != null ? Objects.requireNonNull(contentElem.getTextContent()).trim() : null) : null);
                if (key.isEmpty() || mData.put(key, value) == null) continue;
                LOGGER.log(Level.SEVERE, "Duplicated metadata key: " + key);
            }
        }
        this.metaData = CollectionsUtils.unmodifiableMap(mData);
    }

    public SdkMetaData(@Nullable String testID) {
        this.imagePath = null;
        this.description = null;
        this.metaData = CollectionsUtils.emptyMap();
    }

    public @Nullable String getImagePath() {
        return this.imagePath;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    public @Nullable String getData(@NonNull String key) {
        return this.metaData.get(key);
    }
}

