/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class SdkIncludePath {
    @NonNull
    private final String path;
    @Nullable
    final String compiler;
    @Nullable
    final String toolchain;

    public SdkIncludePath(@NonNull String path, @Nullable String compilerId, @Nullable String toolchain) {
        assert (compilerId == null || toolchain == null);
        this.path = path;
        this.compiler = compilerId;
        this.toolchain = toolchain;
    }

    public @NonNull String getPath() {
        return this.path;
    }

    public @Nullable String getCompilerId() {
        return this.compiler;
    }

    public @Nullable String getToolchainId() {
        return this.toolchain;
    }

    public static @Nullable List<SdkIncludePath> loadIncludePath(@NonNull Element parentElem) {
        Element inclPathsElem = ManifestLoaderUtils.getChildElementByName(parentElem, "include_paths");
        if (inclPathsElem == null) {
            return null;
        }
        ArrayList<SdkIncludePath> result = new ArrayList<SdkIncludePath>();
        List<Element> includePathElems = ManifestLoaderUtils.getChildrenElements(inclPathsElem, "include");
        includePathElems.addAll(ManifestLoaderUtils.getChildrenElements(inclPathsElem, "include_path"));
        for (Element inclPath : includePathElems) {
            String toolchain;
            String path = inclPath.getAttribute("path");
            String compilerId = inclPath.hasAttribute("compiler") ? inclPath.getAttribute("compiler") : null;
            String string = toolchain = inclPath.hasAttribute("toolchain") ? inclPath.getAttribute("toolchain") : null;
            if (path.isEmpty()) continue;
            result.add(new SdkIncludePath(path, compilerId, toolchain));
        }
        return result;
    }
}

