/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SdkDevicesDescriptor {
    @NonNull
    private Map<String, SdkDeviceDescriptor> sdkDeviceDescriptors;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SdkDevicesDescriptor.class);

    public SdkDevicesDescriptor(@NonNull Map<String, SdkDeviceDescriptor> sdkDeviceDescriptors) {
        this.sdkDeviceDescriptors = sdkDeviceDescriptors;
    }

    public @NonNull Collection<SdkDeviceDescriptor> getSdkDeviceDescriptors() {
        ArrayList result = this.sdkDeviceDescriptors.values();
        return CollectionsUtils.unmodifiableCollection((Collection)(result == null ? new ArrayList(0) : result));
    }

    public @Nullable SdkDeviceDescriptor getSdkDeviceDescriptorByFullName(@NonNull String deviceFullName) {
        return this.sdkDeviceDescriptors.get(deviceFullName);
    }

    public @NonNull Set<@NonNull String> getSdkDeviceFullNames() {
        HashSet<@NonNull E> result = this.sdkDeviceDescriptors.keySet();
        return CollectionsUtils.unmodifiableSet((Set)(result == null ? new HashSet(0) : result));
    }

    public @Nullable SdkDeviceDescriptor getSdkDeviceDescriptorByPackageName(@NonNull String packageName) {
        for (SdkDeviceDescriptor device : this.getSdkDeviceDescriptors()) {
            List<String> packageNames = device.getPackageNames();
            if (!packageNames.contains(packageName)) continue;
            return device;
        }
        return null;
    }

    public @Nullable SdkDeviceDescriptor getSdkDeviceDescriptorById(@NonNull String id) {
        for (SdkDeviceDescriptor device : this.getSdkDeviceDescriptors()) {
            if (!id.equals(device.getId())) continue;
            return device;
        }
        return null;
    }

    public static class Builder {
        @NonNull
        private @NonNull Map<@NonNull String, SdkDeviceDescriptor> sdkDeviceDescriptors = new HashMap<String, SdkDeviceDescriptor>();

        public @NonNull Builder addSdkDeviceDescriptor(@NonNull SdkDeviceDescriptor sdkDeviceDescriptor) {
            SdkDeviceDescriptor cur = this.sdkDeviceDescriptors.get(sdkDeviceDescriptor.getFullName());
            if (cur == null || cur.getVersion().compareTo(sdkDeviceDescriptor.getVersion()) < 0) {
                this.sdkDeviceDescriptors.put(sdkDeviceDescriptor.getFullName(), sdkDeviceDescriptor);
            } else if (cur.getVersion().equals(sdkDeviceDescriptor.getVersion())) {
                LOGGER.log(Level.SEVERE, "Device duplicated in manifest: " + sdkDeviceDescriptor.getFullName());
            }
            return this;
        }

        public @NonNull SdkDevicesDescriptor build() {
            SdkDevicesDescriptor sdkDevicesDescriptor = new SdkDevicesDescriptor(this.sdkDeviceDescriptors);
            return sdkDevicesDescriptor;
        }
    }
}

