/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.sdkmanifest.descriptors.CompilerDefineSymbol;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceCore;
import com.nxp.swtools.sdkmanifest.descriptors.SdkMetaData;
import com.nxp.swtools.sdkmanifest.descriptors.SdkTagContentVersion;
import com.nxp.swtools.sdkmanifest.descriptors.SdkToolchainsSettingsDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SdkDeviceDescriptor {
    @NonNull
    private final String id;
    @NonNull
    private final String ref;
    @NonNull
    private final String fullName;
    @NonNull
    private final String name;
    @NonNull
    private final @NonNull List<@NonNull String> packageNames;
    @NonNull
    private final @NonNull Collection<@NonNull String> evalBoards;
    @NonNull
    private final SdkTagContentVersion version;
    @NonNull
    private final @NonNull Collection<@NonNull SdkDeviceCore> cores;
    @NonNull
    private final SdkMetaData metaData;
    @Nullable
    final SdkToolchainsSettingsDescriptor toolchainsDescr;
    @NonNull
    @NonNull Collection<@NonNull CompilerDefineSymbol> defines;

    public SdkDeviceDescriptor(@NonNull String id, @NonNull String ref, @NonNull String fullName, @NonNull String name, @NonNull Collection<@NonNull SdkDeviceCore> cores, @Nullable SdkToolchainsSettingsDescriptor toolchainsDescr, @NonNull SdkTagContentVersion version, @NonNull SdkMetaData metaData, @NonNull Collection<@NonNull CompilerDefineSymbol> defines, @NonNull List<@NonNull String> partNumbers, @NonNull Collection<@NonNull String> evalBoards) {
        this.id = id;
        this.ref = ref;
        this.fullName = fullName;
        this.name = name;
        this.toolchainsDescr = toolchainsDescr;
        this.packageNames = partNumbers;
        this.evalBoards = CollectionsUtils.unmodifiableCollection(evalBoards);
        this.version = version;
        this.metaData = metaData;
        this.defines = defines;
        this.cores = CollectionsUtils.unmodifiableCollection(cores);
        assert (!cores.isEmpty());
    }

    public @NonNull String getId() {
        return this.id;
    }

    public @NonNull String getRef() {
        return this.ref;
    }

    public @NonNull String getFullName() {
        return this.fullName;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull Collection<@NonNull SdkDeviceCore> getCores() {
        return this.cores;
    }

    public @NonNull Collection<@NonNull SdkDeviceCore> getCortexMCores() {
        return (Collection)this.cores.stream().filter(c -> c.isCortexM()).collect(CollectorsUtils.toList());
    }

    public @Nullable SdkDeviceCore getFirstCortexMCore() {
        for (SdkDeviceCore core : this.cores) {
            if (!core.isCortexM()) continue;
            return core;
        }
        return null;
    }

    public @NonNull List<@NonNull String> getPackageNames() {
        return CollectionsUtils.unmodifiableList(this.packageNames);
    }

    public @NonNull Collection<@NonNull String> getEvalBoardIds() {
        return this.evalBoards;
    }

    public @Nullable String getDefaultPackage() {
        return this.packageNames.isEmpty() ? null : (String)CollectionsUtils.first(this.packageNames);
    }

    public @Nullable SdkToolchainsSettingsDescriptor getToolchainsDescriptor() {
        return this.toolchainsDescr;
    }

    public @NonNull SdkTagContentVersion getVersion() {
        return this.version;
    }

    public @NonNull SdkMetaData getMetaData() {
        return this.metaData;
    }

    public @NonNull Collection<@NonNull CompilerDefineSymbol> getDefines() {
        return this.defines;
    }

    public boolean isSingleCore() {
        return this.cores.size() < 2;
    }

    public static class Builder {
        @NonNull
        private final String id;
        @NonNull
        private final String fullName;
        @NonNull
        private final String name;
        @NonNull
        private final @NonNull Collection<@NonNull SdkDeviceCore> cores;
        @NonNull
        private @NonNull List<@NonNull String> partNumbers = new ArrayList<String>();
        @NonNull
        private @NonNull Collection<@NonNull String> evalBoards = new ArrayList<String>();
        private final int majorManifestFormatVersion;
        @Nullable
        final SdkToolchainsSettingsDescriptor toolchainsDescr;
        @NonNull
        private final SdkTagContentVersion version;
        @NonNull
        private final SdkMetaData metaData;
        @NonNull
        private final @NonNull Collection<@NonNull CompilerDefineSymbol> defines;

        public Builder(@NonNull String id, @NonNull String fullName, @NonNull String name, @NonNull Collection<@NonNull SdkDeviceCore> cores, @Nullable SdkToolchainsSettingsDescriptor toolchainsDescr, @NonNull SdkTagContentVersion version, @NonNull SdkMetaData metaData, @NonNull Collection<@NonNull CompilerDefineSymbol> defines, int majorManifestFormatVersion, @NonNull List<@NonNull String> partNumbers, @NonNull Collection<@NonNull String> evalBoards) {
            this.id = id;
            this.fullName = fullName;
            this.name = name;
            assert (!cores.isEmpty());
            this.cores = cores;
            this.toolchainsDescr = toolchainsDescr;
            this.version = version;
            this.metaData = metaData;
            this.defines = defines;
            this.majorManifestFormatVersion = majorManifestFormatVersion;
            this.partNumbers = partNumbers;
            this.evalBoards = evalBoards;
        }

        public @NonNull SdkDeviceDescriptor build() {
            String ref = this.majorManifestFormatVersion < 3 ? this.name : this.id;
            return new SdkDeviceDescriptor(this.id, ref, this.fullName, this.name, this.cores, this.toolchainsDescr, this.version, this.metaData, this.defines, this.partNumbers, this.evalBoards);
        }
    }
}

