/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.sdkmanifest.descriptors.CompilerDefineSymbol;
import com.nxp.swtools.sdkmanifest.descriptors.CoreBootRole;
import com.nxp.swtools.sdkmanifest.descriptors.SdkComponentDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDevicesDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkIncludePath;
import com.nxp.swtools.sdkmanifest.descriptors.SdkSourceFile;
import com.nxp.swtools.sdkmanifest.descriptors.SdkTagContentVersion;
import com.nxp.swtools.sdkmanifest.descriptors.SdkToolchainsSettingsDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class SdkComponentsDescriptor {
    @NonNull
    private final Collection<SdkComponentDescriptor> sdkComponents;

    SdkComponentsDescriptor(@NonNull Collection<SdkComponentDescriptor> sdkComponents) {
        this.sdkComponents = CollectionsUtils.unmodifiableCollection(sdkComponents);
    }

    public @NonNull Collection<SdkComponentDescriptor> getSdkComponents() {
        return this.sdkComponents;
    }

    public @Nullable SdkComponentDescriptor getSdkComponentDescriptor(@Nullable String componentName, @NonNull String componentType, @Nullable String deviceRef) {
        SdkComponentDescriptor result4AllDevices = null;
        SdkComponentDescriptor resultDeviceSpecific = null;
        for (SdkComponentDescriptor component : this.sdkComponents) {
            Collection<String> compDevices = component.getDevices();
            if (componentName != null && !componentName.equals(component.getName()) || !componentType.equals(component.getType()) || compDevices != null && deviceRef != null && !compDevices.contains(deviceRef)) continue;
            if (compDevices != null) {
                if (resultDeviceSpecific != null && resultDeviceSpecific.getVersion().compareTo(component.getVersion()) >= 0) continue;
                resultDeviceSpecific = component;
                continue;
            }
            if (result4AllDevices != null && result4AllDevices.getVersion().compareTo(component.getVersion()) >= 0) continue;
            result4AllDevices = component;
        }
        return resultDeviceSpecific != null ? resultDeviceSpecific : result4AllDevices;
    }

    public @NonNull Collection<SdkComponentDescriptor> getSdkComponentDescriptorsByName(@NonNull String name) {
        ArrayList<SdkComponentDescriptor> componentDescriptors = new ArrayList<SdkComponentDescriptor>();
        for (SdkComponentDescriptor componentDescriptor : this.sdkComponents) {
            if (!name.equals(componentDescriptor.getName())) continue;
            componentDescriptors.add(componentDescriptor);
        }
        return componentDescriptors;
    }

    public static class Builder {
        @NonNull
        private final HashMap<String, SdkComponentDescriptor> sdkComponentsMap = new HashMap();

        public @NonNull Builder addNewSdkComponentDescriptor(@Nullable String id, @NonNull String name, @NonNull String fullName, @NonNull String brief, @NonNull String type, @Nullable String category, @Nullable Collection<@NonNull String> devices, @NonNull Collection<@NonNull SdkSourceFile> sources, @Nullable SdkToolchainsSettingsDescriptor toolsSettings, @NonNull SdkTagContentVersion version, @NonNull String[] dependencyArr, @NonNull Collection<@NonNull CompilerDefineSymbol> defines, @Nullable List<SdkIncludePath> includePaths, @Nullable Set<@NonNull CoreBootRole> reqCoreBootRoles, @Nullable Set<@NonNull String> toolchains, @Nullable Set<@NonNull String> compilers, @Nullable Set<@NonNull String> deviceCores) {
            SdkComponentDescriptor cur;
            if (id == null) {
                id = String.valueOf(name) + '/' + type + '/';
                if (devices != null) {
                    id = String.valueOf(id) + CollectionsUtils.formatList(devices, (String)"_", null);
                }
            }
            if ((cur = this.sdkComponentsMap.get(id)) == null || cur.getVersion().compareTo(version) < 0) {
                List<@NonNull String> depList = Arrays.asList(dependencyArr);
                assert (depList != null);
                if (depList.contains("")) {
                    depList = new ArrayList<String>(depList);
                    ListIterator<String> iter = depList.listIterator();
                    while (iter.hasNext()) {
                        String elem = iter.next();
                        if (!elem.isEmpty()) continue;
                        iter.remove();
                    }
                }
                cur = new SdkComponentDescriptor(id, name, fullName, brief, type, category, devices, sources, toolsSettings, version, new HashSet<String>(depList), defines, includePaths, reqCoreBootRoles, toolchains, compilers, deviceCores);
                this.sdkComponentsMap.put(id, cur);
            }
            return this;
        }

        public @NonNull SdkComponentsDescriptor build(@NonNull SdkDevicesDescriptor devicesDescr) {
            Collection<SdkComponentDescriptor> sdkComponents = this.sdkComponentsMap.values();
            assert (sdkComponents != null);
            sdkComponents.forEach(c -> c.setDevicesDescriptor(devicesDescr));
            SdkComponentsDescriptor sdkComponentsDescriptor = new SdkComponentsDescriptor(sdkComponents);
            return sdkComponentsDescriptor;
        }
    }
}

