/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.sdk.ISdkFileProvider;
import com.nxp.swtools.sdkmanifest.descriptors.CompilerDefineSymbol;
import com.nxp.swtools.sdkmanifest.descriptors.SdkBoardExample;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDevicesDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkManifestDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkMetaData;
import com.nxp.swtools.sdkmanifest.descriptors.SdkTagContentVersion;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoader;
import com.nxp.swtools.sdkmanifest.loader.ManifestLoaderUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkBoardsDescriptor {
    @NonNull
    private final Collection<SdkBoardDescriptor> boards;
    protected final int manifestMajorFormatVersion;
    protected final int manifestMinorFormatVersion;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SdkBoardsDescriptor.class);

    SdkBoardsDescriptor() {
        this.boards = new ArrayList<SdkBoardDescriptor>();
        this.manifestMajorFormatVersion = 0;
        this.manifestMinorFormatVersion = -1;
    }

    public SdkBoardsDescriptor(@NonNull Collection<SdkBoardDescriptor> boards, int manifestMajorFormatVersion, int manifestMinorFormatVersion) {
        this.boards = boards;
        this.manifestMajorFormatVersion = manifestMajorFormatVersion;
        this.manifestMinorFormatVersion = manifestMinorFormatVersion;
    }

    public @NonNull Collection<String> getSdkBoardDescriptorNames() {
        HashSet<String> names = new HashSet<String>();
        for (SdkBoardDescriptor descriptor : this.boards) {
            names.add(descriptor.getName());
        }
        return names;
    }

    public @NonNull Collection<SdkBoardDescriptor> getSdkBoardDescriptors() {
        return CollectionsUtils.unmodifiableCollection(this.boards);
    }

    public @Nullable SdkBoardDescriptor getSdkBoardDescriptor(@NonNull String name) {
        for (SdkBoardDescriptor descriptor : this.boards) {
            if (!descriptor.getName().equals(name)) continue;
            return descriptor;
        }
        return null;
    }

    public @Nullable SdkBoardDescriptor getSdkBoardDescriptorBySubDir(@NonNull String subDir) {
        for (SdkBoardDescriptor descriptor : this.boards) {
            if (!descriptor.getSubDir().equals(subDir)) continue;
            return descriptor;
        }
        return null;
    }

    void resolveBoardProcessors(@NonNull SdkDevicesDescriptor devices) {
        for (SdkBoardDescriptor board : this.boards) {
            board.setProcessor(devices.getSdkDeviceDescriptorByPackageName(board.getPartNumber()));
        }
    }

    public @Nullable SdkBoardDescriptor findBoardByName(@NonNull String boardName) {
        for (SdkBoardDescriptor board : this.getSdkBoardDescriptors()) {
            if (!board.getName().equals(boardName)) continue;
            return board;
        }
        return null;
    }

    public @Nullable SdkBoardDescriptor findBoardById(@NonNull String id) {
        for (SdkBoardDescriptor board : this.getSdkBoardDescriptors()) {
            if (!board.getId().equals(id)) continue;
            return board;
        }
        return null;
    }

    public static class Builder {
        @NonNull
        private HashMap<String, SdkBoardDescriptor> boards = new HashMap();
        private final int manifestMajorFormatVersion;
        private final int manifestMinorFormatVersion;

        public Builder(int manifestMajorFormatVersion, int manifestMinorFormatVersion) {
            this.manifestMajorFormatVersion = manifestMajorFormatVersion;
            this.manifestMinorFormatVersion = manifestMinorFormatVersion;
        }

        public @NonNull Builder addBoard(@NonNull SdkBoardDescriptor board) {
            String boardId = board.getId();
            SdkBoardDescriptor cur = this.boards.get(boardId);
            if (cur == null || cur.getVersion().compareTo(board.getVersion()) < 0) {
                this.boards.put(boardId, board);
            } else if (cur.getVersion().compareTo(board.getVersion()) == 0) {
                LOGGER.log(Level.SEVERE, "Board ID duplicated: " + boardId);
            }
            return this;
        }

        public @NonNull Builder addBoard(@NonNull SdkBoardDescriptor.BoardBuilder boardBuilder) {
            return this.addBoard(boardBuilder.build());
        }

        public @NonNull SdkBoardsDescriptor build() {
            Collection<SdkBoardDescriptor> values = this.boards.values();
            assert (values != null);
            return new SdkBoardsDescriptor(new ArrayList<SdkBoardDescriptor>(values), this.manifestMajorFormatVersion, this.manifestMinorFormatVersion);
        }
    }

    public static class SdkBoardDescriptor {
        @NonNull
        private final String id;
        @NonNull
        private final String name;
        @NonNull
        private final String subDir;
        @NonNull
        private final String partNumber;
        @Nullable
        private String userName;
        @Nullable
        private SdkDeviceDescriptor processor;
        @NonNull
        private final SdkTagContentVersion version;
        @Nullable
        private final Collection<@NonNull SdkBoardExample> examples;
        @NonNull
        private final ISdkFileProvider sdkFileProvider;
        @Nullable
        private Collection<@NonNull SdkBoardExample> examples4cloning;
        @NonNull
        private final @NonNull Collection<@NonNull CompilerDefineSymbol> defines;
        private final int manifestMajorFormatVersion;
        private final int manifestMinorFormatVersion;
        private final boolean isKit;
        @NonNull
        private final SdkMetaData metaData;

        public SdkBoardDescriptor(@NonNull String id, @NonNull String name, @NonNull String subDir, @NonNull String packageName, @NonNull SdkTagContentVersion version, @Nullable Collection<@NonNull SdkBoardExample> examples, @NonNull ISdkFileProvider sdkFileProvider, @NonNull Collection<@NonNull CompilerDefineSymbol> defines, int manifestMajorFormatVersion, int manifestMinorFormatVersion, boolean kit, @NonNull SdkMetaData metaData) {
            this.id = id;
            this.name = name;
            this.subDir = subDir;
            this.partNumber = packageName;
            this.version = version;
            this.examples = examples;
            if (examples != null) {
                for (SdkBoardExample example : examples) {
                    example.setParentBoard(this);
                }
            }
            this.defines = defines;
            this.sdkFileProvider = sdkFileProvider;
            this.manifestMajorFormatVersion = manifestMajorFormatVersion;
            this.manifestMinorFormatVersion = manifestMinorFormatVersion;
            this.isKit = kit;
            this.metaData = metaData;
        }

        public @NonNull String getId() {
            return this.id;
        }

        public @Nullable String getUserName() {
            return this.userName;
        }

        void setUserName(@Nullable String userName) {
            this.userName = userName;
        }

        public @Nullable SdkDeviceDescriptor getProcessor() {
            return this.processor;
        }

        void setProcessor(@Nullable SdkDeviceDescriptor processor) {
            this.processor = processor;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull String getUserNameOrName() {
            String un = this.getUserName();
            return un != null ? un : this.getName();
        }

        public @NonNull String getSubDir() {
            return this.subDir;
        }

        public boolean isKit() {
            return this.isKit;
        }

        public @NonNull String getPartNumber() {
            return this.partNumber;
        }

        public @Nullable Collection<SdkBoardExample> getBoardExamples() {
            return this.examples;
        }

        public @NonNull SdkMetaData getMetaData() {
            return this.metaData;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private @Nullable SdkBoardExample loadBoardExampleFile(@NonNull SdkBoardExample example) {
            int minorFormatVersion;
            String relPath = example.getMcuXpressoExamplePrjRelPath();
            if (relPath == null) {
                return null;
            }
            Document doc = null;
            try {
                Throwable throwable = null;
                Object var5_6 = null;
                try {
                    InputStream iStrm = this.sdkFileProvider.openSdkFile(relPath);
                    try {
                        if (iStrm == null) {
                            LOGGER.log(Level.SEVERE, "File referenced from MANIFEST not found: " + relPath);
                            return null;
                        }
                        doc = ManifestLoaderUtils.loadManifestDocument(iStrm);
                    }
                    finally {
                        if (iStrm == null) return null;
                        iStrm.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException iOException) {}
            if (doc == null) {
                LOGGER.log(Level.SEVERE, "File referenced from MANIFEST not valid XML format: " + relPath);
                return null;
            }
            Element root = doc.getDocumentElement();
            assert (root != null);
            Element exampleElem = ManifestLoaderUtils.getChildElementByName(root, "example");
            if (exampleElem == null) {
                LOGGER.log(Level.SEVERE, "'example' not found in " + relPath);
                return null;
            }
            String versionAttr = root.getAttribute("format_version");
            int majorFormatVersion = ManifestLoader.decodeManifestMajorFormatVersion(versionAttr);
            if (majorFormatVersion == 0) {
                majorFormatVersion = this.manifestMajorFormatVersion;
            }
            if ((minorFormatVersion = ManifestLoader.decodeManifestMinorFormatVersion(versionAttr)) != -1) return SdkManifestDescriptor.loadExample(exampleElem, this.getSubDir(), example, majorFormatVersion, minorFormatVersion);
            minorFormatVersion = this.manifestMinorFormatVersion;
            return SdkManifestDescriptor.loadExample(exampleElem, this.getSubDir(), example, majorFormatVersion, minorFormatVersion);
        }

        /*
         * Issues handling annotations - annotations may be inaccurate
         */
        public @NonNull Collection<@NonNull SdkBoardExample> getBoardExamples4Cloning() {
            @NonNull Collection result = this.examples4cloning;
            if (result != null) {
                return result;
            }
            Collection<@NonNull SdkBoardExample> curExamples = this.examples;
            ArrayList<@NonNull E> examplesForCloning = new ArrayList();
            if (curExamples != null) {
                HashSet<@NonNull E> slaveSdkExamples = new HashSet();
                curExamples.forEach(e -> {
                    String prjIds = e.getLinkedSlaveProjectId();
                    if (prjIds != null) {
                        SdkBoardExample slaveSdkExample = this.findBoardExampleById(prjIds);
                        if (slaveSdkExample == null) {
                            LOGGER.log(Level.SEVERE, "The following linked project not found: " + prjIds);
                        } else {
                            slaveSdkExamples.add(slaveSdkExample);
                            e.setLinkedSlaveProject(slaveSdkExample);
                        }
                    }
                });
                curExamples.stream().filter(e -> !slaveSdkExamples.contains(e)).forEach(example -> {
                    if (example.getMcuXpressoExamplePrjRelPath() != null) {
                        SdkBoardExample loadedExample = this.loadBoardExampleFile((SdkBoardExample)example);
                        if (loadedExample != null) {
                            SdkBoardExample linkedSlave = example.getLinkedSlaveProject();
                            if (linkedSlave != null) {
                                linkedSlave = this.loadBoardExampleFile(linkedSlave);
                                assert (linkedSlave != null);
                                loadedExample.setLinkedSlaveProject(linkedSlave);
                                linkedSlave.setParentBoard(this);
                                examplesForCloning.add(linkedSlave);
                            }
                            loadedExample.setParentBoard(this);
                            examplesForCloning.add(loadedExample);
                        } else {
                            LOGGER.log(Level.SEVERE, "The following example cannot be loaded: " + String.valueOf(example) + " from `" + UtilsText.safeString((String)(String.valueOf(example.getMcuXpressoExamplePrjRelPath()) + '`')));
                        }
                    } else {
                        LOGGER.log(Level.WARNING, "The following example not supported for MCUxpresso tools: " + String.valueOf(example));
                    }
                });
            }
            this.examples4cloning = result = CollectionsUtils.unmodifiableCollection(examplesForCloning);
            return result;
        }

        public @Nullable SdkBoardExample findBoardExampleByFullName(@NonNull String fullName, boolean forCloning) {
            Collection<SdkBoardExample> listExamples;
            Collection<SdkBoardExample> collection = listExamples = forCloning ? this.getBoardExamples4Cloning() : this.examples;
            if (listExamples != null) {
                for (SdkBoardExample example : listExamples) {
                    if (!example.getFullName().equals(fullName)) continue;
                    return example;
                }
            }
            return null;
        }

        public @Nullable SdkBoardExample findBoardExampleByPath(@NonNull String path, boolean forCloning) {
            Collection<SdkBoardExample> listExamples;
            path = UtilsFile.convertToOSPathFormat((String)path);
            Collection<SdkBoardExample> collection = listExamples = forCloning ? this.getBoardExamples4Cloning() : this.examples;
            if (listExamples != null) {
                for (SdkBoardExample example : listExamples) {
                    if (!example.getSdkRelPath().equals(path)) continue;
                    return example;
                }
            }
            return null;
        }

        public @Nullable SdkBoardExample findBoardExampleByFullName4UI(@NonNull String fullName4UI) {
            for (SdkBoardExample example : this.getBoardExamples4Cloning()) {
                if (!example.getFullName4UI().equals(fullName4UI)) continue;
                return example;
            }
            return null;
        }

        public @Nullable SdkBoardExample findBoardExampleById(@NonNull String prjId) {
            Collection<SdkBoardExample> listExamples = this.examples;
            if (listExamples != null) {
                for (SdkBoardExample example : listExamples) {
                    if (!example.getId().equals(prjId)) continue;
                    return example;
                }
            }
            return null;
        }

        public @NonNull SdkTagContentVersion getVersion() {
            return this.version;
        }

        public @NonNull Collection<@NonNull CompilerDefineSymbol> getDefines() {
            return this.defines;
        }

        public @NonNull String toString() {
            return String.valueOf(this.name) + '/' + this.id;
        }

        public static class BoardBuilder {
            @NonNull
            private final String id;
            @NonNull
            private final String name;
            @NonNull
            private final String subDir;
            @NonNull
            private final String packageName;
            @Nullable
            private String userName;
            @Nullable
            private SdkDeviceDescriptor processor;
            @NonNull
            private final SdkTagContentVersion version;
            @Nullable
            private final Collection<@NonNull SdkBoardExample> examples;
            @NonNull
            private final ISdkFileProvider sdkFileProvider;
            @NonNull
            private final @NonNull Collection<@NonNull CompilerDefineSymbol> defines;
            private final int majorManifestFormatVersion;
            private final int minorManifestFormatVersion;
            private final boolean isKit;
            @NonNull
            private final SdkMetaData metaData;

            public BoardBuilder(@NonNull String id, @NonNull String name, @NonNull String subDir, @NonNull String packageName, @NonNull SdkTagContentVersion version, @Nullable Collection<@NonNull SdkBoardExample> examples, @NonNull ISdkFileProvider sdkFileProvider, @NonNull Collection<@NonNull CompilerDefineSymbol> defines, int majorManifestFormatVersion, int minorManifestFormatVersion, boolean kit, @NonNull SdkMetaData metaData) {
                this.id = id;
                this.name = name;
                this.subDir = subDir;
                this.packageName = packageName;
                this.version = version;
                this.examples = examples == null ? null : CollectionsUtils.unmodifiableCollection(examples);
                this.defines = defines;
                this.sdkFileProvider = sdkFileProvider;
                this.majorManifestFormatVersion = majorManifestFormatVersion;
                this.minorManifestFormatVersion = minorManifestFormatVersion;
                this.isKit = kit;
                this.metaData = metaData;
            }

            public @NonNull BoardBuilder setUserName(@Nullable String userName) {
                this.userName = userName;
                return this;
            }

            public @NonNull SdkBoardDescriptor build() {
                SdkBoardDescriptor board = new SdkBoardDescriptor(this.id, this.name, this.subDir, this.packageName, this.version, this.examples, this.sdkFileProvider, this.defines, this.majorManifestFormatVersion, this.minorManifestFormatVersion, this.isKit, this.metaData);
                board.setUserName(this.userName);
                board.setProcessor(this.processor);
                return board;
            }
        }
    }
}

