/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.sdkmanifest.descriptors;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsFile;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.sdkmanifest.descriptors.SdkBoardsDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceCore;
import com.nxp.swtools.sdkmanifest.descriptors.SdkDeviceDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkIncludePath;
import com.nxp.swtools.sdkmanifest.descriptors.SdkManifestDescriptor;
import com.nxp.swtools.sdkmanifest.descriptors.SdkSourceFile;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class SdkBoardExample {
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(SdkBoardExample.class);
    @NonNull
    private final String id;
    @NonNull
    private final String name;
    @NonNull
    private final String category;
    @NonNull
    private final String path;
    @Nullable
    private final String description;
    @NonNull
    private final @NonNull List<@NonNull SdkSourceFile> srcFiles;
    @Nullable
    private final List<SdkIncludePath> includePaths;
    @NonNull
    private final @NonNull Collection<@NonNull String> dependencies;
    @Nullable
    private SdkBoardsDescriptor.SdkBoardDescriptor parentBoard;
    @Nullable
    private final Collection<String> devices;
    @Nullable
    private Collection<@NonNull String> toolchains;
    @Nullable
    private final String mcuXpressoExmplPrjRelPath;
    @Nullable
    private final String deviceCoreId;
    @Nullable
    private final String linkedSlaveProjectId;
    @Nullable
    private SdkBoardExample linkedSlaveProject = null;
    @Nullable
    private SdkBoardExample linkedMasterProject = null;

    public SdkBoardExample(@NonNull String id, @NonNull String name, @NonNull String category, @NonNull String path, @Nullable String description, @NonNull List<@NonNull SdkSourceFile> srcFiles, @Nullable List<SdkIncludePath> includePaths, @NonNull Collection<@NonNull String> dependencies, @Nullable Collection<String> devices, @Nullable Collection<@NonNull String> toolchains, @Nullable String mcuXpressoExmplPrjRelPath, @Nullable String deviceCoreId, @Nullable String linkedProject) {
        this.id = id;
        this.name = name;
        this.category = category;
        this.path = UtilsFile.convertToOSPathFormat((String)path);
        this.description = description;
        this.srcFiles = CollectionsUtils.unmodifiableList(srcFiles);
        this.includePaths = includePaths == null ? null : CollectionsUtils.unmodifiableList(includePaths);
        this.dependencies = CollectionsUtils.unmodifiableCollection(dependencies);
        this.devices = devices != null ? CollectionsUtils.unmodifiableCollection(devices) : null;
        this.toolchains = toolchains;
        this.mcuXpressoExmplPrjRelPath = mcuXpressoExmplPrjRelPath;
        this.deviceCoreId = deviceCoreId;
        this.linkedSlaveProjectId = linkedProject;
    }

    public @NonNull String getId() {
        return this.id;
    }

    public @NonNull String getName() {
        return this.name;
    }

    public @NonNull String getCategory() {
        return this.category;
    }

    public @NonNull String getSdkRelPath() {
        return this.path;
    }

    public List<SdkIncludePath> getIncludePaths() {
        return this.includePaths;
    }

    public @Nullable String getMcuXpressoExamplePrjRelPath() {
        return this.mcuXpressoExmplPrjRelPath;
    }

    public @Nullable String getDeviceCoreId() {
        return this.deviceCoreId;
    }

    public @Nullable String getDeviceCoreName() {
        String exampleCoreId = this.getDeviceCoreId();
        SdkBoardsDescriptor.SdkBoardDescriptor board = this.getParentBoard();
        SdkDeviceDescriptor device = null;
        if (exampleCoreId == null || board == null || (device = board.getProcessor()) == null) {
            return null;
        }
        SdkDeviceCore core = (SdkDeviceCore)CollectionsUtils.findAny(device.getCores(), devCore -> devCore.getCoreId().equals(exampleCoreId));
        return core != null ? core.getCoreName() : null;
    }

    public @Nullable String getDescription() {
        return this.description;
    }

    protected @NonNull List<@NonNull SdkSourceFile> getSourceFiles() {
        return this.srcFiles;
    }

    public @NonNull Stream<@NonNull SdkSourceFile> getSourceFiles(@NonNull SdkManifestDescriptor.ManifestHelper variableResolver) {
        Stream<@NonNull SdkSourceFile> result = this.getSourceFiles().stream().map(src -> new SdkSourceFile((SdkSourceFile)src, variableResolver));
        assert (result != null);
        return result;
    }

    public @NonNull Collection<@NonNull String> getDependencies() {
        return this.dependencies;
    }

    public @Nullable Collection<String> getDevices() {
        return this.devices;
    }

    public @Nullable Collection<@NonNull String> getToolchains() {
        return this.toolchains;
    }

    public void setToolchains(@NonNull Collection<@NonNull String> t) {
        this.toolchains = t;
    }

    public boolean isToolchainSupported(@NonNull String toolchainId) {
        return this.toolchains != null ? this.toolchains.contains(toolchainId) : true;
    }

    public void setParentBoard( @NonNull SdkBoardsDescriptor.SdkBoardDescriptor board) {
        this.parentBoard = board;
    }

    public  @Nullable SdkBoardsDescriptor.SdkBoardDescriptor getParentBoard() {
        return this.parentBoard;
    }

    public @NonNull String getFullName() {
        return String.valueOf(this.category) + '/' + this.name;
    }

    public @NonNull String getFullName4UI() {
        return UtilsText.isEmpty((String)this.getLinkedSlaveProjectId()) ? String.valueOf(this.category) + '/' + this.name : this.category;
    }

    public @NonNull String getFullName4CmdLineTest() {
        int pp;
        String brdId;
        String result = this.id;
        SdkBoardsDescriptor.SdkBoardDescriptor brd = this.getParentBoard();
        String string = brdId = brd != null ? brd.getId() : "#_unknwon_board_@";
        if (result.startsWith(brdId)) {
            result = result.substring(brdId.length() + 1);
        }
        if (result.endsWith("_example")) {
            result = result.substring(0, result.length() - 8);
        }
        if ((pp = result.indexOf("_examples_")) > 0 && (result = String.valueOf(result.substring(0, pp)) + result.substring(pp + 9)).substring(pp + 1, 2 * pp + 2).equals(result.substring(0, pp + 1))) {
            result = result.substring(pp + 1);
        }
        return result;
    }

    public @Nullable String getLinkedSlaveProjectId() {
        return this.linkedSlaveProjectId;
    }

    public void setLinkedSlaveProject(@NonNull SdkBoardExample slaveExamplePrj) {
        this.linkedSlaveProject = slaveExamplePrj;
        slaveExamplePrj.setLinkedMasterProject(this);
        if (!this.category.equals(slaveExamplePrj.category)) {
            LOGGER.log(Level.SEVERE, "slave and master project path are in different categories");
            assert (false);
        }
    }

    public SdkBoardExample getLinkedSlaveProject() {
        SdkBoardExample result = this.linkedSlaveProject;
        if (this.linkedSlaveProjectId != null ? !$assertionsDisabled && result == null : !$assertionsDisabled && result != null) {
            throw new AssertionError();
        }
        return result;
    }

    public void setLinkedMasterProject(@NonNull SdkBoardExample masterExamplePrj) {
        this.linkedMasterProject = masterExamplePrj;
        assert (this.getLinkedSlaveProject() == null);
    }

    public SdkBoardExample getLinkedMasterProject() {
        return this.linkedMasterProject;
    }

    public String toString() {
        return this.getFullName();
    }
}

