/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.vpt.kernel.ui.dialogs;

import com.nxp.s32ds.cle.runtime.component.registry.BlockArchetypeDescriptor;
import com.nxp.s32ds.cle.runtime.component.registry.core.ComponentRegistryCore;
import com.nxp.s32ds.ext.emf.ecore.external.ExternalUriProtocol;
import com.nxp.s32ds.gte.apukernel.ApuKernelInfo;
import com.nxp.s32ds.mdt.vpt.apex2.kernel.registry.Apex2KernelBlockUtil;
import com.nxp.s32ds.vgt.vpt.internal.kernel.ui.KernelUiActivator;
import com.nxp.s32ds.vgt.vpt.internal.kernel.ui.Messages;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;

public class KernelListFilteredSelectionDialog
extends FilteredItemsSelectionDialog {
    private List<ApuKernelInfo> kernels;
    private static final String DOT_ADD_KERNEL_UI_CONTEXT_ID = ".AddKernelUiContextId";
    private static final String DIALOG_SETTINGS = "KernelListFilteredSelectionDialogSettings";
    private final Map<ApuKernelInfo, String> kernel2archetype = new HashMap<ApuKernelInfo, String>();
    private static final LabelProvider LABEL_PROVIDER = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof ApuKernelInfo) {
                ApuKernelInfo kernelInfo = (ApuKernelInfo)element;
                return NLS.bind((String)Messages.KernelSelectionLabelProvider_kernel_label, (Object)kernelInfo.getName(), (Object)kernelInfo.getSource().getCategory());
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
        }
    };
    private static final LabelProvider LOW_LABEL_PROVIDER = new LabelProvider(){

        public String getText(Object element) {
            if (element instanceof ApuKernelInfo) {
                ApuKernelInfo kernelInfo = (ApuKernelInfo)element;
                URI uri = ExternalUriProtocol.resolve((URI)kernelInfo.eResource().getURI());
                if (uri.isFile()) {
                    Path path = Paths.get(uri.toFileString(), new String[0]);
                    try {
                        return path.toFile().getCanonicalPath();
                    }
                    catch (IOException iOException) {}
                }
                return uri.toString();
            }
            return super.getText(element);
        }

        public Image getImage(Object element) {
            return null;
        }
    };
    private boolean showArchetypeVSDK = true;
    private boolean showArchetypeWorkspace = true;
    private boolean showArchetypeExternal = true;
    private final Map<String, Boolean> archetype2filter = new HashMap<String, Boolean>();
    private Action showVsdkArchetypeKernelsAction = new ShowVsdkArchetypeKernelsAction();
    private Action showWorkspaceArchetypeKernelsAction = new ShowWorkspaceArchetypeKernelsAction();
    private Action showExternalArchetypeKernelsAction = new ShowExternalArchetypeKernelsAction();

    public KernelListFilteredSelectionDialog(Shell shell, List<ApuKernelInfo> kernels, boolean multi) {
        super(shell, multi);
        this.kernels = kernels;
        this.fillKernel2archetypeMap();
        this.fillArchetype2filterMap();
        this.setTitle(Messages.KernelListFilteredSelectionDialog_add_kernels_title);
        this.setSelectionHistory(new KernelSelectionHistory());
        this.setListLabelProvider((ILabelProvider)LABEL_PROVIDER);
        this.setDetailsLabelProvider((ILabelProvider)LOW_LABEL_PROVIDER);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "com.nxp.s32ds.vgt.vpt.kernel.ui.AddKernelUiContextId");
    }

    protected Control createExtendedContentArea(Composite parent) {
        return null;
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = KernelUiActivator.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS);
        if (settings == null) {
            settings = KernelUiActivator.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS);
        }
        return settings;
    }

    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new KernelArchetypeFilter();
    }

    protected Comparator<ApuKernelInfo> getItemsComparator() {
        return (kernel1, kernel2) -> {
            String kernelNameCategory1 = NLS.bind((String)Messages.KernelSelectionLabelProvider_kernel_label, (Object)kernel1.getName(), (Object)kernel1.getSource().getCategory());
            String kernelNameCategory2 = NLS.bind((String)Messages.KernelSelectionLabelProvider_kernel_label, (Object)kernel2.getName(), (Object)kernel2.getSource().getCategory());
            return kernelNameCategory1.compareTo(kernelNameCategory2);
        };
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask(Messages.KernelListFilteredSelectionDialog_filling_list, this.kernels.size());
        this.kernels.forEach(k -> {
            contentProvider.add(k, itemsFilter);
            progressMonitor.worked(1);
        });
        progressMonitor.done();
    }

    public String getElementName(Object element) {
        if (element instanceof ApuKernelInfo) {
            ApuKernelInfo kernelInfo = (ApuKernelInfo)element;
            return NLS.bind((String)Messages.KernelSelectionLabelProvider_kernel_label, (Object)kernelInfo.getName(), (Object)kernelInfo.getSource().getCategory());
        }
        return element.toString();
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        menuManager.add((IAction)this.showVsdkArchetypeKernelsAction);
        menuManager.add((IAction)this.showWorkspaceArchetypeKernelsAction);
        menuManager.add((IAction)this.showExternalArchetypeKernelsAction);
    }

    protected void applyFilter() {
        super.applyFilter();
        this.showVsdkArchetypeKernelsAction.setChecked(this.showArchetypeVSDK);
        this.showWorkspaceArchetypeKernelsAction.setChecked(this.showArchetypeWorkspace);
        this.showExternalArchetypeKernelsAction.setChecked(this.showArchetypeExternal);
    }

    private void fillKernel2archetypeMap() {
        this.kernels.forEach(k -> {
            String string = this.kernel2archetype.put((ApuKernelInfo)k, KernelListFilteredSelectionDialog.getKernelArchetype(k));
        });
    }

    private static String getKernelArchetype(ApuKernelInfo kernelInfo) {
        String blockId = Apex2KernelBlockUtil.getBlockId((ApuKernelInfo)kernelInfo);
        List descriptors = ComponentRegistryCore.getBlockRegistry().getBlockArchetypeDescriptorsByBlockId(blockId);
        if (!descriptors.isEmpty()) {
            return ((BlockArchetypeDescriptor)descriptors.get(0)).getArchetypeId();
        }
        return null;
    }

    private void fillArchetype2filterMap() {
        this.archetype2filter.put("apex_kernel_vsdk_root", this.showArchetypeVSDK);
        this.archetype2filter.put("apex_kernel_workspace_root", this.showArchetypeWorkspace);
        this.archetype2filter.put("apex_kernel_external_root", this.showArchetypeExternal);
    }

    private Text getPatternText() {
        return (Text)this.getPatternControl();
    }

    private class KernelArchetypeFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        public final boolean showArchetypeVSDK;
        public final boolean showArchetypeWorkspace;
        public final boolean showArchetypeExternal;

        public KernelArchetypeFilter() {
            super((FilteredItemsSelectionDialog)KernelListFilteredSelectionDialog.this);
            this.showArchetypeVSDK = KernelListFilteredSelectionDialog.this.showArchetypeVSDK;
            this.showArchetypeWorkspace = KernelListFilteredSelectionDialog.this.showArchetypeWorkspace;
            this.showArchetypeExternal = KernelListFilteredSelectionDialog.this.showArchetypeExternal;
            this.patternMatcher = new SearchPattern();
            String stringPattern = "";
            if (KernelListFilteredSelectionDialog.this.getPatternControl() != null) {
                stringPattern = stringPattern.equals(KernelListFilteredSelectionDialog.this.getPatternText().getText().trim()) ? "*" : KernelListFilteredSelectionDialog.this.getPatternText().getText();
            }
            this.patternMatcher.setPattern(stringPattern);
        }

        public boolean matchItem(Object item) {
            if (item instanceof ApuKernelInfo) {
                boolean needsFiltation;
                String archetype = (String)KernelListFilteredSelectionDialog.this.kernel2archetype.get(item);
                Boolean showItem = (Boolean)KernelListFilteredSelectionDialog.this.archetype2filter.get(archetype);
                if (showItem == null) {
                    return false;
                }
                boolean bl = needsFiltation = showItem == false;
                if (needsFiltation) {
                    return false;
                }
                ApuKernelInfo kernel = (ApuKernelInfo)item;
                String kernelNameCategory = NLS.bind((String)Messages.KernelSelectionLabelProvider_kernel_label, (Object)kernel.getName(), (Object)kernel.getSource().getCategory());
                return this.matches(kernelNameCategory);
            }
            return this.matches(item.toString());
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof ApuKernelInfo;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            KernelArchetypeFilter kernelArchetypeFilter = (KernelArchetypeFilter)filter;
            if (kernelArchetypeFilter.showArchetypeVSDK != this.showArchetypeVSDK || kernelArchetypeFilter.showArchetypeWorkspace != this.showArchetypeWorkspace || kernelArchetypeFilter.showArchetypeExternal != this.showArchetypeExternal) {
                return false;
            }
            return super.equalsFilter(filter);
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            KernelArchetypeFilter kernelArchetypeFilter = (KernelArchetypeFilter)filter;
            if (kernelArchetypeFilter.showArchetypeVSDK != this.showArchetypeVSDK || kernelArchetypeFilter.showArchetypeWorkspace != this.showArchetypeWorkspace || kernelArchetypeFilter.showArchetypeExternal != this.showArchetypeExternal) {
                return false;
            }
            return super.isSubFilter(filter);
        }
    }

    private class KernelSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private KernelSelectionHistory() {
        }

        protected Object restoreItemFromMemento(IMemento element) {
            String elementName = element.getTextData();
            return KernelListFilteredSelectionDialog.this.kernels.stream().filter(k -> k.getName().equals(elementName)).findFirst().orElse(null);
        }

        protected void storeItemToMemento(Object item, IMemento element) {
            if (item instanceof ApuKernelInfo) {
                element.putTextData(((ApuKernelInfo)item).getName());
            }
        }
    }

    private class ShowExternalArchetypeKernelsAction
    extends Action {
        public ShowExternalArchetypeKernelsAction() {
            super("Show External Kernels", 2);
        }

        public void run() {
            if (KernelListFilteredSelectionDialog.this.showArchetypeExternal != this.isChecked()) {
                KernelListFilteredSelectionDialog.this.showArchetypeExternal = this.isChecked();
                KernelListFilteredSelectionDialog.this.archetype2filter.put("apex_kernel_external_root", KernelListFilteredSelectionDialog.this.showArchetypeExternal);
                KernelListFilteredSelectionDialog.this.applyFilter();
            }
        }
    }

    private class ShowVsdkArchetypeKernelsAction
    extends Action {
        public ShowVsdkArchetypeKernelsAction() {
            super("Show VSDK Kernels", 2);
        }

        public void run() {
            if (KernelListFilteredSelectionDialog.this.showArchetypeVSDK != this.isChecked()) {
                KernelListFilteredSelectionDialog.this.showArchetypeVSDK = this.isChecked();
                KernelListFilteredSelectionDialog.this.archetype2filter.put("apex_kernel_vsdk_root", KernelListFilteredSelectionDialog.this.showArchetypeVSDK);
                KernelListFilteredSelectionDialog.this.applyFilter();
            }
        }
    }

    private class ShowWorkspaceArchetypeKernelsAction
    extends Action {
        public ShowWorkspaceArchetypeKernelsAction() {
            super("Show Workspace Kernels", 2);
        }

        public void run() {
            if (KernelListFilteredSelectionDialog.this.showArchetypeWorkspace != this.isChecked()) {
                KernelListFilteredSelectionDialog.this.showArchetypeWorkspace = this.isChecked();
                KernelListFilteredSelectionDialog.this.archetype2filter.put("apex_kernel_workspace_root", KernelListFilteredSelectionDialog.this.showArchetypeWorkspace);
                KernelListFilteredSelectionDialog.this.applyFilter();
            }
        }
    }
}

