/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.vgt.ide.core;

import java.util.function.Supplier;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;

public class VgtValidationDesignService {
    private static String PATTERN_TO_BE_REMOVED = "constraint is violated on";
    private static final Diagnostician DIAGNOSTICIAN = new Diagnostician(){

        public String getObjectLabel(EObject eObject) {
            return "";
        }
    };
    private static final Supplier<String> EMPTY_STRING_SUPPLIER = new Supplier<String>(){

        @Override
        public String get() {
            return "";
        }
    };

    public static boolean hasNoErrors(EObject object) {
        Diagnostic diagnostic = VgtValidationDesignService.validate(object);
        return diagnostic.getSeverity() != 4;
    }

    public static boolean hasNoWarnings(EObject object) {
        Diagnostic diagnostic = VgtValidationDesignService.validate(object);
        return diagnostic.getSeverity() != 2;
    }

    public static String getErrorMessage(EObject object) {
        Diagnostic diagnostic = VgtValidationDesignService.validate(object);
        return VgtValidationDesignService.getMessage(diagnostic, 4);
    }

    public static String getWarningMessage(EObject object) {
        Diagnostic diagnostic = VgtValidationDesignService.validate(object);
        return VgtValidationDesignService.getMessage(diagnostic, 2);
    }

    private static Diagnostic validate(EObject object) {
        EObject eContainer = object;
        while (eContainer != null && eContainer.eContainer() != null) {
            eContainer = eContainer.eContainer();
        }
        Diagnostic diagnostic = DIAGNOSTICIAN.validate(eContainer);
        if (diagnostic.getSeverity() == 0) {
            return diagnostic;
        }
        BasicDiagnostic result = new BasicDiagnostic();
        diagnostic.getChildren().stream().filter(d -> d.getData().contains(object)).forEach(d -> result.add(d));
        return result;
    }

    private static String getMessage(Diagnostic diagnostic, int severity) {
        String message = diagnostic.getChildren().stream().filter(d -> d.getSeverity() == severity).map(d -> d.getMessage().trim()).findFirst().orElseGet(EMPTY_STRING_SUPPLIER);
        return VgtValidationDesignService.postFormat(message);
    }

    private static String postFormat(String message) {
        int idx = message.lastIndexOf(PATTERN_TO_BE_REMOVED);
        if (idx > 0) {
            message = message.substring(0, idx);
        }
        return message;
    }
}

