/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.vision.apex;

import com.nxp.s32ds.ext.cdt.makefilegenerator.MakefileGenerator;
import com.nxp.s32ds.ext.rcp.runtime.Log;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import org.eclipse.cdt.managedbuilder.core.BuildException;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineGenerator;
import org.eclipse.cdt.managedbuilder.core.IManagedCommandLineInfo;
import org.eclipse.cdt.managedbuilder.core.ITool;
import org.eclipse.cdt.managedbuilder.internal.core.ManagedMakeMessages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;

public class ApexMakefileGenerator
extends MakefileGenerator {
    protected StringBuffer addTargetsRules(ITool targetTool, List<String> outputVarsAdditionsList, Vector<String> managedProjectOutputs, boolean postbuildStep) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# " + ManagedMakeMessages.getResourceString((String)"MakefileGenerator.comment.build.toprules") + NEWLINE);
        buffer.append("# " + ManagedMakeMessages.getResourceString((String)"MakefileGenerator.comment.build.toptargets") + NEWLINE);
        super.addCleanTargetRule(targetTool, buffer);
        return buffer;
    }

    private StringBuffer addReadElfVariables() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("# Graphs sources folder name variable" + NEWLINE);
        buffer.append("GRAPHS_SRC_DIR := APU_gen/src" + NEWLINE + NEWLINE);
        buffer.append("# Read elf script variables" + NEWLINE);
        buffer.append("READ_ELF := tclsh  ../Project_Settings/Scripts/read_elf.tcl" + NEWLINE);
        buffer.append("READ_ELF_OPTS := -pPMh=32 -mDMb=8 -mVMb=1024" + NEWLINE);
        buffer.append("READ_ELF_OUTPUT_DIR := ../A53_gen/inc" + NEWLINE);
        buffer.append("TCL_SCRIPT := ../Project_Settings/Scripts/gen_apu_load.tcl" + NEWLINE + NEWLINE);
        return buffer;
    }

    private StringBuffer addGraphRules() {
        String[] flags;
        StringBuffer buffer = new StringBuffer();
        ITool targetTool = this.getConfig().calculateTargetTool();
        if (targetTool == null) {
            return buffer;
        }
        try {
            flags = targetTool.getToolCommandFlags(null, null);
        }
        catch (BuildException ex) {
            Log.log((String)"com.nxp.s32ds.cle.apex", (String)ex.getMessage(), (Throwable)ex);
            flags = EMPTY_STRING_ARRAY;
        }
        String command = targetTool.getToolCommand();
        String outflag = targetTool.getOutputFlag();
        String outputPrefix = targetTool.getOutputPrefix();
        command = this.resolveValueToMakefileFormat(command);
        if (flags.length > 0) {
            flags = this.argumentFileBuilder.convertFlags("", null, targetTool, null, false, flags, null, this.getTopBuildDir());
        }
        IManagedCommandLineGenerator commandLineGenerator = targetTool.getCommandLineGenerator();
        IManagedCommandLineInfo cmdLInfo = commandLineGenerator.generateCommandLineInfo(targetTool, command, flags, outflag, outputPrefix, "$(1).elf", null, targetTool.getCommandLinePattern());
        String buildCmd = null;
        if (cmdLInfo == null) {
            String toolFlags;
            try {
                toolFlags = targetTool.getToolCommandFlagsString(null, null);
            }
            catch (BuildException ex) {
                Log.log((String)"com.nxp.s32ds.cle.apex", (String)ex.getMessage(), (Throwable)ex);
                toolFlags = "";
            }
            buildCmd = String.valueOf(command) + " " + toolFlags + " " + outflag + " " + outputPrefix + "$<" + " " + "$<";
        } else {
            buildCmd = cmdLInfo.getCommandLine();
        }
        buildCmd = this.argumentFileBuilder.convertBuildCmd(targetTool, null, buildCmd, this.getConfig(), this.getBuildTargetExt(), (MakefileGenerator)this);
        String linkerFile = "";
        String[] stringArray = flags;
        int n = flags.length;
        int n2 = 0;
        while (n2 < n) {
            String flag = stringArray[n2];
            if (flag.startsWith("-T")) {
                linkerFile = flag.replace("-T", "").replace("\"", "");
            }
            ++n2;
        }
        buffer.append("# Rules for graphs" + NEWLINE + NEWLINE);
        buffer.append("GRAPHS := $(patsubst %_nativekernel.hpp,%, $(notdir $(wildcard ../$(GRAPHS_SRC_DIR)/*_nativekernel.hpp)))" + NEWLINE);
        buffer.append("GRAPHS_OBJS := $(foreach graph,$(GRAPHS), $(addprefix ./$(GRAPHS_SRC_DIR)/,$(graph).o))" + NEWLINE);
        buffer.append("GRAPHS_OBJS += $(foreach graph,$(GRAPHS), $(addprefix ./$(GRAPHS_SRC_DIR)/,$(graph)__MKDBstub.o))" + NEWLINE);
        buffer.append("NON_GRAPHS_OBJS := $(filter-out $(GRAPHS_OBJS),$(OBJS))" + NEWLINE);
        buffer.append("TARGETS := $(foreach graph,$(GRAPHS),$(graph).elf)" + NEWLINE);
        buffer.append("LOADHS := $(foreach graph,$(GRAPHS),$(READ_ELF_OUTPUT_DIR)/$(graph)_APU_LOAD.h)" + NEWLINE);
        buffer.append("TARGETS += $(LOADHS)" + NEWLINE + NEWLINE);
        buffer.append("create-gen-dir:" + NEWLINE);
        buffer.append("\t@mkdir -p $(READ_ELF_OUTPUT_DIR)" + NEWLINE + NEWLINE);
        buffer.append("define apu_rules" + NEWLINE);
        buffer.append("$(1).elf: ./$(GRAPHS_SRC_DIR)/$(1).o ./$(GRAPHS_SRC_DIR)/$(1)__MKDBstub.o $(NON_GRAPHS_OBJS) " + linkerFile + " " + "|" + " " + "create-gen-dir" + NEWLINE);
        buffer.append("\t@" + ApexMakefileGenerator.escapedEcho((String)(String.valueOf(MESSAGE_START_BUILD) + " " + "$(1).elf")));
        buffer.append("\t@" + ApexMakefileGenerator.escapedEcho((String)targetTool.getAnnouncement()));
        buffer.append("\t" + buildCmd + " " + "./$(GRAPHS_SRC_DIR)/$(1).o ./$(GRAPHS_SRC_DIR)/$(1)__MKDBstub.o" + " " + "$(NON_GRAPHS_OBJS)" + " " + "--start-group $(LIBS) --end-group" + " " + "-Map=$(1).map" + NEWLINE);
        buffer.append("\t@" + ApexMakefileGenerator.escapedEcho((String)(String.valueOf(MESSAGE_FINISH_BUILD) + " " + "$(1).elf")) + NEWLINE);
        buffer.append("$(READ_ELF_OUTPUT_DIR)/$(graph)_APU_LOAD.h: $(1).elf" + NEWLINE);
        buffer.append("\t@" + ApexMakefileGenerator.escapedEcho((String)"Generating: $(1)_APU_LOAD.h"));
        buffer.append("\t@echo ' '" + NEWLINE);
        buffer.append("\t$(READ_ELF) $(READ_ELF_OPTS) $(1).elf -eGb -t $(TCL_SCRIPT) -Tload_name=$(1) > $(READ_ELF_OUTPUT_DIR)/$(1)_APU_LOAD.h " + NEWLINE);
        buffer.append("\t@" + ApexMakefileGenerator.escapedEcho((String)"Finished generating $(1)_APU_LOAD.h"));
        buffer.append("\t@echo ' '" + NEWLINE);
        buffer.append("endef" + NEWLINE + NEWLINE);
        buffer.append("$(foreach graph,$(GRAPHS),$(eval $(call apu_rules,$(graph))))" + NEWLINE + NEWLINE);
        return buffer;
    }

    protected void populateTopMakefile(IFile fileHandle, boolean rebuild) throws CoreException {
        this.enableCompactBuildCommands();
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.addTopHeader());
        buffer.append(this.addReadElfVariables());
        buffer.append(this.addMacros());
        ArrayList outputVarsAdditionsList = new ArrayList();
        buffer.append(this.addGraphRules());
        StringBuffer targetRules = this.addTargets(outputVarsAdditionsList, rebuild);
        buffer.append(this.writeTopAdditionMacros(outputVarsAdditionsList, this.getTopBuildOutputVars()));
        buffer.append(targetRules);
        ApexMakefileGenerator.save((StringBuffer)buffer, (IFile)fileHandle);
        this.disableCompactBuildCommands();
        this.argumentFileBuilder.writeBuildCommands(fileHandle.getParent().getLocation(), this.topBuildDir);
    }
}

