/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.internal.core;

import com.nxp.s32ds.debug.ide.core.DebuggerLaunchSequence;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.core.S32DebuggerFlashProgrammerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerAttributesValidator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerParams;
import com.nxp.s32ds.debug.ide.s32debugger.internal.core.S32DebuggerBackend;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ReflectionSequence;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitorWithProgress;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.IMIProcesses;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.ILaunchConfiguration;

public class S32DebuggerFlashProgrammerLaunchSequence
extends DebuggerLaunchSequence {
    private static final String SOURCE_SCRIPT = "${S32DS_GDB_SERVER_DIR}/Debugger/scripts/gdb_extensions/flash/s32flash.py";
    private static final String SOURCE_S = "source %s";
    private static final String PY_RESET_DELAY_S = "py _RESET_DELAY = %s";
    private static final String PY_GDB_TIMEOUT_S = "py _GDB_TIMEOUT = %s";
    private static final String DEFAULT = "default";
    private static final String PY_RESET_TYPE_S = "py _RESET_TYPE = \"%s\"";
    private static final String PY_RESET_TYPE_NONE = "py _RESET_TYPE = None";
    private static final String PY_GDB_SERVER_PORT_S = "py _GDB_SERVER_PORT = %s";
    private static final String PY_IS_LOGGING_ENABLED_S = "py _IS_LOGGING_ENABLED = %s";
    private static final String PY_PROBE_IP_S = "py _PROBE_IP = \"%s\"";
    private static final String PY_JTAG_SPEED_S = "py _JTAG_SPEED = %s";
    private static final String PY_FLASH_TYPE_S = "py _FLASH_TYPE = \"%s\"";
    private static final String PY_INIT_SCRIPT_S = "py _INIT_SCRIPT = \"%s\"";
    private static final String PY_FLASH_NAME_S = "py _FLASH_NAME = \"%s\"";
    private static final String PY_FLASH_CMD = "py flash()";
    private static final String FL_CHIP_ERASE = "fl_erase_all";
    private static final String FL_WRITE_FLASH_ELF_CMD_S_S_S = "fl_write_elf %s%s%s%s";
    private static final String FL_WRITE_FLASH_ANY_BINARY_CMD_S_S_S = "fl_write %s%s%s %s";
    private static final String FL_WRITE_FLASH_VERIFY = "-v ";
    private static final String FL_WRITE_FLASH_ERASE = "-e ";
    private static final String FL_WRITE_FLASH_BASE_ADDRESS = "-b %s ";
    private static final String FL_CLOSE_CMD = "fl_close";
    private static final String STEP_DEBUGGER_CLEANUP = "stepDebuggerCleanup";
    private static final String STEP_INITIALIZE_GDB_SERVER_PROCESS = "stepInitializeGdbServerProcess";
    private static final String STEP_INITIALIZE_DEBUGGER_FINAL_LAUNCH_SEQUENCE = "stepInitializeDebuggerFinalLaunchSequence";
    private static final String STEP_NEW_PROCESS = "stepNewProcess";
    private static final String STEP_DATA_MODEL_INITIALIZATION_COMPLETE = "stepDataModelInitializationComplete";
    private static final String STEP_EXECUTE_FLASH_SCRIPT = "stepExecuteFlashScript";
    private static final String STEP_WRITE_FLASH = "stepWriteFlash";
    private static final String STEP_END_FLASH = "stepEndFlash";
    private static final String HEX_PREFIX = "0x";
    protected static final String GROUP_S32_DEBUGGER = "GROUP_S32Debugger";
    private IGDBControl commandControl;
    private IMIProcesses procService;
    private S32DebuggerBackend gdbServerBackend;
    private S32DebuggerFlashProgrammerAttributesValidator validator;
    private S32DebuggerFlashProgrammerParams params;
    private DataRequestMonitor<MIInfo> queueMonitor;

    public S32DebuggerFlashProgrammerLaunchSequence(DsfSession session, Map<String, Object> attributes, RequestMonitorWithProgress rm) {
        super(session, attributes, rm);
        String result;
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)rm.getProgressMonitor(), (int)100);
        ILaunchConfiguration lc = this.launch.getLaunchConfiguration();
        this.params = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lc);
        this.validator = new S32DebuggerFlashProgrammerAttributesValidator();
        monitor.worked(100);
        IStatus status = this.validator.validateFlashParameters(this.params, true);
        if (this.params.isInitialCore() && this.params.isUseSecureDebugging() && (result = super.getSecureDebuggingKeyWord()).isEmpty()) {
            this.shutdownOnError(null, null);
            rm.done(Status.CANCEL_STATUS);
        }
        if (!rm.isCanceled()) {
            rm.done(status);
        }
    }

    private void queueCommand(String command, RequestMonitor rm) {
        if (!command.isEmpty()) {
            this.queueMonitor = new DataRequestMonitor<MIInfo>((Executor)this.getExecutor(), rm){

                protected void handleCompleted() {
                    if (S32DebuggerFlashProgrammerLaunchSequence.this.queueMonitor.isSuccess()) {
                        super.handleSuccess();
                    } else {
                        S32DebuggerFlashProgrammerLaunchSequence.this.queueMonitor.cancel();
                    }
                }
            };
            this.commandControl.queueCommand((ICommand)new CLICommand((IDMContext)this.commandControl.getContext(), command), this.queueMonitor);
        } else {
            rm.done();
        }
    }

    protected String[] getExecutionOrder(String group) {
        if ("GROUP_TOP_LEVEL".equals(group)) {
            ArrayList<String> orderList = new ArrayList<String>(Arrays.asList(super.getExecutionOrder("GROUP_TOP_LEVEL")));
            orderList.removeAll(Arrays.asList(STEP_NEW_PROCESS));
            orderList.add(orderList.indexOf(STEP_DATA_MODEL_INITIALIZATION_COMPLETE), GROUP_S32_DEBUGGER);
            return orderList.toArray(new String[orderList.size()]);
        }
        if (GROUP_S32_DEBUGGER.equals(group)) {
            return new String[]{STEP_INITIALIZE_DEBUGGER_FINAL_LAUNCH_SEQUENCE, STEP_INITIALIZE_GDB_SERVER_PROCESS, STEP_EXECUTE_FLASH_SCRIPT, STEP_WRITE_FLASH, STEP_END_FLASH, STEP_DEBUGGER_CLEANUP};
        }
        return super.getExecutionOrder(group);
    }

    @ReflectionSequence.Execute
    public void stepInitializeDebuggerFinalLaunchSequence(RequestMonitor rm) {
        this.tracker = new DsfServicesTracker(S32DebuggerFlashProgrammerCoreActivator.getContext(), this.getSession().getId());
        this.gdbServerBackend = (S32DebuggerBackend)this.tracker.getService(S32DebuggerBackend.class);
        if (this.gdbServerBackend == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.S32DebuggerGDBErrorStatus", ErrorStatuses.getGDBNoBackendStatus());
            return;
        }
        this.commandControl = (IGDBControl)this.tracker.getService(IGDBControl.class);
        if (this.commandControl == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.S32DebuggerGDBErrorStatus", ErrorStatuses.getGDBNoControlStatus());
            return;
        }
        this.procService = (IMIProcesses)this.tracker.getService(IMIProcesses.class);
        if (this.procService == null) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.S32DebuggerGDBErrorStatus", ErrorStatuses.getGDBNoStatusProcessor());
            return;
        }
        String gdbSetCommands = String.valueOf(this.params.getClientCommands()) + "\n";
        this.queueCommand(gdbSetCommands, rm);
        rm.done();
    }

    @ReflectionSequence.RollBack(value="stepInitializeDebuggerFinalLaunchSequence")
    public void rollBackInitializeFinalLaunchSequence(RequestMonitor rm) {
        this.cleanUp();
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepInitializeGdbServerProcess(RequestMonitor rm) {
        if (!this.gdbServerBackend.initializeGdbServerProcess()) {
            this.shutdownOnError("com.nxp.s32ds.debug.ide.s32debugger.internal.ui.handlers.S32DebuggerGDBErrorStatus", null);
            return;
        }
        rm.done();
    }

    @ReflectionSequence.Execute
    public void stepExecuteFlashScript(RequestMonitor rm) {
        String source = DebuggerUtils.substitute((String)SOURCE_SCRIPT);
        String normalized = new Path(source).toString();
        this.queueCommand(String.format(SOURCE_S, normalized), rm);
        this.queueCommand(String.format(PY_FLASH_TYPE_S, this.params.getFlashType()), rm);
        this.queueCommand(String.format(PY_PROBE_IP_S, this.validator.getVirtualIP()), rm);
        this.queueCommand(String.format(PY_JTAG_SPEED_S, this.params.getJtagSpeedKHz()), rm);
        boolean doLaunchServer = this.params.isDoLaunchServer();
        if (doLaunchServer) {
            this.queueCommand(String.format(PY_IS_LOGGING_ENABLED_S, this.params.isLogEnabled() ? "True" : "False"), rm);
        } else {
            this.queueCommand(String.format(PY_IS_LOGGING_ENABLED_S, "False"), rm);
        }
        this.queueCommand(String.format(PY_GDB_SERVER_PORT_S, this.params.getServerPort()), rm);
        this.queueCommand(String.format(PY_GDB_TIMEOUT_S, this.params.getRemoteTimeoutInSeconds()), rm);
        boolean doResetAndDelay = this.params.isDoResetAndDelay();
        if (doResetAndDelay) {
            String delayInMSeconds = this.params.getDelayInMSeconds();
            this.queueCommand(String.format(PY_RESET_DELAY_S, delayInMSeconds), rm);
        } else {
            this.queueCommand(String.format(PY_RESET_DELAY_S, 0), rm);
        }
        String resetTypeCommand = doResetAndDelay ? String.format(PY_RESET_TYPE_S, DEFAULT) : PY_RESET_TYPE_NONE;
        this.queueCommand(resetTypeCommand, rm);
        if (this.params.isUseSecureDebugging()) {
            this.queueCommand(String.format("py _SECURE_TYPE = \"%s\"", this.params.getSecureDebuggingType()), rm);
            this.queueCommand(String.format("py _SECURE_KEY = \"%s\"", this.keyWord), rm);
        }
        this.queueCommand(String.format(PY_INIT_SCRIPT_S, new Path(DebuggerUtils.substitute((String)this.params.getInitializationScript())).toString()), rm);
        this.queueCommand(String.format(PY_FLASH_NAME_S, this.params.getFlashName()), rm);
        this.queueCommand(PY_FLASH_CMD, rm);
    }

    @ReflectionSequence.Execute
    public void stepWriteFlash(RequestMonitor rm) {
        Map idToBinaryMap = this.params.getIdToBinaryMap();
        Map binaryIdToBinaryTypeMap = this.params.getBinaryIdToBinaryTypeMap();
        Map binariIdIsEnabledMap = this.params.getBinaryIdIsEnabledMap();
        Map binaryIdToProjectNameMap = this.params.getBinaryIdToProjectNameMap();
        Map binaryIdToBaseAddressMap = this.params.getBinaryIdToBaseAddressMap();
        boolean chipErase = this.params.isFlashMemoryErase();
        if (chipErase) {
            this.queueCommand(FL_CHIP_ERASE, rm);
        }
        boolean verifyAfterWrite = this.params.isVerifyAfterWrite();
        for (String binaryId : idToBinaryMap.keySet()) {
            String baseAddr;
            String enabled = (String)binariIdIsEnabledMap.get(binaryId);
            if ("disabled".equals(enabled)) continue;
            String binaryPath = DebuggerUtils.substitute((String)((String)idToBinaryMap.get(binaryId)));
            if (!Files.exists(Paths.get(binaryPath, new String[0]), new LinkOption[0])) {
                binaryPath = DebuggerUtils.getAbsoluteBinaryPathByProjectName((String)((String)binaryIdToProjectNameMap.get(binaryId)), (String)binaryPath);
            }
            String verifyStr = "";
            if (verifyAfterWrite) {
                verifyStr = FL_WRITE_FLASH_VERIFY;
            }
            String eraseStr = "";
            if (!chipErase) {
                eraseStr = FL_WRITE_FLASH_ERASE;
            }
            if (!(baseAddr = (String)binaryIdToBaseAddressMap.get(binaryId)).isEmpty() && !baseAddr.startsWith(HEX_PREFIX)) {
                baseAddr = HEX_PREFIX + baseAddr;
            }
            if ("elf".equals(binaryIdToBinaryTypeMap.get(binaryId))) {
                if (!baseAddr.isEmpty()) {
                    baseAddr = String.format(FL_WRITE_FLASH_BASE_ADDRESS, baseAddr);
                }
                this.queueCommand(String.format(FL_WRITE_FLASH_ELF_CMD_S_S_S, verifyStr, eraseStr, baseAddr, binaryPath), rm);
                continue;
            }
            this.queueCommand(String.format(FL_WRITE_FLASH_ANY_BINARY_CMD_S_S_S, verifyStr, eraseStr, baseAddr, binaryPath), rm);
        }
    }

    @ReflectionSequence.Execute
    public void stepEndFlash(RequestMonitor rm) {
        this.queueCommand(FL_CLOSE_CMD, rm);
    }

    @ReflectionSequence.Execute
    public void stepDebuggerCleanup(RequestMonitor rm) {
        this.cleanUp();
        rm.done();
    }
}

