/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.internal.core;

import com.freescale.s32ds.cross.core.ProjectContextSaver;
import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.CoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceCoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashAlgorithmDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashProtocolDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FlashDescriptors;
import com.nxp.s32ds.debug.ide.core.ErrorStatuses;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerParams;
import com.nxp.s32ds.debug.ide.s32debugger.validation.S32DebuggerParams;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class S32DebuggerFlashProgrammerLaunchConfigurationSupport
implements LaunchConfigurationCreator {
    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> attributes) throws CoreException {
        IResource launchResource;
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        String component = LaunchConfigurationUtil.extractComponent(attributes);
        ILaunchConfigurationType debugerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("com.nxp.s32ds.debug.ide.s32debugger.flash.core.s32DebuggerFlashProgrammerLaunchConfigurationType");
        if (debugerLaunchType == null) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        ILaunchConfigurationWorkingCopy workingCopy = null;
        IFolder container = hostProject.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = hostProject;
        }
        if ((launchResource = container.findMember(String.valueOf(component) + ".launch")) != null && launchResource.isAccessible()) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationExistsStatus((IPath)launchResource.getLocation()));
        }
        String configurationName = hostProject.getName();
        workingCopy = debugerLaunchType.newInstance((IContainer)container, configurationName);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, attributes);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy, Map<String, Object> attributes) throws CoreException {
        DeviceCoreDescriptor deviceCoreDescriptor;
        IProject hostProject = LaunchConfigurationUtil.extractProject(attributes);
        ProjectContextSaver pc = new ProjectContextSaver(hostProject);
        String deviceCoreId = pc.load("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        if (deviceCoreId == null || deviceCoreId.isEmpty()) {
            deviceCoreId = LaunchConfigurationUtil.extractHardwareCoreId(attributes);
        }
        if ((deviceCoreDescriptor = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId)) == null) {
            throw new CoreException(ErrorStatuses.getLaunchConfigurationTypeUndefinedStatus());
        }
        S32DebuggerParams params = new S32DebuggerParams();
        params.setDevice(deviceCoreDescriptor.getDeviceId());
        params.setCore(deviceCoreDescriptor.getCoreId());
        String initializationScriptPath = DeviceCoreDebuggerDescriptors.getInitScript((String)deviceCoreDescriptor.getId(), (String)"s32debugger");
        params.setInitializationScript(initializationScriptPath);
        params.setClientExecutable(CoreDebuggerDescriptors.getClientPath((String)deviceCoreDescriptor.getCoreId(), (String)"s32debugger"));
        params.setClientCommands((String)S32DebuggerCoreActivator.getDeviceClientCommands().get(deviceCoreDescriptor.getId()));
        params.applyParams(workingCopy);
        String executable = LaunchConfigurationUtil.extractProjectExecutable(attributes);
        S32DebuggerFlashProgrammerParams flashParams = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)workingCopy);
        HashMap<String, String> idToBinaryMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdIsEnabledMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdToBaseAddressMap = new HashMap<String, String>();
        HashMap<String, String> binaryIdToProjectNameMap = new HashMap<String, String>();
        String binaryId = flashParams.getNextProjectId();
        idToBinaryMap.put(binaryId, executable);
        binaryIdIsEnabledMap.put(binaryId, "enabled");
        binaryIdToBaseAddressMap.put(binaryId, "");
        binaryIdToProjectNameMap.put(binaryId, "<undefined>");
        flashParams.setIdToBinaryMap(idToBinaryMap);
        flashParams.setBinaryIdIsEnabledMap(binaryIdIsEnabledMap);
        flashParams.setBinaryIdToBaseAddressMap(binaryIdToBaseAddressMap);
        flashParams.setBinaryIdToProjectNameMap(binaryIdToProjectNameMap);
        List descriptors = FlashDescriptors.getFlashRegistry().getFlashAlgorithmDescriptorsByDeviceId(deviceCoreDescriptor.getDeviceId());
        if (!descriptors.isEmpty()) {
            String flashId = ((FlashAlgorithmDescriptor)descriptors.get(0)).getFlashId();
            flashParams.setFlashName(FlashDescriptors.getFlashRegistry().getFlashDescriptor(flashId).getName());
            flashParams.setFlashType(((FlashProtocolDescriptor)FlashDescriptors.getFlashRegistry().getFlashProtocolDescriptorsByFlashId(flashId).get(0)).getProtocolId());
        }
        flashParams.applyParams(workingCopy);
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", executable);
        workingCopy.setMappedResources(new IResource[]{hostProject});
    }
}

