/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.isp.internal.launch.delegate;

import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.rcp.variables.VariableManager;
import com.nxp.s32ds.gte.isp.Import;
import com.nxp.s32ds.gte.isp.IspEngine;
import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.gte.isp.IspIpuEngine;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernel;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernelRegistry;
import com.nxp.s32ds.mdt.ide.launch.core.MdtLaunchConfigSupports;
import com.nxp.s32ds.mdt.vpt.isp.core.kernels.IspKernelRegistryManager;
import com.nxp.s32ds.mdt.vpt.isp.core.kernels.IspKernels;
import com.nxp.s32ds.mdt.vpt.isp.core.launch.IspLaunchParams;
import com.nxp.s32ds.mdt.vpt.isp.core.launch.IspLaunchUtil;
import com.nxp.s32ds.mdt.vpt.isp.core.vsdk.IspVsdkHelper;
import com.nxp.s32ds.mdt.vpt.isp.internal.launch.IspLaunchActivator;
import com.nxp.s32ds.mdt.vpt.isp.internal.launch.Messages;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class IspLaunchDelegateUtil {
    private static final String EXTENSION_DAT = ".dat";

    static IspGraph loadGraph(IFile file) throws CoreException {
        IspGraph ispGraph = null;
        String graphPath = file.getFullPath().toString();
        URI uri = URI.createPlatformResourceURI((String)graphPath, (boolean)true);
        List load = EmfResources.load((URI)uri);
        ispGraph = (IspGraph)EObjects.firstOrNull((Collection)load, IspGraph.class);
        if (ispGraph == null) {
            throw IspLaunchActivator.abort(NLS.bind((String)Messages.IspGenLaunchDelegate_cannot_load_isp_graph_from_0, (Object)graphPath));
        }
        return ispGraph;
    }

    static void cleanup(IspLaunchParams params, IProject project, IspGraph graph, IProgressMonitor monitor) throws CoreException {
        IspLaunchDelegateUtil.preGenerate(params, project, graph, monitor);
    }

    public static void preGenerate(IspLaunchParams params, IProject project, IspGraph graph, IProgressMonitor monitor) throws CoreException {
        IProject modelProject = IspLaunchUtil.getModelFile(params.getGraphPath()).getProject();
        if (modelProject.equals((Object)project)) {
            return;
        }
        monitor.setTaskName(Messages.IspGenLaunchDelegateUtil_Removing_kernels_file);
        IspLaunchDelegateUtil.removeKernelFiles(params, project, monitor);
        monitor.worked(10);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.setTaskName(Messages.IspLaunchDelegateUtil_removing_kmem_file);
        IspLaunchDelegateUtil.removeKmem(params, project, monitor);
        monitor.worked(10);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.setTaskName(Messages.IspLaunchDelegateUtil_removing_static_sequencer_files);
        IspLaunchDelegateUtil.removeStaticSequencerFiles(params, project, monitor);
        monitor.worked(10);
        if (monitor.isCanceled()) {
            return;
        }
    }

    static void postGenerate(IspLaunchParams params, IProject project, IspGraph graph, IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            return;
        }
        if (project == null || !project.isAccessible()) {
            return;
        }
        IspLaunchDelegateUtil.doPostGenerate(params, project, graph, monitor);
        monitor.worked(10);
        monitor.setTaskName(Messages.IspGenLaunchDelegateUtil_Refreshing_local_project);
        project.refreshLocal(2, monitor);
    }

    private static void removeDatFiles(IspLaunchParams params, IProject project, IspGraph graph, IProgressMonitor monitor) throws CoreException {
        String datFile = IspLaunchDelegateUtil.getSourcesOutputPath(params).append(IspLaunchParams.getTargetSrcFolder()).append(String.valueOf(graph.getName().toLowerCase()) + EXTENSION_DAT).toOSString();
        java.nio.file.Path path = Paths.get(datFile, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                IspLaunchActivator.getInstance().logError(String.valueOf(Messages.IspGenLaunchDelegateUtil_cannot_delete_file_) + datFile, e);
            }
        }
    }

    static void doPostGenerate(IspLaunchParams params, IProject project, IspGraph graph, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        subMonitor.setTaskName(Messages.IspGenLaunchDelegateUtil_delete_dat_files);
        IspLaunchDelegateUtil.removeDatFiles(params, project, graph, (IProgressMonitor)subMonitor);
        subMonitor.worked(20);
        if (subMonitor.isCanceled()) {
            return;
        }
        subMonitor.setTaskName(Messages.IspGenLaunchDelegateUtil_Processing_creating_launch_file);
        IProject modelProject = IspLaunchUtil.getModelFile(params.getGraphPath()).getProject();
        if (modelProject.equals((Object)project)) {
            subMonitor.worked(80);
            return;
        }
        subMonitor.setTaskName(Messages.IspGenLaunchDelegateUtil_Copying_kernels_file);
        IspLaunchDelegateUtil.copyKernelFiles(params, project, graph, (IProgressMonitor)subMonitor);
        if (subMonitor.isCanceled()) {
            return;
        }
        subMonitor.worked(30);
        subMonitor.setTaskName(Messages.IspGenLaunchDelegateUtil_Preparing_data_for_creating_launch_file);
        IspLaunchDelegateUtil.createHostLaunchConfiguration(project, graph);
        if (subMonitor.isCanceled()) {
            return;
        }
        subMonitor.worked(30);
        subMonitor.setTaskName(Messages.IspGenLaunchDelegateUtil_Copying_user_define_files);
        IspLaunchDelegateUtil.copyUserDefinedFiles(params, project, graph, (IProgressMonitor)subMonitor);
        subMonitor.worked(20);
    }

    private static void createHostLaunchConfiguration(IProject project, IspGraph graph) {
        Set<String> engines = IspLaunchDelegateUtil.createEnginesList(graph);
        try {
            IStatus status = MdtLaunchConfigSupports.createLaunchConfigSupport((IProject)project, (EObject)graph, Collections.singleton(graph.getName()), engines);
            if (!status.isOK()) {
                IspLaunchActivator.getInstance().log(status);
            }
        }
        catch (Exception ex) {
            IspLaunchActivator.getInstance().logWarning(Messages.IspGenLaunchDelegateUtil_failed_to_create_launch_config_support, ex);
        }
    }

    private static Set<String> createEnginesList(IspGraph graph) {
        HashSet<String> result = new HashSet<String>();
        for (IspEngine engine : graph.getEngines()) {
            if (!(engine instanceof IspIpuEngine)) continue;
            IspIpuEngine ipuEngine = (IspIpuEngine)engine;
            String engineType = "";
            if (ipuEngine.getEngineType().getName().trim().equalsIgnoreCase("SCALAR")) {
                engineType = "IPUS";
            }
            if (ipuEngine.getEngineType().getName().trim().equalsIgnoreCase("VECTOR")) {
                engineType = "IPUV";
            }
            result.add(String.format("%s,%s,%s", engineType, ipuEngine.getEngineIndex(), ipuEngine.getKernel()));
        }
        return result;
    }

    private static void removeStaticSequencerFiles(IspLaunchParams params, IProject project, IProgressMonitor monitor) throws CoreException {
        IResource staticSourceResource = project.findMember(String.valueOf(params.getStaticSourceFolder()) + '/' + IspLaunchParams.getTargetSrcFolder());
        if (staticSourceResource == null || !staticSourceResource.exists()) {
            return;
        }
        if (!(staticSourceResource instanceof IFolder)) {
            return;
        }
        IFolder staticSourceFolder = (IFolder)staticSourceResource;
        IResource[] folderResource = staticSourceFolder.members();
        SubMonitor subMonitorClear = SubMonitor.convert((IProgressMonitor)monitor, (int)folderResource.length);
        subMonitorClear.beginTask(Messages.IspGenLaunchDelegateUtil_Clear_resources, folderResource.length);
        IResource[] iResourceArray = folderResource;
        int n = folderResource.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            res.delete(true, monitor);
            if (subMonitorClear.isCanceled()) {
                return;
            }
            subMonitorClear.worked(1);
            ++n2;
        }
    }

    private static void removeKernelFiles(IspLaunchParams params, IProject project, IProgressMonitor monitor) throws CoreException {
        IResource kernelSrcResource = project.findMember(IspLaunchParams.getKernelsFolder());
        if (kernelSrcResource == null || !kernelSrcResource.exists()) {
            return;
        }
        if (!(kernelSrcResource instanceof IFolder)) {
            return;
        }
        IFolder kernelSrcFolder = (IFolder)kernelSrcResource;
        IResource[] folderResource = kernelSrcFolder.members();
        SubMonitor subMonitorClear = SubMonitor.convert((IProgressMonitor)monitor, (int)folderResource.length);
        subMonitorClear.beginTask(Messages.IspGenLaunchDelegateUtil_Clear_resources, folderResource.length);
        IResource[] iResourceArray = folderResource;
        int n = folderResource.length;
        int n2 = 0;
        while (n2 < n) {
            IResource res = iResourceArray[n2];
            res.delete(true, monitor);
            if (subMonitorClear.isCanceled()) {
                return;
            }
            subMonitorClear.worked(1);
            ++n2;
        }
    }

    private static void removeKmem(IspLaunchParams params, IProject project, IProgressMonitor monitor) throws CoreException {
        String datFile = IspLaunchDelegateUtil.getSourcesOutputPath(params).append(IspLaunchParams.getTargetSrcFolder()).append("kmem.c").toOSString();
        java.nio.file.Path path = Paths.get(datFile, new String[0]);
        if (Files.exists(path, new LinkOption[0]) && Files.isRegularFile(path, new LinkOption[0])) {
            try {
                Files.delete(path);
            }
            catch (IOException e) {
                IspLaunchActivator.getInstance().logError(String.valueOf(Messages.IspGenLaunchDelegateUtil_cannot_delete_file_) + datFile, e);
            }
        }
    }

    private static IPath getSourcesOutputPath(IspLaunchParams params) throws CoreException {
        IPath outputPath = IspLaunchUtil.getOutput(params.getOutputPath());
        String sourceFolder = params.getDynamicSourceFolder();
        if (!sourceFolder.isEmpty()) {
            outputPath = outputPath.append(sourceFolder);
        }
        return outputPath;
    }

    private static void copyKernelFiles(IspLaunchParams params, IProject project, IspGraph graph, IProgressMonitor monitor) throws CoreException {
        IFolder folder;
        IResource kernelSrcResource = project.findMember(IspLaunchParams.getKernelsFolder());
        if (kernelSrcResource == null || !kernelSrcResource.exists()) {
            folder = project.getFolder((IPath)new Path(IspLaunchParams.getKernelsFolder()));
            folder.create(false, true, monitor);
        } else if (kernelSrcResource instanceof IFolder) {
            folder = (IFolder)kernelSrcResource;
        } else {
            throw IspLaunchActivator.abort(NLS.bind((String)Messages.IspGenLaunchDelegateUtil_resource_0_should_be_a_folder, (Object)kernelSrcResource));
        }
        SubMonitor subMonitorCopy = SubMonitor.convert((IProgressMonitor)monitor, (int)graph.getEngines().size());
        subMonitorCopy.beginTask(Messages.IspGenLaunchDelegateUtil_Copy_resources, graph.getEngines().size());
        IPathVariableManager pathVariableManager = folder.getWorkspace().getPathVariableManager();
        String vsdkPathVariable = IspVsdkHelper.getInstance().getVsdkPathVariable();
        for (IspEngine it : graph.getEngines()) {
            if (!(it instanceof IspIpuEngine)) continue;
            IspIpuEngine ipuEngine = (IspIpuEngine)it;
            IcfKernelRegistry kernelRegistry = IspKernelRegistryManager.getInstance().getKernelRegistry((EObject)graph);
            String kernelName = ipuEngine.getKernel();
            if (kernelName == null || kernelName.trim().isEmpty()) continue;
            IcfKernel kernel = kernelRegistry.getKernel(kernelName, IspKernels.getType((IspIpuEngine)ipuEngine));
            java.nio.file.Path nioPath = kernel.getPath();
            if (!Files.exists(nioPath, new LinkOption[0]) || !Files.isRegularFile(nioPath, new LinkOption[0])) {
                throw IspLaunchActivator.abort(NLS.bind((String)Messages.IspGenLaunchDelegateUtil_cannot_find_file_for_kernel_0, (Object)kernelName));
            }
            IFile iFileKernel = folder.getFile(nioPath.getFileName().toString());
            boolean linkCreated = false;
            if (pathVariableManager.isDefined(vsdkPathVariable)) {
                try {
                    java.net.URI absoluteUri = URIUtil.toURI((String)nioPath.toString());
                    java.net.URI relativeUri = pathVariableManager.convertToRelative(absoluteUri, false, vsdkPathVariable);
                    iFileKernel.createLink(relativeUri, 256, (IProgressMonitor)subMonitorCopy);
                    linkCreated = true;
                }
                catch (CoreException e) {
                    IspLaunchActivator.getInstance().logError(NLS.bind((String)Messages.IspLaunchDelegateUtil_cannot_convert_kernel_path_0_relative_to_1_path_variable, (Object)nioPath.toString(), (Object)vsdkPathVariable), e);
                }
            }
            if (!linkCreated) {
                iFileKernel.createLink((IPath)new Path(nioPath.toString()), 256, (IProgressMonitor)subMonitorCopy);
            }
            if (subMonitorCopy.isCanceled()) {
                return;
            }
            subMonitorCopy.worked(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyUserDefinedFiles(IspLaunchParams params, IProject project, IspGraph graph, IProgressMonitor monitor) throws CoreException {
        IFolder incFolder = project.getFolder(IspLaunchParams.getIncludesFolder());
        if (!incFolder.exists()) {
            return;
        }
        if (graph.getHeaders().isEmpty()) {
            return;
        }
        SubMonitor subMonitorCopy = SubMonitor.convert((IProgressMonitor)monitor, (int)graph.getHeaders().size());
        subMonitorCopy.beginTask(Messages.IspGenLaunchDelegateUtil_Copy_user_resources, graph.getHeaders().size());
        for (Import it : graph.getHeaders()) {
            if (!it.getFileName().endsWith("iofiles.h") && !it.isUserDefined()) continue;
            String pathFSImport = VariableManager.INSTANCE.performSubstitution(it.getPath());
            IFile fileInclude = incFolder.getFile(it.getFileName());
            if (fileInclude.exists()) continue;
            try {
                Throwable throwable = null;
                Object var11_13 = null;
                try {
                    FileInputStream fileStream = new FileInputStream(pathFSImport);
                    try {
                        fileInclude.create((InputStream)fileStream, false, (IProgressMonitor)subMonitorCopy);
                        if (subMonitorCopy.isCanceled()) {
                            return;
                        }
                        subMonitorCopy.worked(1);
                    }
                    finally {
                        if (fileStream == null) return;
                        fileStream.close();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                        throw throwable;
                    }
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw IspLaunchActivator.abort(e.getMessage(), e);
            }
        }
    }
}

