/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.isp.internal.launch.delegate;

import com.nxp.s32ds.ext.emf.validation.EmfValidation;
import com.nxp.s32ds.ext.ide.externaltools.ExternalToolsLaunchDelegate;
import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.mdt.ide.launch.core.BuildParticipant;
import com.nxp.s32ds.mdt.ide.launch.core.MdtLaunchDelegate;
import com.nxp.s32ds.mdt.ide.launch.core.MdtLaunchParams;
import com.nxp.s32ds.mdt.vpt.isp.core.launch.IspLaunchConfigurationUtil;
import com.nxp.s32ds.mdt.vpt.isp.core.launch.IspLaunchParams;
import com.nxp.s32ds.mdt.vpt.isp.core.launch.IspLaunchUtil;
import com.nxp.s32ds.mdt.vpt.isp.internal.launch.IspLaunchActivator;
import com.nxp.s32ds.mdt.vpt.isp.internal.launch.delegate.IspLaunchDelegateUtil;
import java.io.File;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;

public class IspLaunchDelegate
extends ExternalToolsLaunchDelegate
implements BuildParticipant,
MdtLaunchDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getTargetProject(configuration);
        IspLaunchParams params = IspLaunchParams.getParams(configuration);
        IPath outputPath = IspLaunchUtil.getOutput(params.getOutputPath());
        IFile graphPath = IspLaunchUtil.getModelFile(params.getGraphPath());
        IspGraph graph = IspLaunchDelegateUtil.loadGraph(graphPath);
        switch (mode) {
            case "clean": {
                this.clean(project, configuration, monitor);
                return;
            }
            case "emit": {
                if (!EmfValidation.validate((EObject)graph) || monitor.isCanceled()) {
                    return;
                }
                if (!this.launchGeneration(configuration, mode, launch, monitor, params, graph)) break;
                this.showFinish();
                break;
            }
            case "emit_build": {
                boolean graphsModified;
                if (monitor.isCanceled()) {
                    throw IspLaunchActivator.cancel();
                }
                IPath source = outputPath;
                String sourceFolder = params.getDynamicSourceFolder().trim();
                if (!sourceFolder.isEmpty()) {
                    source = outputPath.append(sourceFolder);
                }
                if (!(graphsModified = IspLaunchDelegate.graphFilesWasModified(graphPath, source, graph.getName()))) {
                    return;
                }
                if (!EmfValidation.validate((EObject)graph) || monitor.isCanceled()) {
                    throw IspLaunchActivator.cancel();
                }
                if (this.launchGeneration(configuration, mode, launch, monitor, params, graph)) break;
                throw IspLaunchActivator.cancel();
            }
        }
    }

    private boolean launchGeneration(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor, IspLaunchParams params, IspGraph graph) throws CoreException {
        IProject project = this.getTargetProject(configuration);
        if (project != null) {
            IspLaunchDelegateUtil.preGenerate(params, project, graph, monitor);
        }
        ILaunchConfigurationWorkingCopy workingCopy = configuration.getWorkingCopy();
        IspLaunchConfigurationUtil.getInstance().applyExternalToolAtributes(workingCopy, params);
        super.launch((ILaunchConfiguration)workingCopy, mode, launch, monitor);
        if (monitor.isCanceled()) {
            return false;
        }
        if (project != null) {
            IspLaunchDelegateUtil.postGenerate(params, project, graph, monitor);
        }
        return true;
    }

    public void doPostGenerate(MdtLaunchParams params, IProject project, EObject eObject, IProgressMonitor monitor) throws CoreException {
        IspGraph graph = (IspGraph)eObject;
        IspLaunchParams ispParams = (IspLaunchParams)params;
        IspLaunchDelegateUtil.doPostGenerate(ispParams, project, graph, monitor);
    }

    private static boolean graphFilesWasModified(IFile graph, IPath source, String graphName) {
        File graphSrc = source.append("src/" + graphName + ".c").toFile();
        if (!graphSrc.isFile()) {
            return true;
        }
        return graph.getLocalTimeStamp() > graphSrc.lastModified();
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        IspLaunchParams params = IspLaunchParams.getParams(configuration);
        IspLaunchUtil.getOutput(params.getOutputPath());
        IFile graphPath = IspLaunchUtil.getModelFile(params.getGraphPath());
        IProject modelProject = graphPath.getProject();
        if (modelProject != null) {
            IProject[] projects = new IProject[]{modelProject};
            return projects;
        }
        return null;
    }

    public void clean(IProject project, ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        IspLaunchParams params = IspLaunchParams.getParams(config);
        IFile graphPath = IspLaunchUtil.getModelFile(params.getGraphPath());
        IspGraph graph = IspLaunchDelegateUtil.loadGraph(graphPath);
        IspLaunchDelegateUtil.cleanup(params, project, graph, monitor);
    }

    public IFile getModelFileFromConfig(ILaunchConfiguration config) throws CoreException {
        return IspLaunchUtil.getModelFile(IspLaunchParams.getParams(config).getGraphPath());
    }
}

