/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.isp.core.launch;

import com.nxp.s32ds.ext.ide.resources.WorkspaceResources;
import com.nxp.s32ds.mdt.vpt.isp.internal.launch.IspLaunchActivator;
import com.nxp.s32ds.mdt.vpt.isp.internal.launch.Messages;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class IspLaunchUtil {
    public static IPath getFilePath(String location) throws CoreException {
        if (location == null) {
            throw IspLaunchActivator.abort(Messages.IspLaunchUtil_location_is_null);
        }
        if (location.trim().isEmpty()) {
            throw IspLaunchActivator.abort(Messages.IspLaunchUtil_location_is_empty);
        }
        try {
            String expandedLocation = IspLaunchUtil.performStringSubstitution(location);
            if (!Files.isRegularFile(Paths.get(expandedLocation, new String[0]), new LinkOption[0])) {
                throw IspLaunchActivator.abort(NLS.bind((String)Messages.IspLaunchUtil_the_file_does_not_exist_0, (Object)expandedLocation));
            }
            return new Path(expandedLocation);
        }
        catch (Exception e) {
            throw IspLaunchActivator.abort(NLS.bind((String)Messages.IspLaunchUtil_cannot_build_path_0_caused_by_1, (Object)location, (Object)e.getMessage()), e);
        }
    }

    public static IFile getModelFile(String location) throws CoreException {
        IFile file;
        if (location == null || location.isEmpty()) {
            throw IspLaunchActivator.abort(Messages.IspLaunchUtil_path_to_graph_is_not_defined);
        }
        try {
            file = WorkspaceResources.getFile((IPath)new Path(location));
        }
        catch (Exception e) {
            throw IspLaunchActivator.abort(NLS.bind((String)Messages.IspLaunchUtil_cannot_build_path_0_caused_by_1, (Object)location, (Object)e.getMessage()), e);
        }
        if (!file.exists()) {
            throw IspLaunchActivator.abort(NLS.bind((String)Messages.IspEmitter_e_graph_not_found, (Object)location));
        }
        return file;
    }

    public static IPath getOutput(String location) throws CoreException {
        if (location == null || location.isEmpty()) {
            throw IspLaunchActivator.abort(Messages.IspLaunchUtil_path_to_output_folder_is_not_defined);
        }
        String substitution = IspLaunchUtil.performStringSubstitution(location);
        try {
            java.nio.file.Path path = Paths.get(substitution, new String[0]);
            if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                throw IspLaunchActivator.abort(Messages.IspEmitter_e_output_should_be_a_directory);
            }
            return new Path(substitution);
        }
        catch (Exception e) {
            throw IspLaunchActivator.abort(NLS.bind((String)Messages.IspLaunchUtil_cannot_build_path_0_caused_by_1, (Object)location, (Object)e.getMessage()), e);
        }
    }

    private static String performStringSubstitution(String output) throws CoreException {
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(output);
    }
}

