/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.isp.core.launch;

import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.mdt.ide.core.MdtIdeCore;
import com.nxp.s32ds.mdt.ide.core.vsdk.MdtVsdkHelper;
import com.nxp.s32ds.mdt.ide.launch.core.MdtLaunchConfiguration;
import com.nxp.s32ds.mdt.vpt.isp.core.launch.IspLaunchParams;
import com.nxp.s32ds.mdt.vpt.isp.core.vsdk.IspVsdkHelper;
import com.nxp.s32ds.mdt.vpt.isp.internal.launch.IspLaunchActivator;
import com.nxp.s32ds.mdt.vpt.isp.internal.launch.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class IspLaunchConfigurationUtil
extends MdtLaunchConfiguration {
    public static final String CONFIGURATION_TYPE = "com.nxp.s32ds.mdt.vpt.isp.core.ispEmit";
    private static IspLaunchConfigurationUtil INSTANCE = new IspLaunchConfigurationUtil();
    private static final String DYNAMIC_SOURCE_FOLDER = "A53_gen";
    private static final String STATIC_SOURCE_FOLDER = "SEQ_gen";

    public static IspLaunchConfigurationUtil getInstance() {
        return INSTANCE;
    }

    private IspLaunchConfigurationUtil() {
        super("isp");
    }

    protected MdtVsdkHelper getVsdkHelper() {
        return IspVsdkHelper.getInstance();
    }

    public static ILaunchConfigurationWorkingCopy createConfiguration(IContainer container, String name, boolean staticSequencer) throws CoreException {
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(CONFIGURATION_TYPE);
        ILaunchConfigurationWorkingCopy workingCopy = type.newInstance(container, name);
        IspLaunchParams params = new IspLaunchParams();
        params.setStaticSequencer(staticSequencer);
        params.applyParams(workingCopy);
        return workingCopy;
    }

    public static ILaunchConfigurationWorkingCopy createConfiguration(IContainer container, EObject semanticType, boolean staticSequencer) throws CoreException {
        if (!(semanticType instanceof IspGraph)) {
            throw IspLaunchActivator.abort(Messages.IspCore_e_missed_graph);
        }
        IspGraph graph = (IspGraph)semanticType;
        IFile modelFile = MdtIdeCore.toWorkspaceFile((EObject)graph);
        if (modelFile == null || !modelFile.exists()) {
            throw IspLaunchActivator.abort(Messages.IspLaunch_model_file_not_found);
        }
        IProject modelProject = modelFile.getProject();
        IProject containerProject = container.getProject();
        String name = containerProject.equals((Object)modelProject) ? NLS.bind((String)Messages.IspEmitter_model_project_pattern_0_1, (Object)modelProject.getName(), (Object)graph.getName()) : NLS.bind((String)Messages.IspEmitter_host_project_pattern_0_1_2, (Object[])new Object[]{containerProject.getName(), modelProject.getName(), graph.getName()});
        ILaunchConfigurationWorkingCopy workingCopy = IspLaunchConfigurationUtil.createConfiguration(container, NLS.bind((String)Messages.IspEmitter_name_pattern, (Object)name), staticSequencer);
        IspLaunchParams params = IspLaunchParams.getParams((ILaunchConfiguration)workingCopy);
        params.setOutputPath(MdtIdeCore.toWorkspaceVariabled((String)containerProject.getName()));
        if (!modelProject.equals((Object)containerProject)) {
            params.setDynamicSourceFolder(DYNAMIC_SOURCE_FOLDER);
            params.setStaticSourceFolder(STATIC_SOURCE_FOLDER);
            params.setEmitHost(true);
        }
        params.setGraphPath(modelFile.getFullPath().toPortableString());
        params.applyParams(workingCopy);
        return workingCopy;
    }
}

