/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.arm.ui.handlers;

import com.freescale.s32ds.cross.core.model.context.CProjectMasterContext;
import com.freescale.s32ds.cross.wizard.handler.DebuggerHandler;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;

public class ArmDebuggerHandler
extends DebuggerHandler {
    private static final String COM_IAR_CDT_ARM_V7_TOOLCHAIN = "com.iar.cdt.arm.v7.toolchain";
    private static final String IAR = "iar";
    private static final String COM_IAR_CDT_ARM_DEBUGGER = "com.iar.cdt.arm.debugger";
    private static final String GDB = "gdb";
    private static final String ISYSTEM = "isystem";
    private static final String T32 = "t32";
    private static final String IAR_ARM_TOOLCHAIN = "iar.arm.toolchain";
    private static final String V8_0_0 = ".v8.0.0";
    private static final String V7_0_0 = ".v6.1.0";
    private static final String ORG_ECLIPSE_CDT = "org.eclipse.cdt";
    private static final String SI_ISYSTEM_ECLIPSE_DEBUG = "si.isystem.eclipse.debug";
    private static final String COM_LAUTERBACH_TRACE32_DEBUG_T32 = "com.lauterbach.trace32.debug.t32";
    private static Set<String> hsCoreType_7x = new HashSet<String>();
    private static Set<String> hsCoreType_8x = new HashSet<String>();

    static {
        hsCoreType_7x.add("S32K144_M4");
        hsCoreType_7x.add("S32K144_M4_1");
        hsCoreType_7x.add("SKEAZ64M4_M0plus_1");
        hsCoreType_7x.add("SKEAZ128M4_M0plus_1");
        hsCoreType_7x.add("SKEAZN16M2_M0plus_1");
        hsCoreType_7x.add("SKEAZN32M2_M0plus_1");
        hsCoreType_7x.add("SKEAZN64M2_M0plus_1");
        hsCoreType_7x.add("SKEAZN8M4_M0plus_1");
        hsCoreType_8x.add("S32K144_M4");
        hsCoreType_8x.add("S32K144_M4_1");
        hsCoreType_8x.add("S32K148_M4");
        hsCoreType_8x.add("S32K148_M4_1");
        hsCoreType_8x.add("S32K142_M4");
        hsCoreType_8x.add("S32K142_M4_1");
    }

    protected Map<String, String> createDebuggerMap(CProjectMasterContext context) {
        Map map = super.createDebuggerMap(context);
        map.put(COM_LAUTERBACH_TRACE32_DEBUG_T32, T32);
        map.put(SI_ISYSTEM_ECLIPSE_DEBUG, ISYSTEM);
        map.put(ORG_ECLIPSE_CDT, GDB);
        String coreNatureId = context.getCoreNatureId();
        String toolChainId = context.getToolChainId();
        Bundle bundle = Platform.getBundle((String)COM_IAR_CDT_ARM_V7_TOOLCHAIN);
        if (toolChainId.contains("iar.arm.toolchain.v6.1.0") && bundle == null && hsCoreType_7x.contains(coreNatureId) || toolChainId.contains("iar.arm.toolchain.v8.0.0") && hsCoreType_8x.contains(coreNatureId)) {
            map.put(COM_IAR_CDT_ARM_DEBUGGER, IAR);
        }
        return map;
    }
}

