/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.isp.internal.design.service;

import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.gte.isp.IspBuffer;
import com.nxp.s32ds.gte.isp.IspChannel;
import com.nxp.s32ds.gte.isp.IspDataType;
import com.nxp.s32ds.gte.isp.IspDdrBuffer;
import com.nxp.s32ds.gte.isp.IspEngine;
import com.nxp.s32ds.gte.isp.IspFdmaTransfer;
import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.gte.isp.IspIpuEngine;
import com.nxp.s32ds.gte.isp.IspMipiEngine;
import com.nxp.s32ds.gte.isp.IspOtherEngine;
import com.nxp.s32ds.gte.isp.IspPort;
import com.nxp.s32ds.gte.isp.IspPortIn;
import com.nxp.s32ds.gte.isp.IspPortOut;
import com.nxp.s32ds.gte.isp.IspTypeEng;
import com.nxp.s32ds.gte.isp.IspTypeIpu;
import com.nxp.s32ds.gte.isp.IspTypeMipi;
import com.nxp.s32ds.gte.isp.IspTypePortIn;
import com.nxp.s32ds.gte.isp.IspTypeViu;
import com.nxp.s32ds.gte.isp.IspViuEngine;
import com.nxp.s32ds.gte.isp.NameElement;
import com.nxp.s32ds.gte.isp.design.LimitedIspDataType;
import com.nxp.s32ds.gte.isp.hardware.IspHardwareModel;
import com.nxp.s32ds.gte.isp.internal.design.service.Messages;
import com.nxp.s32ds.gte.isp.provider.IspEditPlugin;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernel;
import com.nxp.s32ds.mdt.icf.kernels.IcfKernelRegistry;
import com.nxp.s32ds.mdt.vpt.isp.core.cameras.IspCameras;
import com.nxp.s32ds.mdt.vpt.isp.core.kernels.IspKernelRegistryManager;
import com.nxp.s32ds.mdt.vpt.isp.core.kernels.IspKernels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class IspPropertiesService {
    private static final String UNDEFINED = Messages.IspPropertiesService_undefined;

    public String getNameLabel(IspGraph graph, BasicEMap.Entry<String, Integer> value) {
        return (String)value.getKey();
    }

    public String getValueLabel(IspGraph graph, BasicEMap.Entry<String, Integer> value) {
        return String.valueOf(value.getValue());
    }

    public int getChannelIndex(IspChannel channel) {
        return channel.getBuffer().getChannels().indexOf((Object)channel);
    }

    public List<IspDataType> getIspDataTypes(IspPort port) {
        return Arrays.asList(LimitedIspDataType.TYPES);
    }

    public List<IspDataType> getIspDataTypes(IspBuffer buffer) {
        return Arrays.asList(LimitedIspDataType.TYPES);
    }

    public String getIspTypeMipiLabel(IspMipiEngine engine, IspTypeMipi candidate) {
        return candidate.name();
    }

    public List<IspTypeMipi> getIspTypeMipis(IspMipiEngine engine) {
        return IspTypeMipi.VALUES;
    }

    public String getIspTypeViuLabel(IspViuEngine engine, IspTypeViu candidate) {
        return candidate.name();
    }

    public List<IspTypeViu> getIspTypeVius(IspViuEngine engine) {
        return IspTypeViu.VALUES;
    }

    public String getIspTypeIpuLabel(IspIpuEngine engine, IspTypeIpu candidate) {
        return candidate.name();
    }

    public List<IspTypeIpu> getIspTypeIpus(IspIpuEngine engine) {
        return IspTypeIpu.VALUES;
    }

    public String getIspTypeEngLabel(IspOtherEngine engine, IspTypeEng candidate) {
        return candidate.name();
    }

    public List<IspTypeEng> getIspTypeEngs(IspOtherEngine engine) {
        return IspTypeEng.VALUES;
    }

    public String getIspDataTypeLabel(IspPort port, IspDataType candidate) {
        if (candidate == IspDataType.GENERIC_8) {
            return IspEditPlugin.INSTANCE.getString("_UI_IspDataType_GENERIC_8_literal");
        }
        if (candidate == IspDataType.GENERIC_16) {
            return IspEditPlugin.INSTANCE.getString("_UI_IspDataType_GENERIC_16_literal");
        }
        return String.valueOf(candidate);
    }

    public String getIspDataTypeLabel(IspBuffer buffer, IspDataType candidate) {
        if (candidate == IspDataType.GENERIC_8) {
            return IspEditPlugin.INSTANCE.getString("_UI_IspDataType_GENERIC_8_literal");
        }
        if (candidate == IspDataType.GENERIC_16) {
            return IspEditPlugin.INSTANCE.getString("_UI_IspDataType_GENERIC_16_literal");
        }
        return String.valueOf(candidate);
    }

    public List<IspTypePortIn> getInputPortTypes(IspPortIn port) {
        IspEngine engine = port.getContainingNode();
        return new ArrayList<IspTypePortIn>(IspHardwareModel.getInputPortTypes((IspEngine)engine));
    }

    public String getIspPortTypeLabel(IspPortIn port, IspTypePortIn candidate) {
        return candidate.getName();
    }

    public List<String> getCameras(IspEngine engine) {
        return IspCameras.getCameras((EClass)engine.eClass());
    }

    public String getCameraLabel(IspEngine engine, String candidate) {
        return candidate;
    }

    public boolean isSramBuffer(IspBuffer buffer) {
        return !(buffer instanceof IspDdrBuffer);
    }

    public List<NameElement> getHeartBeatSources(IspGraph graph) {
        ArrayList<NameElement> list = new ArrayList<NameElement>();
        list.addAll((Collection<NameElement>)graph.getFdmas());
        list.addAll(graph.getEngines().stream().filter(e -> IspPropertiesService.isHeartBeatSource(e)).collect(Collectors.toList()));
        NameElement heartBeatSource = graph.getHeartBeatSource();
        if (heartBeatSource != null) {
            list.add(null);
        }
        return list;
    }

    private static boolean isHeartBeatSource(IspEngine e) {
        switch (e.eClass().getClassifierID()) {
            case 7: 
            case 8: {
                return true;
            }
            case 6: {
                switch (((IspOtherEngine)e).getEngineType()) {
                    case H264DEC: 
                    case JPEGDEC: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public String getHeartBeatSourceLabel(IspGraph graph, Object element) {
        if (element instanceof NameElement) {
            return ((NameElement)element).getName();
        }
        return UNDEFINED;
    }

    public NameElement getHeartBeatSource(IspGraph graph, Object element) {
        if (element instanceof NameElement) {
            return (NameElement)element;
        }
        return null;
    }

    public List<String> getKernels(EObject param) {
        IspGraph graph = (IspGraph)EObjects.eContainer((EObject)param, IspGraph.class);
        if (graph == null) {
            return Collections.emptyList();
        }
        if (param instanceof IspIpuEngine) {
            IcfKernelRegistry kernelRegistry = IspKernelRegistryManager.getInstance().getKernelRegistry((EObject)graph);
            List<String> collect = kernelRegistry.getKernels(IspKernels.getType((IspIpuEngine)((IspIpuEngine)param))).stream().map(IcfKernel::getName).collect(Collectors.toList());
            collect.sort((s0, s1) -> s0.toLowerCase().compareTo(s1.toLowerCase()));
            return collect;
        }
        return Collections.emptyList();
    }

    public List<Integer> getBufferProducerIndexes(IspBuffer ispBuffer) {
        return IntStream.range(0, IspHardwareModel.getBufferProducers((IspBuffer)ispBuffer).size()).boxed().collect(Collectors.toList());
    }

    public String getBufferProducerLabel(IspBuffer ispBuffer, Integer index) {
        List producers = IspHardwareModel.getBufferProducers((IspBuffer)ispBuffer);
        if (index >= producers.size()) {
            return String.valueOf(index);
        }
        EObject eObject = (EObject)producers.get(index);
        if (eObject instanceof IspFdmaTransfer) {
            return ((IspFdmaTransfer)eObject).getName();
        }
        IspPortOut portOut = (IspPortOut)eObject;
        IspEngine engine = portOut.getContainingNode();
        return NLS.bind((String)Messages.IspPropertiesService_0_out_1, (Object)engine.getName(), (Object)portOut.getIndex());
    }

    public List<Integer> getPortInIndexes(IspPortIn portIn) {
        IspEngine engine = portIn.getContainingNode();
        if (engine instanceof IspIpuEngine) {
            Set portVariants = IspHardwareModel.getIpuInputPortVariants((IspIpuEngine)((IspIpuEngine)engine));
            if (portVariants.isEmpty()) {
                return Collections.emptyList();
            }
            return portVariants.stream().filter(v -> v.getType() == portIn.getPortType()).map(v -> v.getIndex()).collect(Collectors.toList());
        }
        int inPortsNumber = IspHardwareModel.getPortInNumber((IspEngine)engine);
        if (inPortsNumber <= 0) {
            return Collections.emptyList();
        }
        return IntStream.range(0, inPortsNumber).boxed().collect(Collectors.toList());
    }

    public String getPortInIndexeLabel(IspPortIn portIn, Integer candidate) {
        IspEngine engine = portIn.getContainingNode();
        if (engine instanceof IspOtherEngine) {
            List names = IspHardwareModel.getPortInNames((IspTypeEng)((IspOtherEngine)engine).getEngineType());
            if (candidate < names.size()) {
                return (String)names.get(candidate);
            }
        }
        return String.valueOf(candidate);
    }

    public List<Integer> getPortOutIndexes(IspPortOut portOut) {
        IspEngine engine = portOut.getContainingNode();
        int outPortsNumber = IspHardwareModel.getPortOutNumber((IspEngine)engine);
        if (outPortsNumber <= 0) {
            return Collections.emptyList();
        }
        return IntStream.range(0, outPortsNumber).boxed().collect(Collectors.toList());
    }

    public String getPortOutIndexeLabel(IspPortOut portOut, Integer candidate) {
        IspEngine engine = portOut.getContainingNode();
        if (engine instanceof IspOtherEngine) {
            List names = IspHardwareModel.getPortOutNames((IspTypeEng)((IspOtherEngine)engine).getEngineType());
            if (candidate < names.size()) {
                return (String)names.get(candidate);
            }
        }
        return String.valueOf(candidate);
    }

    public List<Integer> getIpuEngineIndexes(IspIpuEngine engine) {
        int enginesNumber = IspHardwareModel.getIpuEnginesNumber((IspTypeIpu)engine.getEngineType());
        return IntStream.range(0, enginesNumber).boxed().collect(Collectors.toList());
    }

    public void update(IspGraph graph) {
        String name = graph.getName();
        graph.setName(name.concat("_temp"));
        graph.setName(name);
    }
}

