/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.isp.internal.design.service;

import com.nxp.s32ds.ext.emf.common.util.DiagnosticAttachment;
import com.nxp.s32ds.gte.isp.IspBuffer;
import com.nxp.s32ds.gte.isp.IspChannel;
import com.nxp.s32ds.gte.isp.IspDdrBuffer;
import com.nxp.s32ds.gte.isp.IspEngine;
import com.nxp.s32ds.gte.isp.IspFactory;
import com.nxp.s32ds.gte.isp.IspFdmaTransfer;
import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.gte.isp.IspIpuEngine;
import com.nxp.s32ds.gte.isp.IspMipiEngine;
import com.nxp.s32ds.gte.isp.IspOtherEngine;
import com.nxp.s32ds.gte.isp.IspPackage;
import com.nxp.s32ds.gte.isp.IspPortIn;
import com.nxp.s32ds.gte.isp.IspPortOut;
import com.nxp.s32ds.gte.isp.IspTypeEng;
import com.nxp.s32ds.gte.isp.IspTypeIpu;
import com.nxp.s32ds.gte.isp.IspTypeMipi;
import com.nxp.s32ds.gte.isp.IspTypeViu;
import com.nxp.s32ds.gte.isp.IspViuEngine;
import com.nxp.s32ds.gte.isp.NameElement;
import com.nxp.s32ds.gte.isp.hardware.IspHardwareModel;
import com.nxp.s32ds.gte.isp.internal.design.service.IspDesignDefaultNameProvider;
import com.nxp.s32ds.gte.isp.internal.design.service.IspDesignItemLabelProvider;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.EdgeTarget;

public class IspProgramService {
    private static final int DEFAULT_264DEC_OUTPUTS_COUNT = 12;
    private static final int DEFAULT_VIU_OUTPUTS_COUNT = 1;
    private static final int DEFAULT_MIPI_OUTPUTS_COUNT = 1;
    private static final int DEFAULT_264ENC_INPUTS_COUNT = 3;
    private static final int DEFAULT_264ENC_OUTPUTS_COUNT = 1;
    private static final int DEFAULT_JPEG_DEC_OUTPUTS_COUNT = 1;
    private static final int DEFAULT_IPUS_INPUTS_COUNT = 1;
    private static final int DEFAULT_IPUS_OUTPUTS_COUNT = 1;
    private static final int DEFAULT_IPUV_INPUTS_COUNT = 1;
    private static final int DEFAULT_IPUV_OUTPUTS_COUNT = 1;
    private static final int DEFAULT_BUFFER_CHANNELS_COUNT = 1;
    private static final IItemLabelProvider LABEL_PROVIDER = new IspDesignItemLabelProvider();
    private static final IItemLabelProvider DEFAULT_NAME_PROVIDER = new IspDesignDefaultNameProvider();

    public String getLabelObject(EObject eObject) {
        return LABEL_PROVIDER.getText((Object)eObject);
    }

    public int getNewEngineIndex(EObject obj) {
        if (!(obj.eContainer() instanceof IspGraph)) {
            return 0;
        }
        IspGraph graph = (IspGraph)obj.eContainer();
        int classifierID = obj.eClass().getClassifierID();
        switch (classifierID) {
            case 9: {
                List engines = IspProgramService.filter(obj, (EList<? extends EObject>)graph.getEngines());
                IspIpuEngine ispIpuEngine = (IspIpuEngine)obj;
                engines = engines.stream().filter(e -> ispIpuEngine.getEngineType() == e.getEngineType()).collect(Collectors.toList());
                if (IspTypeIpu.SCALAR.equals((Object)ispIpuEngine.getEngineType())) {
                    return IspProgramService.calculateNewNumber(obj, engines, IspEngine::getEngineIndex, 7);
                }
                return IspProgramService.calculateNewNumber(obj, engines, IspEngine::getEngineIndex, 3);
            }
        }
        return 0;
    }

    public Object getEngineType(EObject obj) {
        if (!(obj.eContainer() instanceof IspGraph)) {
            return 0;
        }
        IspGraph graph = (IspGraph)obj.eContainer();
        int classifierID = obj.eClass().getClassifierID();
        switch (classifierID) {
            case 7: {
                List engines = IspProgramService.filter(obj, (EList<? extends EObject>)graph.getEngines());
                Set set = engines.stream().map(IspMipiEngine::getEngineType).collect(Collectors.toSet());
                for (IspTypeMipi ispTypeMipi : IspTypeMipi.VALUES) {
                    if (set.contains(ispTypeMipi)) continue;
                    return ispTypeMipi;
                }
                return IspTypeMipi.MIPICSI0;
            }
            case 8: {
                List engines = IspProgramService.filter(obj, (EList<? extends EObject>)graph.getEngines());
                Set set = engines.stream().map(IspViuEngine::getEngineType).collect(Collectors.toSet());
                for (IspTypeViu ispTypeViu : IspTypeViu.VALUES) {
                    if (set.contains(ispTypeViu)) continue;
                    return ispTypeViu;
                }
                return IspTypeViu.VIU0;
            }
        }
        return null;
    }

    private static <T extends EObject> List<T> filter(EObject eObject, EList<? extends EObject> list) {
        return IspProgramService.filter(eObject.eClass(), eObject, list);
    }

    private static <T extends EObject> List<T> filter(EClass eClass, EList<? extends EObject> list) {
        return IspProgramService.filter(eClass, null, list);
    }

    private static <T extends EObject> List<T> filter(EClass eClass, EObject eObject, EList<? extends EObject> list) {
        return list.stream().filter(e -> e != eObject && eClass.isInstance(e)).collect(Collectors.toList());
    }

    public String getName(EObject object) {
        String name = DEFAULT_NAME_PROVIDER.getText((Object)object);
        EObject eContainer = object.eContainer();
        if (!(eContainer instanceof IspGraph)) {
            return name;
        }
        IspGraph graph = (IspGraph)eContainer;
        int classifierID = object.eClass().getClassifierID();
        switch (classifierID) {
            case 10: 
            case 11: {
                return IspProgramService.createNewName(name, (List<? extends NameElement>)graph.getBuffers());
            }
            case 13: {
                return IspProgramService.createNewName(name, (List<? extends NameElement>)graph.getFdmas());
            }
            case 7: 
            case 8: 
            case 9: {
                return IspProgramService.createNewName(name, (List<? extends NameElement>)graph.getEngines());
            }
        }
        return name;
    }

    private static String createNewName(String nameTemplate, List<? extends NameElement> elements) {
        Set names = elements.stream().map(NameElement::getName).collect(Collectors.toSet());
        int i = 0;
        while (i < Integer.MAX_VALUE) {
            String name = NLS.bind((String)nameTemplate, (Object)i);
            if (!names.contains(name)) {
                return name;
            }
            ++i;
        }
        return NLS.bind((String)nameTemplate, (Object)0);
    }

    public boolean canStartConnection(EObject eObject, EObject source) {
        if (source instanceof IspChannel) {
            IspChannel ispChannel = (IspChannel)source;
            return ispChannel.getBufferToNode() == null && ispChannel.getFdma() == null;
        }
        return true;
    }

    public boolean canFinishConnection(EObject eObject, EObject source, EObject target) {
        if (source instanceof IspPortOut) {
            return target instanceof IspBuffer && !(target instanceof IspDdrBuffer);
        }
        if (source instanceof IspChannel && target instanceof IspFdmaTransfer) {
            IspFdmaTransfer fdmaTransfer = (IspFdmaTransfer)target;
            return fdmaTransfer.getSource().size() == 0;
        }
        if (source instanceof IspFdmaTransfer && target instanceof IspBuffer) {
            IspFdmaTransfer fdmaTransfer = (IspFdmaTransfer)source;
            return fdmaTransfer.getTarget().size() == 0;
        }
        if (source instanceof IspChannel && target instanceof IspPortIn) {
            IspChannel ispChannel = (IspChannel)source;
            IspBuffer buffer = ispChannel.getBuffer();
            return !(buffer instanceof IspDdrBuffer);
        }
        return true;
    }

    public boolean canReconnect(EObject eObject, EObject oldSource, EObject newSource) {
        return this.canFinishConnection(eObject, eObject, newSource);
    }

    public EList<IspPortOut> getViuOutputPorts(EObject obj) {
        return IspProgramService.createOutputPorts(1);
    }

    public EList<IspPortOut> getMipiOutputPorts(EObject obj) {
        return IspProgramService.createOutputPorts(1);
    }

    public EList<IspPortOut> get264DecOutputPorts(EObject obj) {
        return IspProgramService.createOutputPorts(12);
    }

    public EList<IspPortIn> get264EncInputPorts(EObject obj) {
        return IspProgramService.createInputPorts(3);
    }

    public EList<IspPortOut> get264EncOutputPorts(EObject obj) {
        return IspProgramService.createOutputPorts(1);
    }

    public EList<IspPortOut> getJpegDecOutputPorts(EObject obj) {
        return IspProgramService.createOutputPorts(1);
    }

    public EList<IspPortIn> getIpusInputPorts(EObject obj) {
        return IspProgramService.createInputPorts(1);
    }

    public EList<IspPortOut> getIpusOutputPorts(EObject obj) {
        return IspProgramService.createOutputPorts(1);
    }

    public EList<IspPortIn> getIpuvInputPorts(EObject obj) {
        return IspProgramService.createInputPorts(1);
    }

    public EList<IspPortOut> getIpuvOutputPorts(EObject obj) {
        return IspProgramService.createOutputPorts(1);
    }

    public EList<IspChannel> getChannels(EObject obj) {
        BasicEList channels = new BasicEList();
        int i = 0;
        while (i < 1) {
            IspChannel p = IspFactory.eINSTANCE.createIspChannel();
            channels.add((Object)p);
            ++i;
        }
        return channels;
    }

    private static EList<IspPortOut> createOutputPorts(int count) {
        BasicEList ports = new BasicEList();
        int i = 0;
        while (i < count) {
            IspPortOut p = IspFactory.eINSTANCE.createIspPortOut();
            p.setIndex(i);
            ports.add((Object)p);
            ++i;
        }
        return ports;
    }

    private static EList<IspPortIn> createInputPorts(int count) {
        BasicEList ports = new BasicEList();
        int i = 0;
        while (i < count) {
            IspPortIn p = IspFactory.eINSTANCE.createIspPortIn();
            p.setIndex(i);
            ports.add((Object)p);
            ++i;
        }
        return ports;
    }

    public int getNewPortInIndex(EObject obj) {
        IspPortIn port;
        IspEngine engine;
        if (obj instanceof IspPortIn && (engine = (port = (IspPortIn)obj).getContainingNode()) != null) {
            return IspProgramService.calculateNewNumber(port, engine.getPortIn(), IspPortIn::getIndex);
        }
        return 0;
    }

    public int getNewPortOutIndex(EObject obj) {
        IspPortOut port;
        if (obj instanceof IspPortOut && (port = (IspPortOut)obj).eContainer() instanceof IspEngine) {
            IspEngine engine = (IspEngine)port.eContainer();
            return IspProgramService.calculateNewNumber(port, engine.getPortOut(), IspPortOut::getIndex);
        }
        return 0;
    }

    public int getNewChanelNumber(EObject obj) {
        IspChannel channel;
        IspBuffer buffer;
        if (obj instanceof IspChannel && (buffer = (channel = (IspChannel)obj).getBuffer()) != null) {
            return IspProgramService.calculateNewNumber(channel, buffer.getChannels(), IspChannel::getNumber);
        }
        return 0;
    }

    private static <T> int calculateNewNumber(Object object, List<T> list, Function<? super T, Integer> mapper) {
        return IspProgramService.calculateNewNumber(object, list, mapper, Integer.MAX_VALUE);
    }

    private static <T> int calculateNewNumber(Object object, List<T> list, Function<? super T, Integer> mapper, int limit) {
        Set set = list.stream().filter(p -> p != object).map(mapper).collect(Collectors.toSet());
        int i = 0;
        while (i < limit) {
            if (!set.contains(i)) {
                return i;
            }
            ++i;
        }
        return limit;
    }

    public boolean canCreateH264Enc(IspGraph graph) {
        return !IspProgramService.isOtherEngineTypeExist(graph, IspTypeEng.H264ENC);
    }

    public boolean canCreateH264Dec(IspGraph graph) {
        return !IspProgramService.isOtherEngineTypeExist(graph, IspTypeEng.H264DEC);
    }

    public boolean canCreateJpegDec(IspGraph graph) {
        return !IspProgramService.isOtherEngineTypeExist(graph, IspTypeEng.JPEGDEC);
    }

    private static boolean isOtherEngineTypeExist(IspGraph graph, IspTypeEng type) {
        return graph.getEngines().stream().anyMatch(e -> e instanceof IspOtherEngine && ((IspOtherEngine)e).getEngineType() == type);
    }

    public boolean canCreateViu(IspGraph graph) {
        return IspProgramService.canCreateEngine(graph, IspPackage.Literals.ISP_VIU_ENGINE);
    }

    public boolean canCreateMipi(IspGraph graph) {
        return IspProgramService.canCreateEngine(graph, IspPackage.Literals.ISP_MIPI_ENGINE);
    }

    private static boolean canCreateEngine(IspGraph graph, EClass eClass) {
        return IspProgramService.filter(eClass, (EList<? extends EObject>)graph.getEngines()).size() < IspHardwareModel.getEnginesNumber((int)eClass.getClassifierID());
    }

    public boolean canCreateFdma(IspGraph graph) {
        return graph.getFdmas().size() < 16;
    }

    public boolean canCreateChannel(IspBuffer buffer) {
        return buffer.getChannels().size() < 8;
    }

    public EObject findDdrBuffer(EObject obj) {
        if (obj instanceof IspDdrBuffer) {
            return obj;
        }
        return null;
    }

    public boolean canCreatePortIn(IspEngine engine) {
        return engine.getPortIn().size() < IspHardwareModel.getPortInNumber((IspEngine)engine);
    }

    public boolean canCreatePortOut(IspEngine engine) {
        return engine.getPortOut().size() < IspHardwareModel.getPortOutNumber((IspEngine)engine);
    }

    public boolean findElementMIPIEngine(EObject object) {
        return object instanceof IspMipiEngine;
    }

    public EObject getSourceExpression(EObject object) {
        return object;
    }

    public EObject getTargetExpression(EObject object) {
        return object;
    }

    public EObject getSemanticCandidatExp(EObject object) {
        return null;
    }

    public EObject deleteEdgeChannelForPort(EObject object) {
        IspChannel channel = IspProgramService.getEdgeSourceNode(object, IspChannel.class);
        IspPortIn portIn = IspProgramService.getEdgeTargetNode(object, IspPortIn.class);
        if (channel != null && portIn != null) {
            channel.setBufferToNode(null);
        }
        return null;
    }

    public EObject pasteIsp(EObject context, EObject copiedElement, EObject container) {
        if (copiedElement instanceof IspFdmaTransfer && container instanceof IspGraph) {
            IspFdmaTransfer ispFdmaTransfer = (IspFdmaTransfer)copiedElement;
            IspGraph ispGraph = (IspGraph)container;
            ispGraph.getFdmas().add((Object)ispFdmaTransfer);
            return ispGraph;
        }
        if (copiedElement instanceof IspBuffer && container instanceof IspGraph) {
            IspBuffer ispBuffer = (IspBuffer)copiedElement;
            IspGraph ispGraph = (IspGraph)container;
            ispGraph.getBuffers().add((Object)ispBuffer);
            return ispGraph;
        }
        if (copiedElement instanceof IspEngine && container instanceof IspGraph) {
            IspEngine ispEngine = (IspEngine)copiedElement;
            IspGraph ispGraph = (IspGraph)container;
            ispGraph.getEngines().add((Object)ispEngine);
            return ispGraph;
        }
        return null;
    }

    public EObject deleteFdmaForChannel(EObject object) {
        if (object instanceof IspChannel) {
            IspChannel channel = (IspChannel)object;
            channel.getFdma().getSource().remove((Object)channel);
            channel.setFdma(null);
        }
        return null;
    }

    public EObject deleteBufferfoFdma(EObject object) {
        IspFdmaTransfer fdma = IspProgramService.getEdgeSourceNode(object, IspFdmaTransfer.class);
        IspBuffer buffer = IspProgramService.getEdgeTargetNode(object, IspBuffer.class);
        if (fdma != null && buffer != null) {
            fdma.getTarget().remove((Object)buffer);
        }
        return null;
    }

    private static <T> T getEdgeSourceNode(EObject object, Class<T> clazz) {
        if (!(object instanceof DEdge)) {
            return null;
        }
        DEdge dEdge = (DEdge)object;
        EdgeTarget targetNode = dEdge.getSourceNode();
        if (!(targetNode instanceof DNode)) {
            return null;
        }
        EObject targetNodeTarget = ((DNode)targetNode).getTarget();
        if (!clazz.isInstance(targetNodeTarget)) {
            return null;
        }
        return clazz.cast(targetNodeTarget);
    }

    private static <T> T getEdgeTargetNode(EObject object, Class<T> clazz) {
        if (!(object instanceof DEdge)) {
            return null;
        }
        DEdge dEdge = (DEdge)object;
        EdgeTarget targetNode = dEdge.getTargetNode();
        if (!(targetNode instanceof DNode)) {
            return null;
        }
        EObject targetNodeTarget = ((DNode)targetNode).getTarget();
        if (!clazz.isInstance(targetNodeTarget)) {
            return null;
        }
        return clazz.cast(targetNodeTarget);
    }

    public Boolean hasError(EObject eObj) {
        if (eObj instanceof IspBuffer || eObj instanceof IspIpuEngine || eObj instanceof IspMipiEngine || eObj instanceof IspViuEngine || eObj instanceof IspOtherEngine || eObj instanceof IspPortOut || eObj instanceof IspPortIn || eObj instanceof IspFdmaTransfer || eObj instanceof IspChannel) {
            Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObj);
            DiagnosticAttachment.attach((EObject)eObj, (Diagnostic)diagnostic);
            if (diagnostic.getSeverity() == 4) {
                return true;
            }
            return false;
        }
        return false;
    }

    public Boolean isIpuvEngine(EObject eObj) {
        if (eObj instanceof IspIpuEngine) {
            if (((IspIpuEngine)eObj).getEngineType() == IspTypeIpu.VECTOR) {
                return true;
            }
            return false;
        }
        return false;
    }

    public Boolean isIpusEngine(EObject eObj) {
        if (eObj instanceof IspIpuEngine) {
            if (((IspIpuEngine)eObj).getEngineType() == IspTypeIpu.SCALAR) {
                return true;
            }
            return false;
        }
        return false;
    }

    public Boolean isViuEngine(EObject eObj) {
        return eObj instanceof IspViuEngine;
    }

    public Boolean isMipiEngine(EObject eObj) {
        return eObj instanceof IspMipiEngine;
    }

    public Boolean isH264EncEngine(EObject eObj) {
        if (eObj instanceof IspOtherEngine) {
            if (((IspOtherEngine)eObj).getEngineType() == IspTypeEng.H264ENC) {
                return true;
            }
            return false;
        }
        return false;
    }

    public Boolean isH264DecEngine(EObject eObj) {
        if (eObj instanceof IspOtherEngine) {
            if (((IspOtherEngine)eObj).getEngineType() == IspTypeEng.H264DEC) {
                return true;
            }
            return false;
        }
        return false;
    }

    public Boolean isJpegDecEngine(EObject eObj) {
        if (eObj instanceof IspOtherEngine) {
            if (((IspOtherEngine)eObj).getEngineType() == IspTypeEng.JPEGDEC) {
                return true;
            }
            return false;
        }
        return false;
    }

    public Boolean isSramBuffer(EObject eObj) {
        if (eObj instanceof IspBuffer && !(eObj instanceof IspDdrBuffer)) {
            return true;
        }
        return false;
    }

    public Boolean isDdrBuffer(EObject eObj) {
        return eObj instanceof IspDdrBuffer;
    }

    public Boolean isFdma(EObject eObj) {
        return eObj instanceof IspFdmaTransfer;
    }

    public Boolean isChannel(EObject eObj) {
        return eObj instanceof IspChannel;
    }

    public Boolean isPortIn(EObject eObj) {
        return eObj instanceof IspPortIn;
    }

    public Boolean isPortOut(EObject eObj) {
        return eObj instanceof IspPortOut;
    }
}

