/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.isp.internal.design.service;

import com.nxp.s32ds.ext.emf.ecore.EObjects;
import com.nxp.s32ds.ext.orbit.c.defines.CDefine;
import com.nxp.s32ds.ext.rcp.jface.KeyValueValidator;
import com.nxp.s32ds.ext.rcp.jface.ValueValidator;
import com.nxp.s32ds.ext.rcp.variables.RcpVariable;
import com.nxp.s32ds.ext.rcp.variables.RcpWorkspaceLocVariable;
import com.nxp.s32ds.gte.isp.Import;
import com.nxp.s32ds.gte.isp.IspFactory;
import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.gte.isp.impl.IspFactoryImpl;
import com.nxp.s32ds.gte.isp.impl.MapDataImpl;
import com.nxp.s32ds.gte.isp.internal.design.IspDesignActivator;
import com.nxp.s32ds.gte.isp.internal.design.Messages;
import com.nxp.s32ds.mdt.icf.kernels.ui.IcfKernelRootSelectionDialog;
import com.nxp.s32ds.mdt.ide.c.ui.CDefineEditorDialog;
import com.nxp.s32ds.mdt.ide.c.ui.CDefineEditorDialogAddValidator;
import com.nxp.s32ds.mdt.ide.c.ui.CDefineEditorDialogEditValidator;
import com.nxp.s32ds.mdt.ide.c.ui.CDefineSelectionDialog;
import com.nxp.s32ds.mdt.ide.c.ui.CIncludeSelectionDialog;
import com.nxp.s32ds.mdt.ide.c.ui.CIncludeSelectionDialogValidator;
import com.nxp.s32ds.mdt.ide.core.MdtIdeCore;
import com.nxp.s32ds.mdt.vpt.isp.core.defines.IspDefineRegistryManager;
import com.nxp.s32ds.mdt.vpt.isp.core.vsdk.IspVsdkHelper;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class IspDialogService {
    private static <R> R showDialog(ShowDialogFunction<Shell, R> s) {
        Display defaultDisplay = Display.getDefault();
        ArrayList result = new ArrayList();
        defaultDisplay.syncExec(() -> {
            try {
                Object r = s.apply(defaultDisplay.getActiveShell());
                if (r != null) {
                    result.add(r);
                }
            }
            catch (CoreException e) {
                ErrorDialog.openError((Shell)defaultDisplay.getActiveShell(), (String)Messages.IspDialogService_error, null, (IStatus)e.getStatus());
            }
        });
        if (result.size() == 0) {
            return null;
        }
        return (R)result.get(0);
    }

    public static String selectDefine(EObject object) {
        return IspDialogService.showDialog(shell -> {
            IspGraph graph = (IspGraph)EObjects.eContainer((EObject)object, IspGraph.class);
            CDefineSelectionDialog dialog = new CDefineSelectionDialog(shell, (EObject)graph, IspDefineRegistryManager.getInstance());
            CDefine result = dialog.getDefine();
            if (result == null) {
                return null;
            }
            return result.getName();
        });
    }

    public Import addHeader(IspGraph graph) {
        Import imp = IspFactory.eINSTANCE.createImport();
        return IspDialogService.processImport(graph, imp);
    }

    public void editHeader(IspGraph graph, Object current) {
        if (!(current instanceof Import)) {
            return;
        }
        Import imp = (Import)current;
        IspDialogService.processImport(graph, imp);
    }

    private static Import processImport(IspGraph graph, Import imp) {
        return IspDialogService.showDialog(shell -> {
            RcpVariable vsdkVariable;
            CIncludeSelectionDialogValidator validator = new CIncludeSelectionDialogValidator((EObject)graph, IspDefineRegistryManager.getInstance());
            CIncludeSelectionDialog dialog = new CIncludeSelectionDialog(shell, (ValueValidator)validator, vsdkVariable = IspVsdkHelper.getInstance().getVsdkVariable(), imp.getPath());
            String result = dialog.getFile();
            if (result == null) {
                return null;
            }
            imp.setPath(result);
            imp.setFileName(result.substring(result.lastIndexOf(47) + 1));
            return imp;
        });
    }

    public Map.Entry<String, String> addDefine(IspGraph graph) {
        return (Map.Entry)IspDialogService.showDialog(shell -> {
            CDefineEditorDialogAddValidator validator = new CDefineEditorDialogAddValidator((EObject)graph, IspDefineRegistryManager.getInstance());
            CDefineEditorDialog dialog = new CDefineEditorDialog(shell, CDefineEditorDialog.ADD_DEFINE_TITLE, (KeyValueValidator)validator);
            CDefine result = dialog.getDefine();
            if (result == null) {
                return null;
            }
            MapDataImpl mapData = (MapDataImpl)((IspFactoryImpl)IspFactory.eINSTANCE).createMapData();
            mapData.setKey(result.getName());
            mapData.setValue(result.getValue());
            return mapData;
        });
    }

    public void editDefine(IspGraph graph, MapDataImpl current) {
        IspDialogService.showDialog(shell -> {
            CDefineEditorDialogEditValidator validator = new CDefineEditorDialogEditValidator((EObject)graph, IspDefineRegistryManager.getInstance(), current.getKey());
            CDefineEditorDialog dialog = new CDefineEditorDialog(shell, CDefineEditorDialog.EDIT_DEFINE_TITLE, (KeyValueValidator)validator);
            dialog.setName(current.getKey());
            dialog.setValue(current.getValue());
            CDefine result = dialog.getDefine();
            if (result == null) {
                return null;
            }
            current.setKey(result.getName());
            current.setValue(result.getValue());
            return current;
        });
    }

    public String selectKernelRoot(EObject param) {
        return IspDialogService.showDialog(shell -> {
            String defaultKernelRoot = null;
            IspGraph graph = (IspGraph)param;
            defaultKernelRoot = graph.getKernelsRootDirectory();
            IFile workspaceFile = MdtIdeCore.toWorkspaceFile((EObject)param);
            if (workspaceFile == null) {
                ErrorDialog.openError((Shell)shell, (String)Messages.IspDialogService_error, null, (IStatus)IspDesignActivator.getInstance().createError(Messages.IspDialogService_cannot_resolve_project_for_graph));
                return null;
            }
            RcpVariable vsdkVariable = IspVsdkHelper.getInstance().getVsdkVariable();
            IcfKernelRootSelectionDialog dialog = new IcfKernelRootSelectionDialog(shell, null, vsdkVariable, (RcpVariable)new RcpWorkspaceLocVariable(workspaceFile.getProject().getName()), defaultKernelRoot);
            return dialog.getDirectory();
        });
    }

    @FunctionalInterface
    public static interface ShowDialogFunction<T, R> {
        public R apply(T var1) throws CoreException;
    }
}

