/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.isp.internal.design.service;

import com.nxp.s32ds.gte.isp.IspBuffer;
import com.nxp.s32ds.gte.isp.IspChannel;
import com.nxp.s32ds.gte.isp.IspDdrBuffer;
import com.nxp.s32ds.gte.isp.IspFdmaTransfer;
import com.nxp.s32ds.gte.isp.IspIpuEngine;
import com.nxp.s32ds.gte.isp.IspMipiEngine;
import com.nxp.s32ds.gte.isp.IspOtherEngine;
import com.nxp.s32ds.gte.isp.IspPortIn;
import com.nxp.s32ds.gte.isp.IspPortOut;
import com.nxp.s32ds.gte.isp.IspViuEngine;
import com.nxp.s32ds.gte.isp.NameElement;
import com.nxp.s32ds.gte.isp.hardware.IspHardwareModel;
import com.nxp.s32ds.gte.isp.util.IspSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;

public class IspDesignItemLabelProvider
extends IspSwitch<String>
implements IItemLabelProvider {
    private static final String UNDEFINED = "UNDEFINED";
    private static final String EMPTY_STRING = "";

    public String getText(Object object) {
        if (object instanceof EObject) {
            return (String)this.doSwitch((EObject)object);
        }
        return EMPTY_STRING;
    }

    public Object getImage(Object object) {
        throw new RuntimeException("Don't use getImage() method!");
    }

    public String defaultCase(EObject object) {
        return EMPTY_STRING;
    }

    public String caseNameElement(NameElement object) {
        return object.getName();
    }

    public String caseIspFdmaTransfer(IspFdmaTransfer transfer) {
        return String.format("FDMA\n%s", transfer.getName());
    }

    public String caseIspPortIn(IspPortIn port) {
        return IspHardwareModel.getPortLabel((IspPortIn)port);
    }

    public String caseIspPortOut(IspPortOut port) {
        return IspHardwareModel.getPortLabel((IspPortOut)port);
    }

    public String caseIspDdrBuffer(IspDdrBuffer ddrBuffer) {
        return String.format("DDR\n%s\n(%s)", ddrBuffer.getName(), ddrBuffer.getDataType());
    }

    public String caseIspBuffer(IspBuffer buffer) {
        return String.format("SRAM\n%s\n(%s)", buffer.getName(), buffer.getDataType());
    }

    public String caseIspChannel(IspChannel channel) {
        return String.format("[%d]", channel.getBuffer().getChannels().indexOf((Object)channel));
    }

    public String caseIspIpuEngine(IspIpuEngine engine) {
        String type = engine.getEngineType().getLiteral();
        String kernel = engine.getKernel();
        if (kernel == null) {
            kernel = UNDEFINED;
        }
        return String.format("IPU%s%d\n%s\n(%s)", type.substring(0, 1), engine.getEngineIndex(), engine.getName(), kernel);
    }

    public String caseIspMipiEngine(IspMipiEngine engine) {
        String engineType = engine.getEngineType().getLiteral();
        String cameraType = engine.getCameraType();
        if (cameraType == null) {
            cameraType = UNDEFINED;
        }
        return String.format("%s\n%s\n(%s)", engineType, engine.getName(), cameraType);
    }

    public String caseIspViuEngine(IspViuEngine engine) {
        String engineType = engine.getEngineType().getLiteral();
        String cameraType = engine.getCameraType();
        if (cameraType == null) {
            cameraType = UNDEFINED;
        }
        return String.format("%s\n%s\n(%s)", engineType, engine.getName(), cameraType);
    }

    public String caseIspOtherEngine(IspOtherEngine engine) {
        String name = EMPTY_STRING;
        switch (engine.getEngineType()) {
            case H264ENC: 
            case H264DEC: 
            case JPEGDEC: {
                name = engine.getEngineType().getName();
                break;
            }
            default: {
                name = engine.getName();
            }
        }
        return String.format("%s\n%s", name, engine.getName());
    }
}

