/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.isp.internal.design;

import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import com.nxp.s32ds.ext.rcp.variables.RcpVariable;
import com.nxp.s32ds.ext.rcp.variables.RcpVariables;
import com.nxp.s32ds.gte.isp.Import;
import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.gte.isp.internal.design.IspDesignActivator;
import com.nxp.s32ds.gte.isp.internal.design.Messages;
import com.nxp.s32ds.mdt.vpt.isp.core.vsdk.IspVsdkHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.sirius.viewpoint.description.Viewpoint;

public class IspSessionManagerListener
implements SessionManagerListener {
    public void notifyAddSession(Session newSession) {
        final Collection graphs = newSession.getSemanticResources().stream().flatMap(res -> res.getResourceSet().getResources().stream()).flatMap(res -> res.getContents().stream()).filter(IspGraph.class::isInstance).map(o -> (IspGraph)o).collect(Collectors.toSet());
        TransactionalEditingDomain transactionalEditingDomain = newSession.getTransactionalEditingDomain();
        transactionalEditingDomain.getCommandStack().execute((Command)new RecordingCommand(transactionalEditingDomain){

            protected void doExecute() {
                IspSessionManagerListener.updateIncludesAndKernelRoot(graphs);
            }
        });
    }

    private static void updateIncludesAndKernelRoot(Collection<IspGraph> graphs) {
        HashSet<IspGraph> modifiedGraphs = new HashSet<IspGraph>();
        for (IspGraph graph : graphs) {
            boolean graphChanged = false;
            ArrayList<Import> toRemove = new ArrayList<Import>();
            EList headers = graph.getHeaders();
            for (Import header : headers) {
                String updatedPath = IspSessionManagerListener.replaceFileSeparators(header.getPath());
                if (!header.isUserDefined()) {
                    if (header.getFileName().endsWith("iofiles.h")) {
                        header.setUserDefined(true);
                        header.setPath(updatedPath);
                    } else {
                        toRemove.add(header);
                    }
                    graphChanged = true;
                    continue;
                }
                if (header.getPath().equals(updatedPath)) continue;
                header.setPath(updatedPath);
                graphChanged = true;
            }
            headers.removeAll(toRemove);
            String kernelsRootDirectory = graph.getKernelsRootDirectory();
            if (kernelsRootDirectory.indexOf("${") == -1) {
                graphChanged = true;
                try {
                    RcpVariable vsdkVariable = IspVsdkHelper.getInstance().getVsdkVariable();
                    graph.setKernelsRootDirectory(RcpVariables.INSTANCE.relativize(vsdkVariable, kernelsRootDirectory));
                }
                catch (CoreException e) {
                    IspDesignActivator.getInstance().log(e.getStatus());
                }
            }
            if (!graphChanged) continue;
            modifiedGraphs.add(graph);
        }
        if (modifiedGraphs.size() > 0) {
            try {
                IStatus confirmationStatus = (IStatus)RcpStatusHandlers.handleStatus((String)"com.nxp.s32ds.ext.emf.ecore.semantic.confirmModelConversionHandler", (IStatus)IspDesignActivator.getInstance().createWarning(Messages.IspSessionManagerListener_model_changed), modifiedGraphs.iterator().next());
                if (!confirmationStatus.isOK()) {
                    return;
                }
            }
            catch (CoreException e) {
                IspDesignActivator.getInstance().log(e.getStatus());
                return;
            }
            for (IspGraph graph : modifiedGraphs) {
                HashMap<String, String> options = new HashMap<String, String>();
                options.put("ENCODING", StandardCharsets.UTF_8.name());
                try {
                    graph.eResource().save(options);
                }
                catch (IOException e) {
                    IspDesignActivator.getInstance().logError("Cannot save graph: " + graph.eResource().getURI().toString(), e);
                }
            }
        }
    }

    private static String replaceFileSeparators(String string) {
        return string.replace('\\', '/');
    }

    public void notifyRemoveSession(Session removedSession) {
    }

    public void viewpointSelected(Viewpoint selectedSirius) {
    }

    public void viewpointDeselected(Viewpoint deselectedSirius) {
    }

    public void notify(Session updated, int notification) {
    }
}

