/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.gte.isp.design;

import com.nxp.s32ds.gte.isp.IspFactory;
import com.nxp.s32ds.gte.isp.IspGraph;
import com.nxp.s32ds.gte.isp.design.IspDesign;
import com.nxp.s32ds.gte.isp.design.IspProgramDescriptor;
import com.nxp.s32ds.gte.isp.internal.design.Messages;
import com.nxp.s32ds.mdt.ide.launch.core.MdtIdeLaunchCore;
import com.nxp.s32ds.mdt.vpt.isp.core.launch.IspLaunchConfigurationUtil;
import com.nxp.s32ds.mdt.vpt.isp.core.vsdk.IspVsdkHelper;
import com.nxp.s32ds.vgt.ide.core.VgtDescriptor;
import com.nxp.s32ds.vgt.ide.core.VgtRepresenter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.ecore.EObject;

public class IspDataFlowRepresenter
implements VgtRepresenter {
    private List<String> viewpointNames = new ArrayList<String>();

    public IspDataFlowRepresenter() {
        this.viewpointNames.add(IspDesign.ISP_DESIGN_VIEWPOINT);
    }

    public String getId() {
        return IspDesign.ISP_DESIGN_VIEWPOINT;
    }

    public IspGraph createSemanticModel(VgtDescriptor descriptor) {
        IspGraph graph = IspFactory.eINSTANCE.createIspGraph();
        graph.setKernelsRootDirectory(IspVsdkHelper.getInstance().getDefaultKernelsRoot());
        String semanticModelName = descriptor.getSemanticModelName();
        graph.setName(semanticModelName);
        return graph;
    }

    public IspProgramDescriptor createGraphDescriptor() {
        IspProgramDescriptor descriptor = new IspProgramDescriptor();
        descriptor.setStringValueInitial(IspProgramDescriptor.TARGET_FOLDER_NAME, IspProgramDescriptor.SOURCE_FOLDER_DEFAULT);
        return descriptor;
    }

    public EObject createGeneratorModel(VgtDescriptor descriptor, EObject semanticModel) {
        return null;
    }

    public ILaunchConfigurationWorkingCopy createLaunchConfiguration(VgtDescriptor descriptor, EObject semanticModel, IProgressMonitor monitor) throws CoreException {
        String targetProjectName = descriptor.getTargetProjectName();
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(targetProjectName);
        IFolder container = MdtIdeLaunchCore.createEmitConfigurationsFolder((IProject)project, (IProgressMonitor)monitor);
        String strStaticSequencer = "false";
        if (descriptor instanceof IspProgramDescriptor) {
            strStaticSequencer = ((IspProgramDescriptor)descriptor).getStaticSequencer();
        }
        boolean boolStaticSequencer = Boolean.valueOf(strStaticSequencer);
        return IspLaunchConfigurationUtil.createConfiguration((IContainer)container, (EObject)semanticModel, (boolean)boolStaticSequencer);
    }

    public String getSemanticFileName(VgtDescriptor descriptor) {
        String modelName = descriptor.getSemanticModelName();
        return String.valueOf(modelName) + '.' + "isp";
    }

    public String getGeneratorFileName(VgtDescriptor descriptor) {
        return null;
    }

    public String getRepresentationFileName(VgtDescriptor descriptor) {
        String modelName = descriptor.getSemanticModelName();
        return String.valueOf(modelName) + '.' + "aird";
    }

    public String getLabel() {
        return Messages.IspDataFlowRepresenter_isp_data_flow;
    }

    public String getDescription() {
        return Messages.IspDataFlowRepresenter_creates_new_isp_data_flow_model;
    }

    public List<String> getViewpointNames() {
        return this.viewpointNames;
    }

    public String getSemanticFileExtension() {
        return "isp";
    }

    public String getGeneratorFileExtension() {
        return null;
    }
}

