/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.icf.kernels.ui;

import com.nxp.s32ds.ext.rcp.jface.DialogWidgetsUtil;
import com.nxp.s32ds.ext.rcp.jface.FolderSelectionDialog;
import com.nxp.s32ds.ext.rcp.jface.ValueValidator;
import com.nxp.s32ds.ext.rcp.variables.RcpVariable;
import com.nxp.s32ds.ext.rcp.variables.RcpVariables;
import com.nxp.s32ds.mdt.icf.kernels.internal.ui.IcfKernelsUiActivator;
import com.nxp.s32ds.mdt.icf.kernels.internal.ui.Messages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class IcfKernelRootSelectionDialog
extends StatusDialog {
    private Text directoryField;
    private String directory;
    private Button vsdkButton;
    private Button fileSystemButton;
    private final ValueValidator<String> validator;
    private final RcpVariable vsdkVariable;
    private final RcpVariable projectVariable;
    private String defaultDirectory;

    public IcfKernelRootSelectionDialog(Shell parent, ValueValidator<String> validator, RcpVariable vsdkVariable, RcpVariable projectVariable) {
        this(parent, validator, vsdkVariable, projectVariable, null);
    }

    public IcfKernelRootSelectionDialog(Shell parent, ValueValidator<String> validator, RcpVariable vsdkVariable, RcpVariable projectVariable, String defaultDirectory) {
        super(parent);
        this.setTitle(Messages.IcfKernelRootSelectionDialog_select_kernel_root);
        this.setStatusLineAboveButtons(true);
        this.validator = validator;
        this.vsdkVariable = vsdkVariable;
        this.projectVariable = projectVariable;
        this.defaultDirectory = defaultDirectory;
    }

    @Deprecated
    public int open() {
        throw new IllegalStateException("use getDirectory method");
    }

    public String getDirectory() {
        if (super.open() != 0) {
            return null;
        }
        return this.directory;
    }

    protected Control createDialogArea(Composite parent) {
        parent = (Composite)super.createDialogArea(parent);
        Group composite = new Group(parent, 0);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        Label label = new Label((Composite)composite, 0);
        label.setText(Messages.IcfKernelRootSelectionDialog_kernel_root);
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.directoryField = new Text((Composite)composite, 2048);
        this.directoryField.setEnabled(false);
        this.directoryField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                IcfKernelRootSelectionDialog.this.validate();
            }
        });
        gridData = new GridData();
        gridData.widthHint = 600;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        this.directoryField.setLayoutData((Object)gridData);
        if (this.defaultDirectory != null) {
            this.setDirectory(this.defaultDirectory);
        }
        Composite buttonComposite = new Composite((Composite)composite, 0);
        gridData = new GridData();
        gridData.horizontalAlignment = 3;
        gridData.horizontalAlignment = 3;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalSpan = 2;
        buttonComposite.setLayoutData((Object)gridData);
        layout = new GridLayout(2, true);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        buttonComposite.setLayout((Layout)layout);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.vsdkButton = DialogWidgetsUtil.createPushButton((Composite)buttonComposite, (String)Messages.IcfKernelRootSelectionDialog_browse_vsdk, (GridData)gridData);
        this.vsdkButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IcfKernelRootSelectionDialog.this.handleBrowseVsdkButtonPressed();
            }
        });
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.fileSystemButton = DialogWidgetsUtil.createPushButton((Composite)buttonComposite, (String)Messages.IcfKernelRootSelectionDialog_browse_from_file_system, (GridData)gridData);
        this.fileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IcfKernelRootSelectionDialog.this.handleBrowseFileSystemButtonPressed();
            }
        });
        this.updateStatus(IcfKernelsUiActivator.getInstance().createError(null));
        this.setHelpAvailable(false);
        return composite;
    }

    protected void handleBrowseVsdkButtonPressed() {
        try {
            FolderSelectionDialog dialog = new FolderSelectionDialog(this.getShell(), Messages.IcfKernelRootSelectionDialog_select_kernel_root_from_vsdk, Messages.IcfKernelRootSelectionDialog_choose_folder_with_kernels, RcpVariables.INSTANCE.getPath(this.vsdkVariable));
            if (dialog.open() != 0) {
                return;
            }
            this.setDirectory(RcpVariables.INSTANCE.relativize(this.vsdkVariable, dialog.getSelectedFolder()));
        }
        catch (CoreException e) {
            this.notifyPathError(e);
        }
    }

    private void handleBrowseFileSystemButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell());
        try {
            dialog.setFilterPath(RcpVariables.INSTANCE.getPath(this.projectVariable).toString());
            dialog.setText(Messages.IcfKernelRootSelectionDialog_select_kernel_root_from_file_system);
            dialog.setMessage(Messages.IcfKernelRootSelectionDialog_choose_folder_with_kernels);
            String directory = dialog.open();
            if (directory != null) {
                this.setDirectory(RcpVariables.INSTANCE.relativize(this.projectVariable, directory));
            }
        }
        catch (CoreException e) {
            this.notifyPathError(e);
        }
    }

    private void setDirectory(String arg) {
        this.directory = arg;
        if (IcfKernelRootSelectionDialog.isEmpty(arg)) {
            this.directoryField.setText("");
        } else {
            this.directoryField.setText(arg);
        }
    }

    public void validate() {
        IStatus validationStatus;
        if (this.validator != null && !(validationStatus = this.validator.validate((Object)this.directory)).isOK()) {
            this.updateStatus(validationStatus);
            return;
        }
        this.updateStatus(Status.OK_STATUS);
    }

    private static boolean isEmpty(String arg) {
        return arg == null || arg.trim().isEmpty();
    }

    private void notifyPathError(CoreException e) {
        IcfKernelsUiActivator.getInstance().log(e.getStatus());
        ErrorDialog.openError((Shell)this.getShell(), (String)Messages.IcfKernelRootSelectionDialog_error, (String)Messages.IcfKernelRootSelectionDialog_cannot_resolve_path, (IStatus)e.getStatus());
    }
}

