/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.acf.headless.kernel;

import com.nxp.s32ds.ext.emf.ecore.EmfResources;
import com.nxp.s32ds.ext.rcp.runtime.util.FilePaths;
import com.nxp.s32ds.mdt.vpt.acf.api.DataIO;
import com.nxp.s32ds.mdt.vpt.acf.api.DataMemory;
import com.nxp.s32ds.mdt.vpt.acf.api.DataProcessing;
import com.nxp.s32ds.mdt.vpt.acf.api.DataScale;
import com.nxp.s32ds.mdt.vpt.acf.api.DataTiling;
import com.nxp.s32ds.mdt.vpt.acf.api.ElementType;
import com.nxp.s32ds.mdt.vpt.acf.api.KernelDef;
import com.nxp.s32ds.mdt.vpt.acf.api.KernelPortDef;
import com.nxp.s32ds.mdt.vpt.acf.api.SourceUnit;
import com.nxp.s32ds.mdt.vpt.acf.headless.AcfHeadless;
import com.nxp.s32ds.mdt.vpt.acf.meta.AcfFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;

public class AcfKernels {
    public static final String ACF_ATTR_IN = "IN";
    public static final String ACF_ATTR_OUT = "OUT";
    public static final String ACF_ATTR_VEC = "VEC";
    public static final String ACF_ATTR_SCL = "SCL";
    public static final String ACF_ATTR_FIXED = "FIXED";
    public static final String ACF_ATTR_STATIC = "STATIC";
    public static final String ACF_ATTR_FIFO = "FIFO";
    public static final String KERNEL_INFO = "KERNEL_INFO";
    public static final String KERNEL_PORT = "__port";
    public static final String PORT_ATTRIBUTES = "__attributes";
    public static final String PORT_INDENTIFIER = "__identifier";
    public static final String PORT_SPATIAL_DEP = "__spatial_dep";
    public static final String PORT_E0_DATA_TYPE = "__e0_data_type";
    public static final String PORT_E0_SIZE = "__e0_size";
    public static final String PORT_EK_SIZE = "__ek_size";
    private static final String POSTFIX_ACF = "_acf";
    private static final String EXT_H = "h";
    private static final String EXT_CPP = "cpp";
    private static final String KERNEL_ACF_H = "_acf.h";
    private static final String KERNEL_ACF_CPP = "_acf.cpp";
    private static final Pattern PATTERN_KERNEL = Pattern.compile("#define\\s+(\\w+_K)\\s+(\\w+)");
    private static final Pattern PATTERN_PORT = Pattern.compile("#define\\s+(\\w+)\\s+(\"\\w+\")");
    private static final String COMMA = ",";
    private static final String KERNEL_END = ");";
    private static final String BRACET_OUT = ")";
    private static final String BRACET_IN = "(";

    public static boolean isAcfKernelHeader(Path path) {
        if (path == null) {
            return false;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        return path.toFile().getAbsolutePath().toLowerCase().endsWith(KERNEL_ACF_H);
    }

    public static boolean isAcfKernelImplementation(Path path) {
        if (path == null) {
            return false;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        return path.toFile().getAbsolutePath().toLowerCase().endsWith(KERNEL_ACF_CPP);
    }

    public static Map<String, String> scanAcfKernelHeader(Path path) throws CoreException {
        HashMap<String, String> aliases = new HashMap<String, String>();
        Path scanned = path;
        if (!AcfKernels.isAcfKernelHeader(scanned)) {
            String extractedName = FilePaths.replaceExtension((String)path.getFileName().toString(), (String)EXT_H);
            scanned = Paths.get(path.toFile().getParentFile().toString(), extractedName);
        }
        try {
            List<String> lines = Files.readAllLines(scanned);
            for (String line : lines) {
                Matcher kernelMatcher = PATTERN_KERNEL.matcher(line);
                while (kernelMatcher.find()) {
                    String name = kernelMatcher.group(1).trim();
                    String identifier = kernelMatcher.group(2).trim();
                    aliases.put(name, identifier);
                }
                Matcher portMatcher = PATTERN_PORT.matcher(line);
                while (portMatcher.find()) {
                    String name = portMatcher.group(1).trim();
                    String identifier = portMatcher.group(2).trim();
                    identifier = identifier.substring(1, identifier.length() - 1);
                    aliases.put(name, identifier);
                }
            }
        }
        catch (IOException e) {
            throw new CoreException(AcfHeadless.createKernelInfoFileNotReadable(scanned, e));
        }
        return aliases;
    }

    public static SourceUnit scanAcfKernelImplementation(Path path, Map<String, String> aliases) throws CoreException {
        Path scanned = path;
        SourceUnit unit = AcfFactory.eINSTANCE.createSourceUnit();
        if (!AcfKernels.isAcfKernelImplementation(scanned)) {
            String extractedName = FilePaths.replaceExtension((String)path.getFileName().toString(), (String)EXT_CPP);
            scanned = Paths.get(path.toFile().getParentFile().toString(), extractedName);
        }
        unit.setCategory(AcfKernels.extractCategory(scanned.toFile()));
        ScanState state = ScanState.SCAN_KERNEL;
        KernelDef kernelInfo = null;
        KernelPortDef portInfo = null;
        try {
            List<String> lines = Files.readAllLines(scanned);
            block12: for (String line : lines) {
                if (line.contains(KERNEL_END)) {
                    state = ScanState.SCAN_KERNEL;
                }
                switch (state) {
                    case SCAN_KERNEL: {
                        String message;
                        String kernelName;
                        if (!line.contains(KERNEL_INFO) || (kernelName = AcfKernels.unsafeExtractFromBrackets(line).trim()).isEmpty()) continue block12;
                        kernelInfo = AcfFactory.eINSTANCE.createKernelDef();
                        String kernelId = aliases.get(kernelName);
                        if (kernelId == null) {
                            message = NLS.bind((String)"Identifier not found for kernel (name): {0} ", (Object)kernelName);
                            System.out.println(message);
                        }
                        kernelInfo.setIdentifier(kernelName);
                        unit.getKernels().add((Object)kernelInfo);
                        state = ScanState.SCAN_PORT;
                        break;
                    }
                    case SCAN_PORT: {
                        if (!line.contains(KERNEL_PORT)) break;
                        portInfo = AcfFactory.eINSTANCE.createKernelPortDef();
                        kernelInfo.getPorts().add((Object)portInfo);
                        state = ScanState.SCAN_ID;
                        break;
                    }
                    case SCAN_ID: {
                        String message;
                        if (!line.contains(PORT_INDENTIFIER)) break;
                        String portName = AcfKernels.unsafeExtractFromBrackets(line);
                        if (portName.startsWith("\"") && portName.endsWith("\"")) {
                            portName = portName.substring(1, portName.length() - 1);
                            portInfo.setIdentifier(portName);
                        } else {
                            String portId = aliases.get(portName);
                            if (portId == null) {
                                message = NLS.bind((String)"Identifier not found for port (name): {0} ", (Object)portName);
                                System.out.println(message);
                            }
                            portInfo.setIdentifier(portName);
                        }
                        state = ScanState.SCAN_ATTR;
                        break;
                    }
                    case SCAN_ATTR: {
                        String attributes;
                        if (!line.contains(PORT_ATTRIBUTES) || (attributes = AcfKernels.unsafeExtractFromBrackets(line)).isEmpty()) continue block12;
                        AcfKernels.setAttributesForPort(portInfo, attributes);
                        state = ScanState.SCAN_SD;
                        break;
                    }
                    case SCAN_SD: {
                        if (!line.contains(PORT_SPATIAL_DEP)) break;
                        String value = AcfKernels.unsafeExtractFromBrackets(line);
                        String[] split = value.split(COMMA);
                        if (split.length == 4) {
                            portInfo.setSdLeft(split[0].trim());
                            portInfo.setSdRight(split[1].trim());
                            portInfo.setSdTop(split[2].trim());
                            portInfo.setSdBottom(split[3].trim());
                        }
                        state = ScanState.SCAN_DT;
                        break;
                    }
                    case SCAN_DT: {
                        if (!line.contains(PORT_E0_DATA_TYPE)) break;
                        String dataType = AcfKernels.unsafeExtractFromBrackets(line);
                        ElementType portDataType = ElementType.get((String)dataType);
                        if (portDataType != null) {
                            portInfo.setE0DataType(portDataType);
                        }
                        state = ScanState.SCAN_E0;
                        break;
                    }
                    case SCAN_E0: {
                        if (!line.contains(PORT_E0_SIZE)) break;
                        String value = AcfKernels.unsafeExtractFromBrackets(line);
                        String[] split = value.split(COMMA);
                        if (split.length == 2) {
                            portInfo.setE0SizeX(split[0].trim());
                            portInfo.setE0SizeY(split[1].trim());
                        }
                        state = ScanState.SCAN_EK;
                        break;
                    }
                    case SCAN_EK: {
                        if (!line.contains(PORT_EK_SIZE)) break;
                        String value = AcfKernels.unsafeExtractFromBrackets(line);
                        String[] split = value.split(COMMA);
                        if (split.length == 2) {
                            portInfo.setEKSizeX(split[0].trim());
                            portInfo.setEKSizeY(split[1].trim());
                        }
                        state = ScanState.SCAN_PORT;
                        break;
                    }
                }
            }
        }
        catch (IOException e) {
            throw new CoreException(AcfHeadless.createKernelInfoFileNotReadable(scanned, e));
        }
        return unit;
    }

    public static IStatus storeKernelInfos(String pathToFolder, Map<Path, SourceUnit> mapKernelInfo, IProgressMonitor monitor) {
        MultiStatus result = new MultiStatus("com.nxp.s32ds.mdt.vpt.acf.headless", 0, Status.OK_STATUS.getMessage(), null);
        if (mapKernelInfo != null) {
            for (Map.Entry<Path, SourceUnit> it : mapKernelInfo.entrySet()) {
                Path path = it.getKey();
                String pathString = path.getFileName().toString();
                String modelName = FilePaths.replaceExtension((String)pathString, (String)"acf");
                String parentFolderName = path.getParent().getParent().getFileName().toString();
                String modelPath = String.valueOf(pathToFolder) + '/' + parentFolderName;
                String platformPath = String.valueOf(modelPath) + '/' + modelName;
                URI uri = URI.createFileURI((String)platformPath);
                IStatus save = EmfResources.save((URI)uri, (EObject)((EObject)it.getValue()));
                if (save.isOK()) continue;
                result.add(save);
            }
        }
        return result;
    }

    private static String extractCategory(File file) {
        File categoryDir;
        File srcDir = file.getParentFile();
        if (srcDir != null && (categoryDir = srcDir.getParentFile()) != null) {
            return categoryDir.getName();
        }
        return "";
    }

    private static String unsafeExtractFromBrackets(String line) {
        if (line.indexOf(BRACET_IN) > -1 && line.indexOf(BRACET_OUT) > -1) {
            return line.substring(line.indexOf(BRACET_IN) + 1, line.indexOf(BRACET_OUT));
        }
        return "";
    }

    private static void setAttributesForPort(KernelPortDef portInfo, String attributes) {
        portInfo.setTiling(DataTiling.NONSTATIC);
        portInfo.setScale(DataScale.NONFIXED);
        portInfo.setProcessing(DataProcessing.REG);
        if (attributes.contains(ACF_ATTR_IN)) {
            portInfo.setIo(DataIO.IN);
        } else if (attributes.contains(ACF_ATTR_OUT)) {
            portInfo.setIo(DataIO.OUT);
        }
        if (attributes.contains(ACF_ATTR_VEC)) {
            portInfo.setMemory(DataMemory.VEC);
        } else if (attributes.contains(ACF_ATTR_SCL)) {
            portInfo.setMemory(DataMemory.SCL);
        }
        if (attributes.contains(ACF_ATTR_STATIC)) {
            portInfo.setTiling(DataTiling.STATIC);
        }
        if (attributes.contains(ACF_ATTR_FIXED)) {
            portInfo.setScale(DataScale.FIXED);
        }
        if (attributes.contains(ACF_ATTR_FIFO)) {
            portInfo.setProcessing(DataProcessing.FIFO);
        }
    }

    public static enum ScanState {
        SCAN_KERNEL,
        SCAN_PORT,
        SCAN_ATTR,
        SCAN_SD,
        SCAN_ID,
        SCAN_DT,
        SCAN_E0,
        SCAN_EK;

    }
}

