/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.acf.headless.kernel;

import com.nxp.s32ds.mdt.vpt.acf.api.SourceUnit;
import com.nxp.s32ds.mdt.vpt.acf.headless.AcfHeadless;
import com.nxp.s32ds.mdt.vpt.acf.headless.AcfHeadlessMessages;
import com.nxp.s32ds.mdt.vpt.acf.headless.kernel.AcfKernels;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;

public class AcfKernelScannerJob
extends Job {
    private final String rootFolder;
    private final String outputFolder;

    public AcfKernelScannerJob(String root, String output) {
        super(AcfHeadlessMessages.AcfKernelScannerJob_name);
        this.rootFolder = root;
        this.outputFolder = output;
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            Path rootPath = this.convertRootPath(this.rootFolder);
            Path outputPath = this.convertOutputPath(this.outputFolder);
            monitor.beginTask("", 100);
            List<Path> paths = this.collectKernels(rootPath, SubMonitor.convert((IProgressMonitor)monitor, (String)AcfHeadlessMessages.AcfKernelScannerJob_sub_collecting, (int)20));
            Map<Path, SourceUnit> scanned = this.scanKernels(paths, SubMonitor.convert((IProgressMonitor)monitor, (String)AcfHeadlessMessages.AcfKernelScannerJob_sub_scanning, (int)60));
            IStatus iStatus = AcfKernels.storeKernelInfos(outputPath.toFile().getAbsolutePath().toString(), scanned, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (String)AcfHeadlessMessages.AcfKernelScannerJob_sub_storing, (int)20));
            return iStatus;
        }
        catch (CoreException e) {
            IStatus iStatus = e.getStatus();
            return iStatus;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private Path convertRootPath(String folder) throws CoreException {
        try {
            Path rootPath = Paths.get(folder, new String[0]);
            if (!Files.isDirectory(rootPath, new LinkOption[0])) {
                IStatus error = AcfHeadless.createKernelRootFolderNotADir(rootPath);
                throw new CoreException(error);
            }
            if (!Files.isReadable(rootPath)) {
                IStatus error = AcfHeadless.createKernelRootFolderNotReadable(rootPath, null);
                throw new CoreException(error);
            }
            return rootPath;
        }
        catch (Throwable e) {
            IStatus error = AcfHeadless.createKernelRootFolderUndefined(e);
            throw new CoreException(error);
        }
    }

    private Path convertOutputPath(String folder) throws CoreException {
        try {
            Path outputPath = Paths.get(folder, new String[0]);
            if (!Files.exists(outputPath, new LinkOption[0])) {
                try {
                    Files.createDirectories(outputPath, new FileAttribute[0]);
                }
                catch (IOException e) {
                    IStatus error = AcfHeadless.createKernelOutputFolderNotWritable(outputPath, e);
                    throw new CoreException(error);
                }
            }
            if (!Files.isDirectory(outputPath, new LinkOption[0])) {
                IStatus error = AcfHeadless.createKernelOutputFolderNotADir(outputPath);
                throw new CoreException(error);
            }
            if (!Files.isWritable(outputPath)) {
                IStatus error = AcfHeadless.createKernelOutputFolderNotWritable(outputPath, null);
                throw new CoreException(error);
            }
            return outputPath;
        }
        catch (Throwable e) {
            IStatus error = AcfHeadless.createKernelOutputFolderUndefined(e);
            throw new CoreException(error);
        }
    }

    private List<Path> collectKernels(Path rootPath, final SubMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        final ArrayList<Path> paths = new ArrayList<Path>();
        SimpleFileVisitor<Path> visitor = new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (monitor.isCanceled()) {
                    return FileVisitResult.TERMINATE;
                }
                return super.preVisitDirectory(dir, attrs);
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (monitor.isCanceled()) {
                    return FileVisitResult.TERMINATE;
                }
                if (AcfKernels.isAcfKernelImplementation(file)) {
                    paths.add(file);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (monitor.isCanceled()) {
                    return FileVisitResult.TERMINATE;
                }
                return super.postVisitDirectory(dir, exc);
            }
        };
        try {
            Files.walkFileTree(rootPath, (FileVisitor<? super Path>)visitor);
        }
        catch (IOException e) {
            throw new CoreException(AcfHeadless.createKernelRootFolderNotReadable(rootPath, e));
        }
        return paths;
    }

    private Map<Path, SourceUnit> scanKernels(List<Path> paths, SubMonitor monitor) throws CoreException {
        HashMap<Path, SourceUnit> result = new HashMap<Path, SourceUnit>();
        for (Path path : paths) {
            if (monitor.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            Map<String, String> aliases = AcfKernels.scanAcfKernelHeader(path);
            SourceUnit unit = AcfKernels.scanAcfKernelImplementation(path, aliases);
            if (unit.getKernels().size() <= 0) continue;
            result.put(path, unit);
        }
        return result;
    }
}

