/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.mdt.vpt.acf.headless;

import com.nxp.s32ds.mdt.vpt.acf.headless.AcfHeadlessMessages;
import java.nio.file.Path;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class AcfHeadless {
    public static final String BUNDLE_SYMBOLIC_NAME = "com.nxp.s32ds.mdt.vpt.acf.headless";
    public static final int CODE_KERNEL_ROOT_FOLDER_UNDEFINED = 2101;
    public static final int CODE_KERNEL_ROOT_FOLDER_NOT_A_DIR = 2102;
    public static final int CODE_KERNEL_ROOT_FOLDER_NOT_READABLE = 2103;
    public static final int CODE_KERNEL_INFO_FILE_NOT_READABLE = 2113;
    public static final int CODE_KERNEL_OUTPUT_FOLDER_UNDEFINED = 2201;
    public static final int CODE_KERNEL_OUTPUT_FOLDER_NOT_A_DIR = 2202;
    public static final int CODE_KERNEL_OUTPUT_FOLDER_NOT_WRITABLE = 2203;

    public static IStatus createError(int code, String message, Throwable error) {
        return new Status(4, BUNDLE_SYMBOLIC_NAME, code, message, error);
    }

    public static IStatus createKernelRootFolderUndefined(Throwable error) {
        return AcfHeadless.createError(2101, AcfHeadlessMessages.AcfHeadless_e_kernel_root_folder_undefined, error);
    }

    public static IStatus createKernelRootFolderNotADir(Path path) {
        String message = NLS.bind((String)AcfHeadlessMessages.AcfHeadless_e_kernel_root_folder_not_a_dir, (Object)path);
        return AcfHeadless.createError(2102, message, null);
    }

    public static IStatus createKernelRootFolderNotReadable(Path path, Throwable error) {
        String message = NLS.bind((String)AcfHeadlessMessages.AcfHeadless_e_kernel_root_folder_not_readable, (Object)path);
        return AcfHeadless.createError(2103, message, null);
    }

    public static IStatus createKernelInfoFileNotReadable(Path path, Throwable error) {
        String message = NLS.bind((String)AcfHeadlessMessages.AcfHeadless_e_kernel_info_file_not_readable, (Object)path);
        return AcfHeadless.createError(2113, message, null);
    }

    public static IStatus createKernelOutputFolderUndefined(Throwable error) {
        return AcfHeadless.createError(2201, AcfHeadlessMessages.AcfHeadless_e_kernel_output_folder_undefined, error);
    }

    public static IStatus createKernelOutputFolderNotADir(Path path) {
        String message = NLS.bind((String)AcfHeadlessMessages.AcfHeadless_e_kernel_output_folder_not_a_dir, (Object)path);
        return AcfHeadless.createError(2202, message, null);
    }

    public static IStatus createKernelOutputFolderNotWritable(Path path, Throwable error) {
        String message = NLS.bind((String)AcfHeadlessMessages.AcfHeadless_e_kernel_output_folder_not_writable, (Object)path);
        return AcfHeadless.createError(2203, message, error);
    }
}

