/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.view;

import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.DiagramLegend;
import com.nxp.swtools.clocks.ui.GlobalSettingsConfiguration;
import com.nxp.swtools.clocks.ui.diagram.DiagramCanvas;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.toolbar.SearchToolbarContribution;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.view.ToolView;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;

public class DiagramView
extends ToolView {
    @NonNull
    public static final String ID = "com.nxp.swtools.clocks.DiagramView";
    @NonNull
    public static final String CONTEXT_ID = "com.nxp.swtools.clocks.contexts.diagramView";
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(DiagramView.class);
    private static final double ZOOM_STEP = 0.5;
    @Nullable
    DiagramLegend legend;
    @Nullable
    DiagramCanvas diagramCanvas;
    @Nullable
    Composite mainComposite;
    @NonNull
    @NonNull Set<@NonNull IEventListener> listeners = new HashSet<IEventListener>();
    @NonNull
    private SearchToolbarContribution searchToolbar = new SearchToolbarContribution();

    public @NonNull DiagramCanvas getDiagramCanvas() {
        assert (this.diagramCanvas != null);
        return this.diagramCanvas;
    }

    private void attachDoubleClickListener() {
        Listener doubleClickListener = e -> {
            IClocksConfig config = this.getDiagramCanvas().getWorkingConfig();
            if (config != null) {
                GuiController.showDetailsView();
            }
        };
        this.getDiagramCanvas().getCanvas().addListener(8, doubleClickListener);
    }

    public void openSearchList() {
        this.searchToolbar.getSearchItem().getControl().open();
    }

    private void createContextMenu() {
        IEventListener listener = new IEventListener(){
            @NonNull
            private final Menu menu;
            {
                this.menu = new Menu((Decorations)DiagramView.this.getDiagramCanvas().getCanvas().getShell(), 64);
                SWTFactoryProxy.INSTANCE.setTestId((Widget)this.menu, "graphContextMenu");
                DiagramView.this.getDiagramCanvas().getCanvas().setMenu(this.menu);
            }

            public void handle(@NonNull ToolEvent event) {
                IClockElement element;
                MenuItem[] menuItemArray = this.menu.getItems();
                int n = menuItemArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MenuItem item = menuItemArray[n2];
                    item.dispose();
                    ++n2;
                }
                String selectedElementId = GuiController.getInstance().getSelectedElement();
                IClocksConfig config = DiagramView.this.getDiagramCanvas().getWorkingConfig();
                if (config == null) {
                    return;
                }
                IMcu mcu = config.getMcu();
                IClockComponent component = selectedElementId == null ? null : mcu.getClockComponent(selectedElementId);
                IClockElement iClockElement = element = selectedElementId == null ? null : mcu.getClockElement(selectedElementId);
                if (element != null) {
                    ISetting setting = element.getMainSetting();
                    if (setting != null && setting.isUserEnableable()) {
                        this.createEnableMenuItem(setting, config);
                    }
                    String message = element instanceof ClockOutput ? Messages.get().DiagramView_EditSettingsOnPathTo : Messages.get().DiagramView_EditSettingsOf;
                    String text = UtilsText.safeString((String)MessageFormat.format(message, element.getName()));
                    this.createMenuItem(text, element.getID());
                    component = element.getParentComponent(mcu);
                }
                if (component != null) {
                    String text = UtilsText.safeString((String)MessageFormat.format(Messages.get().DiagramView_EditSettingsOf, component.getName()));
                    this.createMenuItem(text, component.getID());
                }
                this.createMenuItem(UtilsText.safeString((String)Messages.get().DiagramView_EditAllSettings), null);
            }

            private @NonNull MenuItem createMenuItem(@NonNull String text, final @Nullable String elementId) {
                MenuItem item = new MenuItem(this.menu, 8);
                item.setText(text);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        GuiController.getInstance().openShellWithSettingsOf(elementId);
                    }
                });
                return item;
            }

            private @NonNull MenuItem createEnableMenuItem(final @NonNull ISetting setting, final @NonNull IClocksConfig config) {
                MenuItem item = new MenuItem(this.menu, 8);
                SettingsConfig settingsConfig = config.getSettingsConfig();
                boolean userEnabled = settingsConfig.isUserEnabled(setting);
                String statusText = userEnabled ? Messages.get().DiagramView_DisableSetting : Messages.get().DiagramView_EnableSetting;
                item.setText(String.valueOf(statusText) + " " + setting.getElement().getID());
                item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        GuiController.getInstance().changeUserEnableStateOf(setting, config, DiagramView.this.getViewSite().getShell());
                    }
                });
                return item;
            }
        };
        GuiController.getInstance().addListener(8, listener);
        this.listeners.add(listener);
    }

    private void createButtons() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        GuiController controller = GuiController.getInstance();
        if (toolBar != null) {
            toolBar.add(controller.createToolbarAction("icons/direction_flow_toggle.png", Messages.get().DiagramView_SignalFlowToggle, "graphToolBarFlowToggle", () -> this.getDiagramCanvas().toggleSignalDirectionDrawing()));
            toolBar.add(controller.createToolbarAction("icons/zoom_in.png", Messages.get().DiagramView_ZoomInTooltip, "graphToolBarZoomIn", () -> this.getDiagramCanvas().zoomBy(0.5, false)));
            toolBar.add(controller.createToolbarAction("icons/zoom_out.png", Messages.get().DiagramView_ZoomOutTooltip, "graphToolBarZoomout", () -> this.getDiagramCanvas().zoomBy(-0.5, false)));
            toolBar.add(controller.createToolbarAction("icons/fit_horizontal.png", Messages.get().DiagramView_BtnFitHorizontallyToolTip, "graphToolBarFitHorizontally", () -> this.getDiagramCanvas().moveAndFillDiagram(false)));
            toolBar.add(controller.createToolbarAction("icons/fit_vertical.png", Messages.get().DiagramView_BtnFitVerticallyToolTip, "graphToolBarFitVertically", () -> this.getDiagramCanvas().moveAndFillDiagram(true)));
            toolBar.add(controller.createToolbarAction("icons/legend.png", Messages.get().DiagramLegend_DialogTitle, "graphToolBarLegend", () -> this.showLegend()));
            toolBar.add((IContributionItem)this.searchToolbar);
        } else {
            LOGGER.severe("Cannot create buttons in toolbar, as toolbar manager cannot be obtained");
            assert (false);
        }
    }

    private void showLegend() {
        if (this.legend == null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            this.legend = new DiagramLegend(shell);
        }
        assert (this.legend != null);
        this.legend.open();
    }

    public void createPartControl(Composite parent) {
        Composite defaultComposite;
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext(CONTEXT_ID);
        assert (parent != null);
        this.mainComposite = defaultComposite = this.createDefaultComposite(parent);
        GridLayout layout = new GridLayout(1, false);
        defaultComposite.setLayout((Layout)layout);
        Composite globalSettingsComposite = new Composite(defaultComposite, 0);
        globalSettingsComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        DiagramView.createGlobalSettingsComposite(globalSettingsComposite);
        Composite configComposite = new Composite(defaultComposite, 2048);
        configComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        configComposite.setLayout((Layout)new FillLayout());
        this.diagramCanvas = new DiagramCanvas(configComposite, GuiController.getInstance().getProfile().getMcu().getDiagramDataCopy(), null);
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.mainComposite, "graphWindow");
        this.createButtons();
        this.createContextMenu();
        this.attachDoubleClickListener();
        IPerspectiveListener perspectiveListener = this.createPerspectiveListener();
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().addPerspectiveListener(perspectiveListener);
        defaultComposite.addDisposeListener(e -> {
            this.listeners.forEach(x -> GuiController.getInstance().removeModelListener((IEventListener)x));
            PlatformUI.getWorkbench().getActiveWorkbenchWindow().removePerspectiveListener(perspectiveListener);
        });
    }

    @NonNull IPerspectiveListener createPerspectiveListener() {
        IPerspectiveListener listener = new IPerspectiveListener(){

            public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
                if ("viewHide".equals(changeId) && DiagramView.this.legend != null) {
                    DiagramView.this.legend.close();
                }
            }

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                if (PerspectivesHelper.findActiveView((String)DiagramView.ID) == null && DiagramView.this.legend != null) {
                    DiagramView.this.legend.close();
                }
            }
        };
        return listener;
    }

    public void setFocus() {
        Composite mainCompositeLoc = this.mainComposite;
        if (mainCompositeLoc != null) {
            mainCompositeLoc.setFocus();
        }
        if (this.diagramCanvas != null) {
            this.diagramCanvas.draw();
        }
    }

    public void dispose() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        IContextActivation activation = contextService.activateContext(CONTEXT_ID);
        contextService.deactivateContext(activation);
        if (this.legend != null) {
            this.legend.close();
        }
        super.dispose();
    }

    private static @NonNull GlobalSettingsConfiguration createGlobalSettingsComposite(@NonNull Composite parent) {
        return new GlobalSettingsConfiguration(parent);
    }
}

