/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.verification;

import com.nxp.swtools.clocks.data.DiagramData;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.PrescalerSetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.ui.diagram.DiagramConnection;
import com.nxp.swtools.clocks.ui.diagramsymbols.CompositeSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.TextField;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.TreeSet;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModelVerificator {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ModelVerificator.class);

    public static boolean verify(@Nullable IMcu mcu, @Nullable DiagramData diagram) {
        LOGGER.config(String.format("Verifying %s vs %s", mcu, diagram));
        boolean result = true;
        ArrayList<@NonNull IElement> mcuElements = null;
        Collection<DiagramSymbol> diagramSymbols = null;
        Collection<DiagramConnection> diagramConnections = null;
        result &= mcu != null;
        result &= diagram != null;
        if (mcu != null) {
            mcuElements = new ArrayList<IElement>(mcu.getAllElements().values());
            mcuElements.addAll(mcu.getAllPins());
        }
        if (diagram != null) {
            diagramSymbols = diagram.getTopLevelSymbols();
            diagramConnections = diagram.getAllConnections();
        }
        if (result &= ModelVerificator.compareElements(mcuElements, diagramSymbols, diagramConnections, mcu)) {
            LOGGER.info("No inconsistency between model and diagram detected.");
        } else {
            LOGGER.warning("Problems between model and diagram detected.");
        }
        return result;
    }

    protected static boolean compareElements(@Nullable Collection<@NonNull IElement> mcuElems, @Nullable Collection<@NonNull DiagramSymbol> diagramSymbols, @Nullable Collection<@NonNull DiagramConnection> diagramConnections, @Nullable IMcu mcu) {
        boolean status = true;
        if (mcuElems == null) {
            LOGGER.severe("MCU elements are null");
            return false;
        }
        if (diagramSymbols == null) {
            LOGGER.severe("Diagram symbols are null");
            return false;
        }
        if (diagramConnections == null) {
            LOGGER.severe("Diagram connections are null");
            return false;
        }
        if (mcu == null) {
            LOGGER.severe("MCU is null");
            return false;
        }
        assert (mcuElems != null);
        assert (diagramSymbols != null);
        assert (diagramConnections != null);
        assert (mcu != null);
        Collection<@NonNull DiagramSymbol> filteredSymbols = ModelVerificator.flattenAndFilter(diagramSymbols, mcu);
        status &= ModelVerificator.compareCount(mcuElems, filteredSymbols, diagramConnections);
        status &= ModelVerificator.compareIDsAndNames(mcuElems, filteredSymbols);
        return status &= ModelVerificator.compareHierarchy(mcuElems, diagramConnections, mcu);
    }

    protected static boolean compareHierarchy(@NonNull Collection<@NonNull IElement> mcuElems, @NonNull Collection<@NonNull DiagramConnection> diagramConnections, @NonNull IMcu mcu) {
        boolean status = true;
        Collection clockElems = (Collection)CollectionsUtils.getInstancesOf(mcuElems, IClockElement.class).collect(CollectorsUtils.toList());
        for (IClockElement pred : clockElems) {
            Collection<IClockElement> successors = pred.getSuccessors();
            for (IClockElement iClockElement : successors) {
                String connectionID = DiagramConnection.createConnectionID(pred.getID(), iClockElement.getID());
                boolean connExists = ModelVerificator.exists(diagramConnections, connectionID);
                status &= connExists;
                if (connExists) continue;
                LOGGER.severe(String.format("Cannot find path in diagram for %s -> %s", pred.getID(), iClockElement.getID()));
            }
        }
        for (DiagramConnection conn : diagramConnections) {
            DiagramSymbol pred = conn.getPredecessor();
            DiagramSymbol diagramSymbol = conn.getSuccessor();
            assert (pred != null);
            assert (diagramSymbol != null);
            boolean connExists = ModelVerificator.exists(mcuElems, pred.getId(), diagramSymbol.getId()) || mcu.isElementNotAvailable(pred.getId()) || mcu.isElementNotAvailable(diagramSymbol.getId()) || pred.isDiagramOnly() || diagramSymbol.isDiagramOnly();
            status &= connExists;
            if (connExists) continue;
            LOGGER.severe(String.format("Cannot find path in model for %s -> %s", pred, diagramSymbol));
        }
        return status;
    }

    private static boolean exists(@NonNull Collection<@NonNull DiagramConnection> diagramConnections, @NonNull String connectionID) {
        return diagramConnections.stream().anyMatch(x -> x.getId().equals(connectionID));
    }

    private static boolean exists(@NonNull Collection<@NonNull IElement> mcuElems, @Nullable String pred, @Nullable String succ) {
        if (pred == null) {
            LOGGER.warning("Argument 'pred' was null");
            return false;
        }
        if (succ == null) {
            LOGGER.warning("Argument 'succ' was null");
            return false;
        }
        return CollectionsUtils.getInstancesOf(mcuElems, IClockElement.class).filter(x -> x.getID().equals(pred)).flatMap(x -> x.getSuccessors().stream()).filter(y -> y.getID().equals(succ)).findFirst().isPresent();
    }

    private static boolean compareCount(@NonNull Collection<@NonNull IElement> mcuElems, @NonNull Collection<@NonNull DiagramSymbol> diagramSymbols, @NonNull Collection<@NonNull DiagramConnection> diagramConnections) {
        boolean status;
        boolean bl = status = mcuElems.size() == diagramSymbols.size();
        if (!status) {
            LOGGER.severe(String.format("Models have different number of elements (%d MCU model, %d Diagram Model)", mcuElems.size(), diagramSymbols.size()));
        }
        if (diagramConnections.isEmpty() && (mcuElems.size() != 0 || diagramSymbols.size() != 0)) {
            status = false;
            LOGGER.severe("There are no Diagram Connections");
        }
        return status;
    }

    protected static boolean compareIDsAndNames(@NonNull Collection<@NonNull IElement> mcuElems, @NonNull Collection<@NonNull DiagramSymbol> diagramSymbols) {
        boolean status = true;
        TreeSet<@NonNull E> mcuElemIDs = new TreeSet();
        TreeSet<@NonNull E> diagramElemIDs = new TreeSet();
        Set mcuDuplicates = mcuElems.stream().map(x -> x.getID()).filter(x -> !mcuElemIDs.add(x)).collect(Collectors.toSet());
        Set diagramDuplicates = diagramSymbols.stream().map(x -> x.getId()).filter(x -> !diagramElemIDs.add(x)).collect(Collectors.toSet());
        if (!mcuDuplicates.isEmpty()) {
            LOGGER.severe("Following MCU elements have duplicates:\n\t" + mcuDuplicates.toString());
            status = false;
        }
        if (!diagramDuplicates.isEmpty()) {
            LOGGER.severe("Following Diagram elements have duplicates:\n\t" + diagramDuplicates.toString());
            status = false;
        }
        List<@NonNull T> mcuElemsOnly = mcuElemIDs.stream().filter(x -> !diagramElemIDs.contains(x)).collect(Collectors.toList());
        List<@NonNull T> diagramElemsOnly = diagramElemIDs.stream().filter(x -> !mcuElemIDs.contains(x)).collect(Collectors.toList());
        if (!mcuElemsOnly.isEmpty()) {
            LOGGER.severe("Following MCU elements are not in diagram:\n\t" + mcuElemsOnly.toString());
            status = false;
        }
        if (!diagramElemsOnly.isEmpty()) {
            LOGGER.severe("Following Diagram elements are not in MCU:\n\t" + diagramElemsOnly.toString());
            status = false;
        }
        LOGGER.info("\nCOMPARING NAMES\n------------------------------------------------------------------------ ");
        mcuElemIDs.forEach(id -> {
            if (!diagramElemsOnly.contains(id)) {
                Optional<IElement> elem = ModelVerificator.getElementWithId(id, mcuElems);
                Optional<DiagramSymbol> symbol = ModelVerificator.getSymbolWithId(id, diagramSymbols);
                ModelVerificator.checkNames(elem, symbol);
            }
        });
        LOGGER.info("------------------------------------------------------------------------");
        return status;
    }

    private static void checkNames(Optional<IElement> elem, Optional<DiagramSymbol> symbol) {
        if (!elem.isPresent()) {
            LOGGER.severe("Invalid argument (element)");
            return;
        }
        if (!symbol.isPresent()) {
            LOGGER.severe("Invalid argument (symbol)");
            return;
        }
        IElement e = elem.get();
        DiagramSymbol s = symbol.get();
        String name = e.getName();
        boolean found = false;
        Stream fiels = CollectionsUtils.getInstancesOf(s.getGraphElems(), TextField.class);
        found = fiels.anyMatch(f -> f.getText().equals(name));
        if (!found) {
            found = s.getId().equals(name);
        }
        if (!found) {
            LOGGER.warning("Symbol with id: " + s.getId() + " does not have the same name (" + name + ") as its model counterpart");
        }
    }

    private static Optional<IElement> getElementWithId(@NonNull String id, @NonNull Collection<@NonNull IElement> mcuElems) {
        return mcuElems.stream().filter(s -> s.getID().equals(id)).findFirst();
    }

    private static Optional<DiagramSymbol> getSymbolWithId(@NonNull String id, @NonNull Collection<@NonNull DiagramSymbol> diagramSymbols) {
        return diagramSymbols.stream().filter(s -> s.getId().equals(id)).findFirst();
    }

    private static @NonNull Collection<@NonNull DiagramSymbol> flattenAndFilter(@NonNull Collection<@NonNull DiagramSymbol> diagramSymbols, @NonNull IMcu mcu) {
        Stack<DiagramSymbol> stack = new Stack<DiagramSymbol>();
        stack.addAll(diagramSymbols);
        ArrayList<@NonNull DiagramSymbol> result = new ArrayList<DiagramSymbol>();
        while (!stack.isEmpty()) {
            CompositeSymbol cSymbol;
            DiagramSymbol symbol = (DiagramSymbol)stack.pop();
            if (!(symbol instanceof CompositeSymbol) || !(cSymbol = (CompositeSymbol)symbol).isComponent()) continue;
            if (cSymbol.definesBoundary()) {
                stack.addAll(cSymbol.getAllParts());
                continue;
            }
            if (mcu.isElementNotAvailable(cSymbol.getId()) || cSymbol.isDiagramOnly()) continue;
            result.add(symbol);
        }
        return result;
    }

    public static void verifyDependencies(@NonNull IMcu mcu) {
        ModelVerificator.verifyEnablesOrder(mcu);
        ModelVerificator.verifyFrequequencyDependencies(mcu);
        ModelVerificator.verifyScaleDependencies(mcu);
    }

    private static void verifyScaleDependencies(@NonNull IMcu mcu) {
        for (ISetting setting : mcu.getSettings().getAllSettings()) {
            Collection<@NonNull String> dependencies = setting.getDependencies(mcu);
            if (setting instanceof EnableSetting) {
                EnableSetting enableSetting = (EnableSetting)setting;
                dependencies = enableSetting.getDependencies(mcu, false);
            }
            for (String dependencyId : dependencies) {
                ISetting dependencySetting = mcu.getSettings().findSettingWithId(dependencyId);
                if (!(dependencySetting instanceof PrescalerSetting)) continue;
                LOGGER.severe("The setting: " + setting.getId() + " is dependent on a scale of the element: " + dependencySetting.getElement().getID());
            }
        }
    }

    private static void verifyFrequequencyDependencies(@NonNull IMcu mcu) {
        for (ISetting setting : mcu.getSettings().getAllSettings()) {
            for (String dependencyId : setting.getDependencies(mcu)) {
                ISetting dependencySetting = mcu.getSettings().findSettingWithId(dependencyId);
                if (dependencySetting == null || dependencySetting.getType() != SettingType.FREQUENCY_OUTPUT || mcu.getSettings().getClockSources().contains(dependencySetting)) continue;
                LOGGER.severe("The setting: " + setting.getId() + " is dependent on output frequency of: " + dependencySetting.getElement().getID() + " which is not a clock source.");
            }
        }
    }

    private static void verifyEnablesOrder(@NonNull IMcu mcu) {
        for (ISetting enableSetting : mcu.getSettings().getAllEnableSettings()) {
            IElement element = enableSetting.getElement();
            if (!(element instanceof IClockElement)) continue;
            for (String dependencyId : enableSetting.getDependencies(mcu)) {
                IElement depencyElement;
                ISetting dependencySetting = mcu.getSettings().findSettingWithId(dependencyId);
                if (dependencySetting == null || dependencySetting.getType() != SettingType.ENABLE_DISABLE || !((depencyElement = dependencySetting.getElement()) instanceof IClockElement) || !ModelVerificator.isPotentialSuccessor((IClockElement)depencyElement, (IClockElement)element)) continue;
                LOGGER.severe("Enable state of the element: " + element.getID() + " is dependent on enable state of the element: " + depencyElement.getID() + " which is potential successor of it.");
            }
        }
    }

    public static boolean isPotentialSuccessor(@NonNull IClockElement potentialSuccessor, @NonNull IClockElement element) {
        if (element == potentialSuccessor) {
            return false;
        }
        return ModelVerificator.isPotentialSuccessorInternal(potentialSuccessor, element);
    }

    private static boolean isPotentialSuccessorInternal(@NonNull IClockElement potentialSucc, @NonNull IClockElement element) {
        if (element == potentialSucc) {
            return true;
        }
        for (IClockElement successor : element.getSuccessors()) {
            if (!ModelVerificator.isPotentialSuccessorInternal(potentialSucc, successor)) continue;
            return true;
        }
        return false;
    }
}

