/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.verification;

import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.valueMaps.IValueMap;
import com.nxp.swtools.clocks.data.valueMaps.RangeValueMap;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.expression.BitFieldVariable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import com.nxp.swtools.core.service.scriptapi.db.IRegBitFieldValueAPI;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.logging.Logger;

public class ExpressionVerificator {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ExpressionVerificator.class);
    @NonNull
    private static final ExpressionVerificator INSTANCE = new ExpressionVerificator();
    @NonNull
    private @NonNull Collection<@NonNull Expression> expressions = new ArrayList<Expression>();
    @NonNull
    private @NonNull Collection<@NonNull IValueMap> valueMaps = new ArrayList<IValueMap>();

    private ExpressionVerificator() {
    }

    public static @NonNull ExpressionVerificator getInstance() {
        return INSTANCE;
    }

    public void addExpression(@NonNull Expression expr) {
        if (SWToolsProperties.isVerificationOn()) {
            this.expressions.add(expr);
        }
    }

    public void addValueMap(@NonNull IValueMap valueMap) {
        if (SWToolsProperties.isVerificationOn()) {
            this.valueMaps.add(valueMap);
        }
    }

    public void verifyExpressions(@NonNull IClocksConfig config) {
        LOGGER.info("-------- Expression validation started --------");
        HashSet<@NonNull String> errors = new HashSet<String>();
        for (Expression expr : this.expressions) {
            IContext context = expr.getContext();
            for (BitFieldVariable bfVariable : expr.getBitFields()) {
                String bitFieldId = context.getBitFieldId(bfVariable.getRegisterName(), bfVariable.getBitFieldName());
                BitFieldElement bitField = ClocksBitFieldProvider.getBitFieldById(bitFieldId, config.getMcu().getRegisters());
                if (bitField != null) continue;
                errors.add(String.format("Bit field with id: '%s' not found", bitFieldId));
            }
            for (String id : expr.getSettings()) {
                ISetting setting = SettingProvider.getSettingById(id, config.getMcu());
                if (setting != null) continue;
                errors.add(String.format("Setting with id: '%s' not found", id));
            }
        }
        if (!errors.isEmpty()) {
            String errorText = UtilsText.join(errors, (String)",\n");
            LOGGER.warning("Found Problems:\n" + errorText);
        }
        LOGGER.info("-------- Expression validation finished --------");
    }

    public void clearExpressions() {
        this.expressions.clear();
    }

    public void verifyBitFields() {
        StringBuilder message = new StringBuilder();
        LOGGER.info("-------- Bit Field validation started --------");
        for (IValueMap valueMap : this.valueMaps) {
            if (!(valueMap instanceof RangeValueMap)) continue;
            BitFieldElement[] bitFieldElementArray = valueMap.getBitFields();
            int n = bitFieldElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                BitFieldElement bitField = bitFieldElementArray[n2];
                IRegBitFieldValueAPI[] values = bitField.getBitField().getValues();
                if (values.length > 0) {
                    Range range = valueMap.getRange();
                    assert (range != null);
                    BigInteger rangeSize = range.getSize();
                    if (rangeSize == null) {
                        double bitFieldSize = Math.pow(2.0, bitField.getWidth());
                        message.append("\n").append("Values inconsistent for bitfield: ").append(bitField.getId()).append("\n").append("Bitfield has range of " + bitFieldSize + " values but obtained " + values.length + "from registers database");
                    } else if (rangeSize.compareTo(BigInteger.valueOf(values.length)) != 0) {
                        message.append("\n").append("Values inconsistent for bitfield: ").append(bitField.getId()).append("\n").append("Clocks Tool supports " + rangeSize + " values but obtained " + values.length + " values from registers database");
                    }
                }
                ++n2;
            }
        }
        if (message.length() != 0) {
            LOGGER.warning(message.append("\n").toString());
        }
        LOGGER.info("-------- Bit Field validation finished --------");
    }
}

