/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.utils;

import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyCalculator;
import com.nxp.swtools.common.utils.frequency.FrequencyUnit;
import com.nxp.swtools.common.utils.number.NumberFormatter;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;

public class Converter {
    public static @NonNull Frequency toNormalizedFrequency(@NonNull BigRational hertz) {
        return FrequencyCalculator.normalize((Frequency)Converter.toFrequency(hertz), (long)1L);
    }

    public static @NonNull Frequency toFrequency(@NonNull BigRational hertz) {
        return new Frequency(hertz, FrequencyUnit.HERTZ);
    }

    public static @NonNull BigRational toHertz(@NonNull Frequency frequency) {
        Frequency hertzFrequency = FrequencyCalculator.toHertz((Frequency)frequency);
        return hertzFrequency.getValue();
    }

    public static @NonNull String toString(@NonNull BigInteger number, int radix, int minBitWidth) {
        return NumberFormatter.toString((BigInteger)number, (int)radix, (int)minBitWidth);
    }

    public static @NonNull String toString(@NonNull BigInteger number, @Nullable BigInteger bitMask, int radix, int bitWidth) {
        return NumberFormatter.toString((BigInteger)number, (BigInteger)bitMask, (int)radix, (int)bitWidth);
    }

    public static String convertPowerModesToExpr(String powerModes) {
        List<String> powerModeItems = Arrays.asList(powerModes.split("\\s+"));
        StringBuilder result = new StringBuilder();
        boolean isFirst = true;
        for (String powerMode : powerModeItems) {
            if (isFirst) {
                result.append("powerMode");
                result.append("==");
                isFirst = false;
            } else {
                result.append("||");
                result.append("powerMode");
                result.append("==");
            }
            result.append("`");
            result.append(powerMode);
            result.append("`");
        }
        return result.toString();
    }

    public static @NonNull Object convertToLRBS(@NonNull Object object) {
        Object result;
        Object objectToConvert = object;
        if (objectToConvert instanceof Frequency) {
            objectToConvert = Converter.toHertz((Frequency)objectToConvert);
        }
        if (objectToConvert instanceof Number) {
            long longValue = ((Number)objectToConvert).longValue();
            double doubleValue = ((Number)objectToConvert).doubleValue();
            result = doubleValue == (double)longValue ? Long.valueOf(longValue) : new BigRational(new BigDecimal(doubleValue));
        } else {
            BigRational rationalNumberObject;
            result = objectToConvert instanceof Boolean ? objectToConvert : (objectToConvert instanceof EnableSetting.EnableType ? Boolean.valueOf(((EnableSetting.EnableType)((Object)objectToConvert)).getBoolValue()) : (objectToConvert instanceof BigRational ? objectToConvert : ((rationalNumberObject = BigRational.tryParse((String)UtilsText.safeToString((Object)objectToConvert))) != null ? rationalNumberObject : UtilsText.safeToString((Object)objectToConvert))));
        }
        return result;
    }

    public static @NonNull Object convertToLDBS(@NonNull Object object) {
        Object result = Converter.convertToLRBS(object);
        if (result instanceof BigRational) {
            result = ((BigRational)result).doubleValue();
        }
        assert (result != null);
        return result;
    }
}

