/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.toolbar;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.Text;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class SearchContributionItem
extends ControlContribution {
    @NonNull
    GuiController controller = GuiController.getInstance();
    InstantSearchList searchList;
    @NonNull
    @NonNull Set<@NonNull IEventListener> listeners = new HashSet<IEventListener>();
    @NonNull
    @NonNull Map<@NonNull String, @NonNull String> labelMap = new HashMap<String, String>();

    public SearchContributionItem(@NonNull String id) {
        super(id);
    }

    protected Control createControl(Composite parent) {
        this.searchList = new InstantSearchList(Objects.requireNonNull(parent), 2052, "diagramSearchToolbar_shell", "diagramSearchToolbar_tree");
        this.searchList.setToolTipText(Messages.get().SearchContributionItem_tooltip);
        this.fillSearchList();
        IEventListener profileSelectListener = this.createProfileChangeListener();
        this.listeners.add(profileSelectListener);
        this.controller.addListener(64, profileSelectListener);
        IEventListener changeListener = this.createSelectionChangeListener();
        this.listeners.add(changeListener);
        this.controller.addListener(8, changeListener);
        this.searchList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedItem = e.text;
                if (selectedItem != null) {
                    String elementID = SearchContributionItem.this.labelMap.get(selectedItem);
                    elementID = elementID == null ? selectedItem : elementID;
                    SearchContributionItem.this.controller.setSelectedElement(elementID, (Object)this);
                    IClockElement element = SearchContributionItem.this.controller.getProfile().getMcu().getClockElement(elementID);
                    if (element != null && element instanceof ClockOutput) {
                        SearchContributionItem.this.controller.setActiveOutput(elementID, (Object)this);
                    }
                }
            }
        });
        return this.searchList;
    }

    private @NonNull IEventListener createProfileChangeListener() {
        return new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                SearchContributionItem.this.fillSearchList();
            }
        };
    }

    private @NonNull IEventListener createSelectionChangeListener() {
        return new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                String selectedElement = SearchContributionItem.this.controller.getSelectedElement();
                if (selectedElement != null && !SearchContributionItem.this.searchList.isDisposed() && event.originator != this) {
                    SearchContributionItem.this.searchList.select(selectedElement);
                } else {
                    SearchContributionItem.this.searchList.select("");
                }
            }
        };
    }

    public InstantSearchList getControl() {
        return this.searchList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    void fillSearchList() {
        if (!this.searchList.isDisposed()) {
            IMcu mcu = this.controller.getProfile().getMcu();
            @NonNull Set elements = (Set)mcu.getAllElements().keySet().stream().collect(CollectorsUtils.toSet());
            mcu.getClockComponents().keySet().forEach(x -> {
                boolean bl = elements.add(x);
            });
            Collection<DiagramSymbol> diagramSymbols = mcu.getDiagramDataCopy().getSymbolsWithElement();
            for (DiagramSymbol symbol : diagramSymbols) {
                List result = (List)CollectionsUtils.getInstancesOf(symbol.getGraphElems(), Text.class).collect(CollectorsUtils.toList());
                Optional optText = result.stream().findFirst();
                if (!optText.isPresent()) continue;
                this.labelMap.put(((Text)optText.get()).getText(), symbol.getId());
                elements.add(((Text)optText.get()).getText());
            }
            @NonNull List elementsSorted = (List)elements.stream().sorted().collect(CollectorsUtils.toList());
            this.searchList.setItems(CollectionsUtils.toStringArr((List)elementsSorted));
            this.searchList.setMessage(UtilsText.safeString((String)Messages.get().SearchContributionItem_hintText));
        }
    }

    public int computeWidth(Control control) {
        return 200;
    }

    public void dispose() {
        super.dispose();
        this.listeners.forEach(x -> this.controller.removeModelListener((IEventListener)x));
    }
}

