/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.toolbar;

import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.EmptyConfig;
import com.nxp.swtools.clocks.data.model.EmptyMcu;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.model.SettingsDB;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.SWToolsPlatform;
import com.nxp.swtools.provider.configuration.storage.StorageTool;
import com.nxp.swtools.utils.dialog.IChangeListener;
import com.nxp.swtools.utils.dialog.IFunctionalGroupUpdateListener;
import com.nxp.swtools.utils.dialog.ISelectedFunctionProvider;
import com.nxp.swtools.utils.dialog.ToolFunctionModification;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import com.nxp.swtools.utils.toolbar.AFunctionManager;
import com.nxp.swtools.utils.tools.IToolFunction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class ClocksFunctionManager
extends AFunctionManager {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ClocksFunctionManager.class);

    public ClocksFunctionManager() {
        GuiController.getInstance().addListener(114, new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (event.originator != ClocksFunctionManager.this) {
                    ClocksFunctionManager.this.updateFunctionBar();
                }
            }
        });
    }

    public boolean removeFunction(@NonNull IToolFunction function) {
        if (!(function instanceof IClocksConfig)) {
            return false;
        }
        return GuiController.getInstance().removeConfig((IClocksConfig)function);
    }

    public List<? extends @NonNull IToolFunction> getFunctions() {
        return GuiController.getInstance().getProfile().getConfigs();
    }

    public @NonNull IToolFunction getWorkingFunction() {
        IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
        return activeConfig == null ? new EmptyConfig(new EmptyMcu(""), "") : activeConfig;
    }

    public void setWorkingFunction(@NonNull IToolFunction function) {
        if (!(function instanceof IClocksConfig)) {
            return;
        }
        GuiController.getInstance().getProfile().setActiveConfig((IClocksConfig)function);
        GuiController.getInstance().getProfile().regenerateCode();
        GuiController.getInstance().fireListeners(new ToolEvent.Builder(32).setOriginator((Object)this).build());
        this.updateFunctionBar();
    }

    public void setWorkingFunction(@NonNull IToolFunction function, boolean isUndoAction) {
        if (!(function instanceof IClocksConfig)) {
            return;
        }
        if (isUndoAction) {
            IClocksConfig config = (IClocksConfig)function;
            config.getSettingsConfig().clearChanges();
        }
        this.setWorkingFunction(function);
    }

    public void setCalledFromDefaultInit(@NonNull IToolFunction function, boolean called) {
        if (!(function instanceof IClocksConfig)) {
            return;
        }
        UiController uiController = UiController.getInstance();
        uiController.setConfigOfDefaultInit(called ? (IClocksConfig)function : null);
    }

    public boolean allowMultipleCallFromInit() {
        return false;
    }

    public IFunctionalGroupUpdateListener createSpecificProperties(@NonNull Composite parent, @NonNull ISelectedFunctionProvider selectedFunctionProvider, @NonNull IChangeListener changeListener) {
        IClocksProfile profile = GuiController.getInstance().getProfile();
        SettingsDB settingsDb = profile.getMcu().getSettings();
        ArrayList<@NonNull AGlobalSetting> globalSettings = new ArrayList<AGlobalSetting>(settingsDb.getGlobalSettings());
        HashMap<@NonNull AGlobalSetting, @NonNull InstantSearchList> combos = new HashMap<AGlobalSetting, InstantSearchList>();
        IClocksConfig config = ClocksFunctionManager.getSelectedConfig(selectedFunctionProvider);
        for (AGlobalSetting setting : globalSettings) {
            Label title = new Label(parent, 0);
            title.setText(setting.getName());
            InstantSearchList combo = new InstantSearchList(parent, 2048);
            combos.put(setting, combo);
            SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "comboBox_" + setting.getId());
            combo.addSelectionListener((SelectionListener)ClocksFunctionManager.createGlobalSettingsSelectionChangeListener(selectedFunctionProvider, changeListener, combos, setting));
            ClocksFunctionManager.updateGlobalSettingsValues(combo, setting, config);
            ClocksFunctionManager.updateGlobalSettingsState(combo, setting, config);
        }
        return ClocksFunctionManager.createFunctionalGroupUpadteListener(selectedFunctionProvider, combos);
    }

    private static @NonNull IFunctionalGroupUpdateListener createFunctionalGroupUpadteListener(final @NonNull ISelectedFunctionProvider selectedFunctionProvider, final @NonNull Map<@NonNull AGlobalSetting, @NonNull InstantSearchList> combos) {
        return new IFunctionalGroupUpdateListener(){

            public void updateFunctionalGroup(@NonNull ToolFunctionModification function) {
                IClocksConfig selectedConfig = ClocksFunctionManager.getSelectedConfig(selectedFunctionProvider);
                combos.entrySet().forEach(x -> ClocksFunctionManager.updateGlobalSettingsValues((InstantSearchList)x.getValue(), (AGlobalSetting)x.getKey(), selectedConfig));
                combos.entrySet().forEach(x -> ClocksFunctionManager.updateGlobalSettingsState((InstantSearchList)x.getValue(), (AGlobalSetting)x.getKey(), selectedConfig));
            }
        };
    }

    private static @NonNull SelectionAdapter createGlobalSettingsSelectionChangeListener(final @NonNull ISelectedFunctionProvider selectedFunctionProvider, final IChangeListener changeListener, final @NonNull Map<@NonNull AGlobalSetting, @NonNull InstantSearchList> combos, final @NonNull AGlobalSetting setting) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IClocksConfig selectedConfig;
                String selectedValue = UtilsText.safeString((String)e.text);
                SettingValue value = setting.parseUiValue(selectedValue, selectedConfig = ClocksFunctionManager.getSelectedConfig(selectedFunctionProvider));
                if (value != null) {
                    selectedConfig.setSettingValue(setting, value, true, true);
                    combos.entrySet().forEach(x -> ClocksFunctionManager.updateGlobalSettingsValues((InstantSearchList)x.getValue(), (AGlobalSetting)x.getKey(), selectedConfig));
                    combos.entrySet().forEach(x -> ClocksFunctionManager.updateGlobalSettingsState((InstantSearchList)x.getValue(), (AGlobalSetting)x.getKey(), selectedConfig));
                    changeListener.propertiesChange();
                }
            }
        };
    }

    static @NonNull IClocksConfig getSelectedConfig(ISelectedFunctionProvider selectedFunctionProvider) {
        IClocksConfig config;
        ToolFunctionModification selectedFunction = selectedFunctionProvider.getSelectedFunction();
        IClocksConfig iClocksConfig = config = selectedFunction != null && selectedFunction.getOriginalFunction() instanceof IClocksConfig ? (IClocksConfig)selectedFunction.getOriginalFunction() : GuiController.getInstance().getProfile().getActiveConfig();
        assert (config != null);
        return config;
    }

    static void updateGlobalSettingsValues(@NonNull InstantSearchList combo, @NonNull AGlobalSetting setting, @NonNull IClocksConfig config) {
        List<SettingValue> settingValues = setting.getValues(config);
        int size = settingValues == null ? 0 : settingValues.size();
        String[] values = new String[size];
        HashSet<@NonNull String> errorItems = new HashSet<String>();
        HashMap<String, String> itemToolTips = new HashMap<String, String>();
        int i = 0;
        while (i < size) {
            String value;
            assert (settingValues != null);
            SettingValue settingValue = settingValues.get(i);
            values[i] = value = settingValue.getUiValue();
            if (setting.hasConflicts(settingValue, config)) {
                errorItems.add(value);
            }
            String itemTooltip = setting.getToolTipText(settingValue, config);
            itemToolTips.put(value, Text.replaceNewLinesWithSpace(itemTooltip));
            ++i;
        }
        combo.setItems(values);
        Image errorImg = ToolsImages.getStatusIcon((int)2);
        combo.setStatusItemProvider(it -> errorItems.contains(it) ? errorImg : null);
        itemToolTips.entrySet().forEach(x -> combo.addItemToolTip(UtilsText.safeString((String)((String)x.getKey())), (String)x.getValue()));
        SettingValue value = config.getSettingsConfig().getSettingValue(setting);
        combo.select(value.getUiValue());
    }

    static void updateGlobalSettingsState(@NonNull InstantSearchList combo, @NonNull AGlobalSetting setting, @NonNull IClocksConfig config) {
        SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)combo, setting.getToolTipText(config));
        combo.setEnabled(setting.isEnabled(config) && setting.isEditable(config));
        SettingValue value = SettingProvider.getValueBySettingId(setting.getId(), config.getMcu(), config.getSettingsConfig());
        if (value != null) {
            Color comboBg = setting.isValid(value, config) ? null : ToolsColors.SwToolsColors.ERROR_BG.getColor();
            combo.setBackground(comboBg);
            combo.setForeground(setting.isValid(value, config) ? combo.getDisplay().getSystemColor(21) : ToolsColors.SwToolsColors.ERROR_FG.getColor());
        }
    }

    public boolean isToolSpecificPropertiesValid(@NonNull ToolFunctionModification function, @NonNull List<@NonNull ToolFunctionModification> functions) {
        return true;
    }

    public void update(@NonNull List<@NonNull ToolFunctionModification> toolFunctions) {
        GuiController controller = GuiController.getInstance();
        IClocksProfile profile = controller.getProfile();
        profile.removeAllConfigs();
        toolFunctions.forEach(x -> {
            if (!(x.getOriginalFunction() instanceof IClocksConfig)) {
                LOGGER.warning("Can't update Clocks Functional Group with name: " + x.getName());
            } else {
                IClocksConfig config = (IClocksConfig)x.getOriginalFunction();
                config.setCalledFromDefaultInit(x.isCalledFromDefaultInit());
                config.setName(x.getName());
                config.setDescription(x.getDescription());
                config.recompute(null);
                profile.addConfig(config);
                if (config == profile.getActiveConfig()) {
                    profile.setActiveConfig(config);
                }
            }
        });
        profile.regenerateCode();
        controller.fireListeners(new ToolEvent.Builder(-1).setOriginator((Object)this).build());
    }

    public String getReservedFunctionName() {
        return "BOARD_InitBootClocks";
    }

    public @NonNull IToolFunction createNewFunction(@NonNull String functionName) {
        IClocksProfile profile = GuiController.getInstance().getProfile();
        IClocksConfig newDefaultConfig = profile.createDefaultConfig();
        newDefaultConfig.setCalledFromDefaultInit(false);
        newDefaultConfig.setName(functionName);
        newDefaultConfig.setDescription("");
        return newDefaultConfig;
    }

    public int getMaxToolFunctions() {
        return 20;
    }

    public @NonNull String getDefaultFunctionName() {
        return "ClocksFunc_";
    }

    public @NonNull IToolFunction copyFunction(@NonNull ToolFunctionModification functionToCopy) {
        IClocksConfig originalFunction = (IClocksConfig)functionToCopy.getOriginalFunction();
        IClocksConfig newFunction = originalFunction.clone(originalFunction.getClocksModel());
        return newFunction;
    }

    public @Nullable StorageTool getStorageTool() {
        return SWToolsPlatform.getSharedConfigurationSingleton().getTools().getClock();
    }
}

