/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.table;

import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.SettingProvider;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.table.ISettingNode;
import com.nxp.swtools.clocks.ui.table.SettingNode;
import com.nxp.swtools.clocks.ui.table.SettingsFilter;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class SettingsInput {
    private List<@NonNull ISettingNode> roots;

    public SettingsInput(@NonNull Collection<@NonNull ISettingNode> settings) {
        this.roots = new ArrayList<ISettingNode>(settings);
    }

    public SettingsInput(@NonNull Map<String, Collection<ISetting>> settings) {
        this.roots = new ArrayList<ISettingNode>();
        for (Map.Entry<String, Collection<ISetting>> entry : settings.entrySet()) {
            String group = entry.getKey();
            Collection<ISetting> groupSettingsCollection = entry.getValue();
            assert (group != null && groupSettingsCollection != null);
            ISettingNode[] groupSettings = SettingsInput.toSettingNodes(groupSettingsCollection);
            SettingNode settingGroup = new SettingNode(group, groupSettings);
            ISettingNode[] iSettingNodeArray = groupSettings;
            int n = groupSettings.length;
            int n2 = 0;
            while (n2 < n) {
                ISettingNode settingRow = iSettingNodeArray[n2];
                settingRow.setParent(settingGroup);
                ++n2;
            }
            this.roots.add(settingGroup);
        }
    }

    public SettingsInput() {
        this.roots = new ArrayList<ISettingNode>();
    }

    public static @NonNull SettingsInput fromSettings(@NonNull Collection<@NonNull ISetting> settings) {
        SettingsInput input = new SettingsInput();
        input.roots = new ArrayList<ISettingNode>();
        for (ISetting setting : settings) {
            SettingNode settingRow = new SettingNode(setting, new ISettingNode[0]);
            input.roots.add(settingRow);
        }
        return input;
    }

    public static @NonNull SettingsInput fromElement(@NonNull IClockElement element, @NonNull IClocksConfig config) {
        return SettingsInput.fromElements(Arrays.asList(element), config);
    }

    public static @NonNull SettingsInput fromComponent(@NonNull IClockComponent component, @NonNull IClocksConfig config) {
        SettingsInput result = SettingsInput.fromElements(component.getElements(), config);
        component.getGlobalConfigElements().forEach(x -> result.addSetting(x.getSetting(), 0));
        return result;
    }

    public static @NonNull SettingsInput fromMcu(@NonNull IClocksConfig config) {
        SettingsInput result = SettingsInput.fromElements(new ArrayList<IClockElement>(config.getMcu().getAllElements().values()), config);
        SettingsInput.appendGlobalSettings(result, config);
        return result;
    }

    public static @NonNull SettingsInput fromPathToElement(@NonNull IClockElement element, @NonNull IClocksConfig config) {
        HashSet<@NonNull E> globalSettingsOnPath = new HashSet();
        List<@NonNull IClockElement> elements = config.getPathToOutput(element.getID());
        elements.forEach(x -> {
            IClockComponent component = x.getParentComponent(config.getMcu());
            if (component != null) {
                component.getGlobalConfigElements().forEach(c -> {
                    boolean bl = globalSettingsOnPath.add(c.getSetting());
                });
            }
        });
        ArrayList<@NonNull IClockElement> elementsToShow = new ArrayList<IClockElement>();
        elementsToShow.addAll(elements);
        Collections.reverse(elementsToShow);
        SettingsInput result = SettingsInput.fromElements(elements, config);
        globalSettingsOnPath.forEach(x -> result.addSetting((ISetting)x, 0));
        return result;
    }

    private static void appendGlobalSettings(SettingsInput input, IClocksConfig config) {
        ArrayList<@NonNull AGlobalSetting> globalSettings = new ArrayList<AGlobalSetting>(config.getMcu().getSettings().getGlobalSettings());
        Collections.reverse(globalSettings);
        globalSettings.forEach(x -> input.addSetting((ISetting)x, 0));
    }

    public void addSetting(@NonNull ISetting setting, int pos) {
        this.roots.add(pos, new SettingNode(setting, null));
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull SettingsInput fromElements(@NonNull Collection<@NonNull IClockElement> elements, @NonNull IClocksConfig config) {
        ArrayList<@NonNull ISettingNode> rootNodes = new ArrayList<ISettingNode>();
        for (IClockElement element : elements) {
            @NonNull List elementSettings = (List)element.getSettings().stream().filter(setting -> setting.isVisible(config)).collect(CollectorsUtils.toList());
            if (elementSettings.isEmpty()) {
                rootNodes.add(new SettingNode.Builder(element.getOutputFrequencySetting()).build());
                continue;
            }
            ISetting frequencyModifier = element.getMainSetting();
            SettingNode.Builder builder = null;
            builder = frequencyModifier != null ? new SettingNode.Builder(frequencyModifier) : new SettingNode.Builder(element.getID());
            for (ISetting setting2 : elementSettings) {
                if (setting2 == frequencyModifier) continue;
                builder.addChild(new SettingNode(setting2, null));
            }
            if (element.isPowerModeSpecific()) {
                SettingNode node = SettingsInput.createPowerModeSpecificNode(config, element);
                builder.addChild(node);
            }
            rootNodes.add(builder.build());
        }
        return new SettingsInput(rootNodes);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull SettingNode createPowerModeSpecificNode(@NonNull IClocksConfig config, @NonNull IClockElement element) {
        ArrayList<@NonNull SettingNode> settings = new ArrayList<SettingNode>();
        SettingValue currentPowerMode = SettingProvider.getValueBySettingId("powerMode", config.getMcu(), config.getSettingsConfig());
        assert (currentPowerMode != null);
        @NonNull List powerModeSpecific = (List)element.getPowerModeSpecificSettings().stream().filter(x -> x.getPowerMode() != null && !Objects.equals(currentPowerMode.getUiValue(), x.getPowerMode())).collect(CollectorsUtils.toList());
        @Nullable Set settingsPowerModes = (Set)powerModeSpecific.stream().map(m -> m.getPowerMode()).collect(CollectorsUtils.toSet());
        if (powerModeSpecific.size() == 1) {
            ISetting setting = (ISetting)powerModeSpecific.get(0);
            settings.add(new SettingNode(setting, null));
        } else {
            settingsPowerModes.forEach(pMode -> {
                ArrayList<@NonNull E> arrayNode = new ArrayList();
                powerModeSpecific.forEach(pModeSetting -> {
                    @NonNull String powerMode = pModeSetting.getPowerMode();
                    if (powerMode != null && powerMode.equals(pMode)) {
                        arrayNode.add(new SettingNode((ISetting)pModeSetting, null));
                    }
                });
                if (pMode != null) {
                    settings.add(new SettingNode((String)pMode, (ISettingNode[])arrayNode.toArray(new SettingNode[arrayNode.size()])));
                }
            });
        }
        SettingNode node = new SettingNode(UtilsText.safeString((String)Messages.get().SettingsInput_PowerModeSpecific), (ISettingNode[])settings.toArray(new SettingNode[settings.size()]));
        return node;
    }

    public ISettingNode @NonNull [] getRoots() {
        @NonNull ISettingNode[] result = new ISettingNode[this.roots.size()];
        this.roots.toArray(result);
        return result;
    }

    public static @NonNull ISettingNode @NonNull [] toArray(@NonNull Collection<@NonNull ISettingNode> collection) {
        @NonNull ISettingNode[] array = new ISettingNode[collection.size()];
        array = collection.toArray(array);
        assert (array != null);
        return array;
    }

    private static @NonNull ISettingNode @NonNull [] toSettingNodes(@NonNull Collection<@NonNull ISetting> collection) {
        @NonNull ISettingNode[] array = new ISettingNode[collection.size()];
        int pos = 0;
        for (ISetting setting : collection) {
            SettingNode settingRow = new SettingNode(setting, new ISettingNode[0]);
            array[pos] = settingRow;
            ++pos;
        }
        return array;
    }

    public void removeSettings(@NonNull SettingsFilter filter) {
        this.roots.removeIf(x -> {
            ISetting setting = x.getSetting();
            if (setting != null) {
                return !filter.testSetting(setting);
            }
            boolean testChild = false;
            ISettingNode[] children = x.getChildren();
            if (children != null) {
                int i = 0;
                while (i < children.length) {
                    ISettingNode childNode = children[i];
                    ISetting childSetting = childNode.getSetting();
                    if (childSetting != null) {
                        testChild |= filter.testSetting(childSetting);
                    }
                    ++i;
                }
            }
            return !testChild;
        });
    }
}

