/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.table;

import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.ui.table.ISettingNode;
import com.nxp.swtools.clocks.ui.table.SettingsInput;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SettingNode
implements ISettingNode {
    @NonNull
    private String id;
    private ISettingNode @Nullable [] settings;
    @Nullable
    private ISettingNode parent;
    @Nullable
    private ISetting setting;

    public SettingNode(@NonNull ISetting setting, ISettingNode @Nullable [] settings) {
        this(setting.getId(), settings);
        this.setting = setting;
    }

    public SettingNode(@NonNull String id, ISettingNode @Nullable [] settings) {
        this.id = id;
        this.settings = settings;
        if (settings != null) {
            ISettingNode[] iSettingNodeArray = settings;
            int n = settings.length;
            int n2 = 0;
            while (n2 < n) {
                ISettingNode child = iSettingNodeArray[n2];
                child.setParent(this);
                ++n2;
            }
        }
    }

    public SettingNode(@NonNull String id, @NonNull ISetting setting, ISettingNode @Nullable [] settings) {
        this(id, settings);
        this.setting = setting;
    }

    @Override
    public ISettingNode[] getChildren() {
        return this.settings;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ISettingNode getParent() {
        return this.parent;
    }

    @Override
    public void setParent(ISettingNode parent) {
        this.parent = parent;
    }

    @Override
    public @Nullable ISetting getSetting() {
        return this.setting;
    }

    @Override
    public @Nullable IClockElement getClockElement() {
        if (this.setting != null) {
            IElement settingElement = this.setting.getElement();
            if (settingElement instanceof IClockElement) {
                return (IClockElement)settingElement;
            }
            if (this.parent != null) {
                return this.parent.getClockElement();
            }
        }
        return null;
    }

    public static class Builder {
        @Nullable
        private ISetting setting;
        @Nullable
        private String id;
        @NonNull
        private @NonNull List<@NonNull ISettingNode> children = new ArrayList<ISettingNode>();

        public Builder(@NonNull String id, @NonNull ISetting setting) {
            this.id = id;
            this.setting = setting;
        }

        public Builder(@NonNull ISetting setting) {
            this.setting = setting;
        }

        public Builder(@NonNull String id) {
            this.id = id;
        }

        public Builder addChildren(@NonNull Collection<@NonNull ISettingNode> childs) {
            this.children.addAll(childs);
            return this;
        }

        public Builder addChild(@NonNull ISettingNode child) {
            this.children.add(child);
            return this;
        }

        public @NonNull SettingNode build() {
            String nameLoc = this.id;
            ISetting settingLoc = this.setting;
            if (nameLoc != null) {
                if (settingLoc != null) {
                    return new SettingNode(nameLoc, settingLoc, SettingsInput.toArray(this.children));
                }
                return new SettingNode(nameLoc, SettingsInput.toArray(this.children));
            }
            assert (settingLoc != null);
            return new SettingNode(settingLoc, SettingsInput.toArray(this.children));
        }
    }
}

