/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.events;

import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.EmptyMcu;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksProfile;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.SettingsConfig;
import com.nxp.swtools.clocks.data.model.SettingsDB;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.SettingValueDialog;
import com.nxp.swtools.clocks.ui.SettingsDialog;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.table.SettingsInput;
import com.nxp.swtools.common.ui.utils.perspectives.PerspectivesHelper;
import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.configuration.logging.UserLogger;
import com.nxp.swtools.provider.analytics.ActionAnalyticsBuilder;
import com.nxp.swtools.provider.configuration.ISharedConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksTool;
import com.nxp.swtools.utils.ConfigurationUtils;
import com.nxp.swtools.utils.command.BoardResetDialog;
import com.nxp.swtools.utils.command.ResetToProcessorDefaultsDialog;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class GuiController {
    @NonNull
    protected static final Map<Display, GuiController> CONTROLLERS = new ConcurrentHashMap<Display, GuiController>();
    @NonNull
    private final Map<IEventListener, Integer> listeners = new LinkedHashMap<IEventListener, Integer>();
    @Nullable
    private String selectedOutputId = null;
    @Nullable
    private String selectedElementId = null;
    @NonNull
    private final UiController uiController;
    @NonNull
    private final SettingsDialog.DialogHolder<@Nullable SettingsDialog> settingsDialogHolder;
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(GuiController.class);
    @NonNull
    private IProgressService progressService;

    private GuiController(@NonNull UiController uiController) {
        this.uiController = uiController;
        this.settingsDialogHolder = new SettingsDialog.DialogHolder();
        IProgressService pService = (IProgressService)PlatformUI.getWorkbench().getService(IProgressService.class);
        if (Objects.isNull(pService)) {
            throw new IllegalStateException("Could not obtain progress services");
        }
        this.progressService = Objects.requireNonNull(pService);
    }

    public static @NonNull GuiController getInstance() {
        Display display = Display.getCurrent();
        if (display == null) {
            throw new IllegalStateException("Current display is null");
        }
        return GuiController.getInstance(display);
    }

    public static boolean isInitialized() {
        Display display = Display.getCurrent();
        return display != null && CONTROLLERS.containsKey(display);
    }

    public static @NonNull GuiController getInstance(@NonNull Display display) {
        GuiController controller = CONTROLLERS.get(display);
        if (controller == null) {
            controller = GuiController.createFor(display);
        }
        return controller;
    }

    public @Nullable List<@NonNull IClockElement> getActiveElementsPath() {
        IClocksConfig activeConfig = this.uiController.getProfile().getActiveConfig();
        List<@NonNull IClockElement> result = null;
        String outputId = this.selectedOutputId;
        if (activeConfig != null && outputId != null) {
            result = activeConfig.getPathToOutput(outputId);
        }
        return result;
    }

    public @Nullable List<@NonNull IClockElement> getElementsPathTo(@NonNull String outputId) {
        IClocksConfig activeConfig = this.uiController.getProfile().getActiveConfig();
        List<@NonNull IClockElement> result = null;
        if (activeConfig != null) {
            result = activeConfig.getPathToOutput(outputId);
        }
        return result;
    }

    public @Nullable String getErrorText() {
        IClocksConfig activeConfig = this.uiController.getProfile().getActiveConfig();
        if (activeConfig != null) {
            return activeConfig.getErrorText();
        }
        return null;
    }

    public void setActiveOutput(@NonNull String outputId, @Nullable Object originator) {
        this.selectedOutputId = outputId;
        this.fireListeners(new ToolEvent.Builder(4).setOriginator(originator).build());
    }

    public @Nullable String getActiveOutput() {
        return this.selectedOutputId;
    }

    public @Nullable IClockElement getSourceForActiveOutput() {
        IClocksConfig activeConfig = this.uiController.getProfile().getActiveConfig();
        String outputId = this.selectedOutputId;
        if (activeConfig != null && outputId != null) {
            return activeConfig.getInputFeeding(outputId);
        }
        return null;
    }

    public @NonNull Collection<@NonNull IClockElement> getAssociatedOutputs() {
        IClockElement activeInput;
        IClocksConfig activeConfig = this.uiController.getProfile().getActiveConfig();
        if (activeConfig != null && (activeInput = this.getSourceForActiveOutput()) != null) {
            return activeConfig.getOutputsFedBy(activeInput.getID());
        }
        return new ArrayList<IClockElement>(0);
    }

    public void setSelectedElement(@Nullable String elementId, @Nullable Object originator) {
        IClockElement clockElement;
        this.selectedElementId = elementId;
        if (elementId != null && (clockElement = this.getClockElementById(elementId)) instanceof ClockOutput) {
            this.setActiveOutput(elementId, originator);
        }
        this.fireListeners(new ToolEvent.Builder(8).setOriginator(originator).build());
    }

    public @Nullable String getSelectedElement() {
        return this.selectedElementId;
    }

    public void addListener(int eventTypes, @NonNull IEventListener listener) {
        Integer mask = this.listeners.get(listener);
        mask = mask == null ? Integer.valueOf(eventTypes) : Integer.valueOf(mask | eventTypes);
        this.listeners.put(listener, mask);
    }

    public void removeModelListener(int eventTypes, @NonNull IEventListener listener) {
        Integer mask = this.listeners.get(listener);
        if (mask != null) {
            if ((mask = Integer.valueOf(mask & ~eventTypes)) == 0) {
                this.listeners.remove(listener);
            } else {
                this.listeners.put(listener, mask);
            }
        }
    }

    public void removeModelListener(@NonNull IEventListener listener) {
        this.listeners.remove(listener);
    }

    public void fireListeners(@NonNull ToolEvent event) {
        this.fireListeners(event, true);
    }

    protected void fireListeners(@NonNull ToolEvent event, boolean fireUiController) {
        if (fireUiController) {
            this.uiController.fireListeners(event);
        } else {
            for (Map.Entry<IEventListener, Integer> entry : this.listeners.entrySet()) {
                IEventListener listener = entry.getKey();
                Integer mask = entry.getValue();
                if ((mask & event.type) == 0) continue;
                listener.handle(event);
            }
        }
    }

    private static @NonNull GuiController createFor(final @NonNull Display display) {
        if (CONTROLLERS.containsKey(display)) {
            throw new IllegalStateException("GuiController for current display has already been created");
        }
        final UiController uiController = UiController.getInstance();
        final GuiController controller = new GuiController(uiController);
        CONTROLLERS.put(display, controller);
        uiController.addListener(-1, new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (!display.isDisposed()) {
                    if (display.getThread().equals(Thread.currentThread())) {
                        controller.fireListeners(event, false);
                    } else {
                        UIJobHelper.runUIJob(() -> controller.fireListeners(event, false), (String)"Refresh", (boolean)false, (Display)display);
                    }
                }
            }
        });
        controller.addListener(64, x -> controller.logMCU());
        display.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                CONTROLLERS.remove(display);
                uiController.dispose();
            }
        });
        return controller;
    }

    void logMCU() {
        IClocksConfig activeConfig = this.getProfile().getActiveConfig();
        if (activeConfig != null) {
            IMcu mcu = activeConfig.getMcu();
            if (mcu instanceof EmptyMcu) {
                LOGGER.info(mcu.getDefaultConfig().getErrorText());
            }
        } else {
            LOGGER.severe("No active configuration found!");
        }
    }

    public boolean removeActiveConfig() {
        IClocksConfig config = this.getProfile().getActiveConfig();
        return config == null ? false : this.removeConfig(config);
    }

    public boolean removeConfig(@NonNull IClocksConfig config) {
        if (this.askUserRemove(config)) {
            IClocksProfile profile = this.getProfile();
            IClocksConfig activeConfig = profile.removeConfig(config);
            if (activeConfig != null) {
                profile.setActiveConfig(activeConfig);
            }
            profile.regenerateCode();
            ToolEvent event = new ToolEvent.Builder(130).build();
            this.fireListeners(event);
            return true;
        }
        return false;
    }

    public boolean askUserRemove(@NonNull IClocksConfig config) {
        MessageDialog dialog = new MessageDialog(GuiController.getActiveShell(), Messages.get().GuiController_RemoveConfigDialogTitle, null, MessageFormat.format(Messages.get().GuiController_RemoveConfigDialogMessage, config.getName()), 3, new String[]{Messages.get().GuiController_RemoveConfigButtonPositive, Messages.get().GuiController_RemoveConfigButtonNegative}, 0);
        int result = dialog.open();
        return result == 0;
    }

    public @NonNull Collection<@NonNull ISetting> removeLocksActivePath() {
        List<@NonNull IClockElement> path = this.getActiveElementsPath();
        HashSet<@NonNull ISetting> result = new HashSet<ISetting>();
        IClocksProfile profile = this.uiController.getProfile();
        IClocksConfig activeConfig = profile.getActiveConfig();
        if (path != null && activeConfig != null) {
            for (IClockElement elem : path) {
                List<@NonNull ISetting> settingList = elem.getSettings();
                for (ISetting setting : settingList) {
                    if (!setting.isUserLockable() || !activeConfig.isLocked(setting)) continue;
                    activeConfig.unlockSetting(setting, false);
                    result.add(setting);
                }
            }
            activeConfig.recompute(null);
            profile.regenerateCode();
            this.fireListeners(new ToolEvent.Builder(18).build());
        }
        return result;
    }

    public @NonNull Collection<@NonNull ISetting> removeAllLocks() {
        HashSet<@NonNull ISetting> result = new HashSet<ISetting>();
        IClocksProfile profile = this.uiController.getProfile();
        IClocksConfig activeConfig = profile.getActiveConfig();
        if (activeConfig != null) {
            IMcu mcu = activeConfig.getMcu();
            SettingsDB settingsDB = mcu.getSettings();
            for (ISetting setting : settingsDB.getAllSettings()) {
                if (!setting.isUserLockable() || !activeConfig.isLocked(setting)) continue;
                activeConfig.unlockSetting(setting, false);
                result.add(setting);
            }
            activeConfig.recompute(null);
            profile.regenerateCode();
            this.fireListeners(new ToolEvent.Builder(18).build());
        }
        return result;
    }

    public @NonNull IClocksProfile getProfile() {
        return this.uiController.getProfile();
    }

    public void setProfile(@NonNull IClocksProfile profile) {
        this.uiController.setProfile(profile);
    }

    public boolean isSomeSettingLockedOnPath() {
        if (this.selectedOutputId == null) {
            return false;
        }
        List<@NonNull IClockElement> path = this.getActiveElementsPath();
        IClocksProfile profile = this.uiController.getProfile();
        IClocksConfig activeConfig = profile.getActiveConfig();
        if (path != null && activeConfig != null) {
            for (IClockElement elem : path) {
                List<@NonNull ISetting> settingList = elem.getSettings();
                for (ISetting setting : settingList) {
                    if (!setting.isUserLockable() || !activeConfig.isLocked(setting)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isSomeSettingLocked() {
        IClocksProfile profile = this.uiController.getProfile();
        IClocksConfig activeConfig = profile.getActiveConfig();
        if (activeConfig != null) {
            return activeConfig.isSomeSettingLocked();
        }
        return false;
    }

    public @NonNull UserLogger getUserLogger() {
        return UserLogger.getInstance();
    }

    public @NonNull SettingsDialog.DialogHolder<@Nullable SettingsDialog> getSettingsDialogHolder() {
        return this.settingsDialogHolder;
    }

    public @Nullable IClocksConfig tryCreateConfig(@Nullable IClocksConfig original, @Nullable String proposedName, @Nullable String description) {
        return this.uiController.tryCreateConfig(original, proposedName, description, false);
    }

    public boolean canAddConfig() {
        return this.uiController.canAddConfig();
    }

    public static @NonNull Shell getActiveShell() {
        Display display = Display.getCurrent();
        assert (display != null);
        Shell activeShell = display.getActiveShell();
        if (activeShell == null) {
            throw new IllegalStateException("No active shell found!");
        }
        return activeShell;
    }

    public @NonNull SettingsInput createSettingsInput(@Nullable String idToCreateInputFor) {
        String idLoc = idToCreateInputFor;
        IClocksProfile profile = this.getProfile();
        IClocksConfig activeConfig = profile.getActiveConfig();
        SettingsInput settingsInput = SettingsInput.fromSettings(new ArrayList<ISetting>(0));
        if (activeConfig != null) {
            IClockElement foundElement;
            IMcu mcu = profile.getMcu();
            IClockElement iClockElement = foundElement = idLoc == null ? null : mcu.getClockElement(idLoc);
            if (foundElement != null) {
                settingsInput = foundElement instanceof ClockOutput ? SettingsInput.fromPathToElement(foundElement, activeConfig) : SettingsInput.fromElement(foundElement, activeConfig);
            } else {
                IClockComponent foundComponent = idLoc == null ? null : mcu.getClockComponent(idLoc);
                settingsInput = foundComponent != null ? SettingsInput.fromComponent(foundComponent, activeConfig) : SettingsInput.fromMcu(activeConfig);
            }
        }
        return settingsInput;
    }

    public void setUserEnableStateOf(@NonNull ISetting setting, @NonNull IClocksConfig config, boolean enable, @Nullable Shell shell) {
        if (enable != setting.isUserEnabled(config)) {
            this.changeUserEnableStateOf(setting, config, shell);
        }
    }

    public void changeUserEnableStateOf(@NonNull ISetting setting, @NonNull IClocksConfig config, @Nullable Shell shell) {
        if (!setting.isUserEnableable()) {
            return;
        }
        SettingsConfig settingsConfig = config.getSettingsConfig();
        LockState lockState = settingsConfig.getLockState(setting);
        SettingValue currentValue = settingsConfig.getSettingValue(setting);
        boolean isUserEnabled = setting.isUserEnabled(config);
        if (!isUserEnabled && (lockState != null && lockState.getValue().isUndefined() || lockState == null && currentValue.isUndefined())) {
            Shell activeShell = shell != null ? shell : GuiController.getActiveShell();
            SettingValueDialog settingValueDialog = SettingEditorHelper.createSettingValueInputDialog(setting, config, activeShell);
            settingValueDialog.open();
            currentValue = settingValueDialog.getValue();
        } else if (lockState != null) {
            currentValue = lockState.getValue();
        }
        if (currentValue != null) {
            config.setSettingValue(setting, currentValue, false, true);
            settingsConfig.setUserEnabled(setting, !isUserEnabled);
            config.recompute(setting);
            this.getProfile().regenerateCode();
            this.fireListeners(new ToolEvent.Builder(2).build());
        }
    }

    public boolean runBlocking(@NonNull IRunnableWithProgress runnable) {
        try {
            this.progressService.busyCursorWhile(runnable);
            return true;
        }
        catch (InterruptedException | InvocationTargetException e) {
            LOGGER.log(Level.WARNING, "Exception occured while running " + runnable, e);
            return false;
        }
    }

    public void resetToStorageConfig(@NonNull IClocksConfig config) {
        this.uiController.runTransaction(() -> {
            IClocksProfile profile = GuiController.getInstance().getProfile();
            Shell parentShell = GuiController.getActiveShell();
            String kitOrBoard = profile.getKit() != null ? profile.getKit() : profile.getBoard();
            ISharedConfiguration sharedConfig = ConfigurationUtils.loadBoardConfiguration((String)kitOrBoard, (String)profile.getMcuDescriptor().getSDKVersion());
            if (sharedConfig != null) {
                StorageClocksTool clocks = sharedConfig.getTools().getClock();
                if (clocks != null) {
                    BoardResetDialog dialog = new BoardResetDialog(parentShell, (Collection)clocks.getConfigurations().stream().map(x -> x.getConfigurationName()).collect(CollectorsUtils.toList()), config.getName());
                    if (dialog.open() == 0) {
                        StorageClocksConfiguration boardConfig = null;
                        for (StorageClocksConfiguration storageConfig : clocks.getConfigurations()) {
                            if (!Objects.equals(storageConfig.getConfigurationName(), dialog.getSelectedConfiguration())) continue;
                            boardConfig = storageConfig;
                        }
                        if (boardConfig != null) {
                            profile.resetToStorageConfig(config, boardConfig);
                            profile.regenerateCode();
                            ToolEvent uiEvent = new ToolEvent.Builder(18).build();
                            GuiController.getInstance().fireListeners(uiEvent);
                        }
                    }
                } else {
                    LOGGER.severe("Can't load storage configuration to reset board defaults");
                }
            } else {
                LOGGER.severe("Unable to load shared configuration to reset board defaults");
            }
        });
    }

    public void resetToDefaults(@NonNull IClocksConfig config) {
        this.uiController.runTransaction(() -> {
            Shell parentShell = GuiController.getActiveShell();
            int result = ResetToProcessorDefaultsDialog.open((Shell)parentShell, (String)config.getName());
            if (result == 0) {
                IClocksProfile profile = GuiController.getInstance().getProfile();
                profile.resetToDefaults(config);
                profile.regenerateCode();
                ToolEvent uiEvent = new ToolEvent.Builder(18).build();
                GuiController.getInstance().fireListeners(uiEvent);
            }
        });
    }

    public void openShellWithSettingsOf(@Nullable String id) {
        if (SettingsDialog.numOfOpened() < 20) {
            Shell shell = GuiController.getActiveShell();
            if (!shell.isDisposed()) {
                SettingsDialog.getFor(id, shell).open();
            }
        } else {
            MessageDialog.openError((Shell)GuiController.getActiveShell(), (String)Messages.get().DiagramView_MaxNumDialogsReached_Title, (String)MessageFormat.format(Messages.get().DiagramView_MaxNumDialogsReached_Message, 20));
        }
    }

    public void openShellWithSettingsOfSelectedElement() {
        this.openShellWithSettingsOf(this.getSelectedElement());
    }

    public @NonNull IAction createToolbarAction(@NonNull String image, @Nullable String tooltip, @NonNull String actionId, @NonNull Runnable callback) {
        return this.createToolbarAction(image, tooltip, actionId, 1, callback);
    }

    public @NonNull IAction createToolbarAction(@NonNull String image, @Nullable String tooltip, @NonNull String actionId, int style, @NonNull Runnable callback) {
        ImageDescriptor actionImage = ToolsImages.getImageDescriptor((String)image);
        assert (actionImage != null);
        return ActionAnalyticsBuilder.action((Runnable)callback).id(actionId).style(style).text(tooltip).tooltip(UtilsText.safeString((String)tooltip)).image(actionImage).build();
    }

    public void setConfigOfDefaultInit(@Nullable IClocksConfig config) {
        this.uiController.setConfigOfDefaultInit(config);
    }

    public @Nullable IClockElement getClockElementById(@NonNull String elmentId) {
        return this.uiController.getClockElementById(elmentId);
    }

    public @Nullable IClocksConfig getConfigOfDefaultInit() {
        return this.uiController.getConfigOfDefaultInit();
    }

    public static void showDetailsView() {
        PerspectivesHelper.showView((String)"com.nxp.swtools.clocks.DetailsView");
    }

    public boolean isEnabled() {
        return this.uiController.isEnabled();
    }

    public void findNearValueOrRestore(@NonNull ISetting setting, @NonNull IClocksConfig config, @NonNull SettingValue value) {
        this.uiController.findNearValueOrRestore(setting, config, GuiController.getActiveShell(), value);
    }
}

