/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.resources.DataDirectory;
import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagramsymbols.Color;
import com.nxp.swtools.clocks.ui.diagramsymbols.Font;
import com.nxp.swtools.clocks.ui.diagramsymbols.Lock;
import com.nxp.swtools.clocks.ui.diagramsymbols.Text;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class TextField
extends Text {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(TextField.class);
    @NonNull
    private String mId;
    protected static final double FONT_HEIGHT = Rap.isActive() || SWToolsProperties.isHeadlessOn() ? 12.0 : TextField.findFontSize(12.0);
    protected static final int FONT_SCREEN_HEIGHT = 14;
    protected static final double LOCK_WIDTH = 1.0;
    protected static final double LOCK_SPACING = 0.5;
    protected static final double LOCK_OFFSET = 0.8;
    @NonNull
    protected static final String FONT_NAME = "Roboto Condensed";
    @NonNull
    protected static final String FONT_FILE_LOC = "RobotoCondensed" + File.separator + "RobotoCondensed-Regular.ttf";
    protected boolean mIsLocked;
    @NonNull
    protected Lock mLock;

    static {
        String fullPath = String.valueOf(DataDirectory.getFontsDirectory()) + File.separator + FONT_FILE_LOC;
        if (SWToolsProperties.isHeadlessOn()) {
            LOGGER.fine("Cannot load font due to headless mode");
        } else if (Platform.isRunning()) {
            SWTFactoryProxy.INSTANCE.loadFont(fullPath);
        } else {
            LOGGER.warning("Cannot load font due to inactive workbench");
        }
    }

    public static void init() {
    }

    public TextField(@NonNull String id, @NonNull Point2D position, @NonNull String text) {
        super(position, text, new Font(FONT_NAME, new Color(0, 0, 0), (int)FONT_HEIGHT));
        this.mId = id;
        this.mIsLocked = false;
        this.mLock = new Lock(new Point2D.Double(), 1.0);
        this.syncLockPosition();
    }

    @Override
    public boolean initialize() {
        boolean initialized = super.initialize();
        if (initialized) {
            this.syncLockPosition();
        }
        return initialized;
    }

    @Override
    protected TextField makeCopy() {
        Point2D.Double o = new Point2D.Double(this.mPosition.getX(), this.mPosition.getY());
        String text = new String(this.mText);
        TextField copy = new TextField(new String(this.mId), o, text);
        copy.setLock(this.mIsLocked);
        return copy;
    }

    @Override
    public void draw(@NonNull AffineTransform transform, @NonNull PaintEvent e, DiagramStyleProvider styleProvider) {
        super.draw(transform, e, styleProvider);
        if (this.mIsLocked) {
            this.mLock.draw(transform, e, styleProvider);
        }
    }

    private static double findFontSize(double defaultSize) {
        Display currentDisplay = Display.getCurrent();
        if (currentDisplay != null) {
            GC gc = new GC((Drawable)currentDisplay);
            int size = 0;
            Point stringExt = null;
            do {
                Font font = new Font(FONT_NAME, new Color(0, 0, 0), ++size);
                org.eclipse.swt.graphics.Font f = font.getSWTFont();
                gc.setFont(f);
                stringExt = gc.stringExtent("LOREM IPSUM");
                f.dispose();
            } while (stringExt.y <= 14);
            gc.dispose();
            return size;
        }
        return defaultSize;
    }

    @Override
    public @NonNull String getText() {
        return this.mText;
    }

    protected @NonNull Lock getLock() {
        return this.mLock;
    }

    public void updateText(@NonNull String text) {
        this.mText = text;
        if (this.isInitialized) {
            this.calculateSize();
            this.calculateBB();
        }
    }

    protected void syncLockPosition() {
        Point2D origPos = this.mLock.mPositionDS;
        Point2D.Double newPos = new Point2D.Double(this.mPosition.getX() - 1.0 - 0.5, this.mPosition.getY() + this.mStringHeight * 0.8);
        AffineTransform t = new AffineTransform();
        t.translate(((Point2D)newPos).getX() - origPos.getX(), ((Point2D)newPos).getY() - origPos.getY());
        this.mLock.applyTransform(t);
    }

    public void setLock(boolean isLocked) {
        this.mIsLocked = isLocked;
    }

    @Override
    public void applyTransform(@NonNull AffineTransform transformDS) {
        super.applyTransform(transformDS);
        this.mLock.applyTransform(transformDS);
    }

    @Override
    public boolean isHitBy(@NonNull Point2D p) {
        return this.mBoundingBoxDS.isHitBy(p);
    }
}

