/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.ui.diagram.DiagramCanvas;
import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagram.Style;
import com.nxp.swtools.clocks.ui.diagramsymbols.Font;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.common.utils.NonNull;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class Text
extends GraphicalElement {
    boolean isInitialized = false;
    @NonNull
    Point2D mPosition;
    @NonNull
    protected String mText;
    protected double mStringWidth;
    protected double mStringHeight;
    @NonNull
    protected Font mFont;
    protected static final double FONT_OFFSET = 0.9;
    protected static final double RAP_COEF = Rap.isActive() ? 0.75 : 1.0;

    public Text(@NonNull Point2D position, @NonNull String text, @NonNull Font font) {
        this.mPosition = position;
        this.mText = text;
        this.mFont = font;
        this.mPosition.setLocation(this.mPosition.getX(), this.mPosition.getY());
    }

    public boolean initialize() {
        if (this.isInitialized) {
            return true;
        }
        this.calculateSize();
        if (this.isInitialized) {
            this.mPosition.setLocation(this.mPosition.getX(), this.mPosition.getY() - this.mStringHeight * 0.9);
        }
        this.calculateBB();
        return this.isInitialized;
    }

    protected void calculateSize() {
        Display d = Display.getCurrent();
        if (d == null) {
            return;
        }
        this.isInitialized = true;
        GC gc = new GC((Drawable)d);
        org.eclipse.swt.graphics.Font f = this.mFont.getSWTFont();
        gc.setFont(f);
        Point stringExt = gc.stringExtent(this.mText);
        gc.dispose();
        f.dispose();
        this.mStringWidth = (double)stringExt.x / DiagramCanvas.DEFAULT_ZOOM / RAP_COEF;
        this.mStringHeight = (double)stringExt.y / DiagramCanvas.DEFAULT_ZOOM / RAP_COEF;
    }

    public int getFontSize(double zoom) {
        return (int)((double)this.mFont.getHeight() / DiagramCanvas.DEFAULT_ZOOM / RAP_COEF * zoom);
    }

    @Override
    public void draw(AffineTransform transform, PaintEvent e, DiagramStyleProvider styleProvider) {
        Point2D posCS = transform.transform(this.mPosition, null);
        int newFontSize = this.getFontSize(transform.getScaleX());
        Style style = styleProvider.getStyle(this, this.mDrawState);
        this.mFont.set(e, newFontSize);
        style.LineStyle.set(e);
        e.gc.drawString(this.mText, (int)posCS.getX(), (int)posCS.getY(), true);
        style.LineStyle.unset(e);
        this.mFont.unset(e);
    }

    @Override
    protected GraphicalElement makeCopy() {
        Point2D.Double o = new Point2D.Double(this.mPosition.getX(), this.mPosition.getY());
        String text = new String(this.mText);
        Text copy = new Text(o, text, this.mFont.makeCopy());
        return copy;
    }

    @Override
    public boolean isHitBy(Point2D p) {
        return false;
    }

    @Override
    public void applyTransform(AffineTransform transformDS) {
        transformDS.transform(this.mPosition, this.mPosition);
        this.calculateBB();
    }

    protected void calculateBB() {
        this.mBoundingBoxDS.setTopLeftCorner(this.mPosition.getX(), this.mPosition.getY());
        this.mBoundingBoxDS.setBottomRightCorner(this.mPosition.getX() + this.mStringWidth, this.mPosition.getY() + this.mStringHeight);
    }

    public @NonNull String getText() {
        return this.mText;
    }
}

