/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagramsymbols.BoundingBox;
import com.nxp.swtools.clocks.ui.diagramsymbols.CompositeSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.InvisibleConnectionSymbol;
import com.nxp.swtools.clocks.ui.diagramsymbols.Pin;
import com.nxp.swtools.clocks.ui.diagramsymbols.TextField;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class SymbolBuilder {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(SymbolBuilder.class);
    @NonNull
    protected List<GraphicalElement> mGraElems = new ArrayList<GraphicalElement>();
    @NonNull
    protected Point2D mRefPoint;

    public SymbolBuilder(@NonNull Point2D refPoint) {
        this.mRefPoint = refPoint;
    }

    public void addGraphElem(@NonNull GraphicalElement elem) {
        this.mGraElems.add(elem);
    }

    public @NonNull DiagramSymbol getCompositeSymbol(@NonNull String id, @NonNull Point2D pos, @NonNull DiagramSymbol.Orientation orientation, @NonNull Point2D scale, @NonNull Map<@NonNull String, @NonNull TextField> fields, @Nullable TextField outputFreqField, @Nullable TextField scaleField, boolean definesBoundary, boolean isDiagramOnly) {
        CompositeSymbol symbol = new CompositeSymbol(id, definesBoundary, true, isDiagramOnly);
        AffineTransform transformSSToDS = this.calculateTransform(pos, orientation, scale);
        this.fillSymbol(pos, fields, outputFreqField, scaleField, transformSSToDS, symbol);
        symbol.findPinConnection();
        return symbol;
    }

    public @NonNull InvisibleConnectionSymbol getInvisibleConnectionSymbol(@NonNull String id, @NonNull Point2D pos, @NonNull DiagramSymbol.Orientation orientation, @NonNull Point2D scale, @NonNull Map<@NonNull String, @NonNull TextField> fields) {
        List<@NonNull T> allPins = CollectionsUtils.getInstancesOf(this.mGraElems, Pin.class).collect(Collectors.toList());
        if (SWToolsProperties.isVerificationOn() && allPins.size() != 1) {
            LOGGER.severe("Exactly one pin expected for '" + id + "', but " + allPins.size() + " found.");
        }
        AffineTransform transformSSToDS = this.calculateTransform(pos, orientation, scale);
        Iterator iterator = allPins.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("No connection pin/s found!");
        }
        Pin connPin = ((Pin)iterator.next()).makeCopy();
        connPin.applyTransform(transformSSToDS);
        InvisibleConnectionSymbol symbol = new InvisibleConnectionSymbol(id, connPin);
        this.fillSymbol(pos, fields, transformSSToDS, symbol);
        return symbol;
    }

    private void fillSymbol(@NonNull Point2D pos, @NonNull Map<@NonNull String, @NonNull TextField> fields, @Nullable TextField outputFreqField, @Nullable TextField scaleField, @NonNull AffineTransform transformSSToDS, @NonNull CompositeSymbol symbol) {
        for (TextField f : fields.values()) {
            SymbolBuilder.transformField(pos, f);
            symbol.addGraphElem(f);
        }
        if (outputFreqField != null) {
            SymbolBuilder.transformField(pos, outputFreqField);
            symbol.setOutputFrequencyField(outputFreqField);
        }
        if (scaleField != null) {
            SymbolBuilder.transformField(pos, scaleField);
            symbol.setScaleField(scaleField);
        }
        for (GraphicalElement elem : this.mGraElems) {
            GraphicalElement newElement = elem.makeCopy();
            newElement.applyTransform(transformSSToDS);
            symbol.addGraphElem(newElement);
        }
    }

    private void fillSymbol(@NonNull Point2D pos, @NonNull Map<@NonNull String, @NonNull TextField> fields, @NonNull AffineTransform transformSSToDS, @NonNull InvisibleConnectionSymbol symbol) {
        for (TextField f : fields.values()) {
            SymbolBuilder.transformField(pos, f);
            symbol.addGraphElem(f);
        }
        this.mGraElems.stream().filter(x -> !(x instanceof Pin)).forEach(x -> {
            GraphicalElement newElement = x.makeCopy();
            newElement.applyTransform(transformSSToDS);
            symbol.addGraphElem(newElement);
        });
    }

    private @NonNull AffineTransform calculateTransform(@NonNull Point2D pos, @NonNull DiagramSymbol.Orientation orientation, @NonNull Point2D scale) {
        AffineTransform transformSSToDS = new AffineTransform();
        Point2D.Double refPoint = new Point2D.Double(this.mRefPoint.getX(), this.mRefPoint.getY());
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = Double.MIN_VALUE;
        double maxY = Double.MIN_VALUE;
        for (GraphicalElement elem : this.mGraElems) {
            BoundingBox bBox = elem.getBoundingBoxDS();
            Point2D topLeftCorner = bBox.getTopLeftCornerDS();
            Point2D bottomRightCorner = bBox.getBottomRightCornerDS();
            minX = Math.min(minX, topLeftCorner.getX());
            minY = Math.min(minY, topLeftCorner.getY());
            maxX = Math.max(maxX, bottomRightCorner.getX());
            maxY = Math.max(maxY, bottomRightCorner.getY());
        }
        switch (orientation) {
            case ROT_DOWN_MIRROR: 
            case ROT_DOWN: {
                transformSSToDS.rotate(Math.PI, pos.getX(), pos.getY());
                transformSSToDS.translate(((Point2D)refPoint).getX() - minX, ((Point2D)refPoint).getY() - minY);
                break;
            }
            case ROT_LEFT_MIRROR: 
            case ROT_LEFT: {
                transformSSToDS.rotate(-1.5707963267948966, pos.getX(), pos.getY());
                transformSSToDS.translate(((Point2D)refPoint).getX() - minX, 0.0);
                break;
            }
            case ROT_RIGHT: 
            case ROT_RIGHT_MIRROR: {
                transformSSToDS.rotate(1.5707963267948966, pos.getX(), pos.getY());
                transformSSToDS.translate(0.0, ((Point2D)refPoint).getY() - minY);
                break;
            }
        }
        switch (orientation) {
            case ROT_DOWN_MIRROR: 
            case ROT_LEFT_MIRROR: 
            case MIRROR: 
            case ROT_RIGHT_MIRROR: {
                transformSSToDS.scale(-1.0, 1.0);
                double translation = maxX + minX;
                transformSSToDS.translate(-translation, 0.0);
                ((Point2D)refPoint).setLocation(-((Point2D)refPoint).getX(), ((Point2D)refPoint).getY());
                pos.setLocation(-pos.getX(), pos.getY());
                break;
            }
        }
        transformSSToDS.translate(-((Point2D)refPoint).getX(), -((Point2D)refPoint).getY());
        transformSSToDS.translate(pos.getX(), pos.getY());
        transformSSToDS.translate(((Point2D)refPoint).getX(), ((Point2D)refPoint).getY());
        transformSSToDS.scale(scale.getX(), scale.getY());
        transformSSToDS.translate(-((Point2D)refPoint).getX(), -((Point2D)refPoint).getY());
        return transformSSToDS;
    }

    private static void transformField(@NonNull Point2D pos, @NonNull TextField f) {
        AffineTransform transform = AffineTransform.getTranslateInstance(pos.getX(), pos.getY());
        assert (transform != null);
        f.applyTransform(transform);
    }
}

