/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagram.Style;
import com.nxp.swtools.clocks.ui.diagramsymbols.DrawState;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.LineStyle;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.logging.Logger;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;

public class Pin
extends GraphicalElement {
    protected static final double DIRECTION_ARROW_X = 1.5;
    protected static final double DIRECTION_ARROW_Y = 1.0;
    protected static final double ARROW_HEIGHT = 2.0;
    protected static final double ARROW_LEFT_SIZE = 1.2;
    protected static final double ARROW_RIGHT_SIZE = 1.0;
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(Pin.class);
    boolean mInput;
    @NonNull
    Point2D mStartDS;
    @NonNull
    Point2D mEndDS;
    @NonNull
    protected Type mType;
    @NonNull
    protected Direction mDir;

    public Pin(@NonNull Point2D start, @NonNull Direction dir, double size, @NonNull Type type, boolean input) {
        this.mStartDS = start;
        this.mType = type;
        switch (dir) {
            case TO_DOWN: {
                this.mEndDS = new Point2D.Double(this.mStartDS.getX(), this.mStartDS.getY() + size);
                break;
            }
            case TO_LEFT: {
                this.mEndDS = new Point2D.Double(this.mStartDS.getX() - size, this.mStartDS.getY());
                break;
            }
            case TO_RIGHT: {
                this.mEndDS = new Point2D.Double(this.mStartDS.getX() + size, this.mStartDS.getY());
                break;
            }
            case TO_UP: {
                this.mEndDS = new Point2D.Double(this.mStartDS.getX(), this.mStartDS.getY() - size);
                break;
            }
            default: {
                this.mEndDS = new Point2D.Double(this.mStartDS.getX(), this.mStartDS.getY());
            }
        }
        this.mDir = dir;
        this.mInput = input;
        this.calculateBB();
    }

    public Pin(@NonNull Point2D start, @NonNull Point2D end, @Nullable Direction direction, @NonNull Type type, boolean input) {
        this.mStartDS = start;
        this.mEndDS = end;
        this.mType = type;
        this.mDir = direction == null ? this.getDir() : direction;
        this.mInput = input;
        this.calculateBB();
    }

    @Override
    public void draw(AffineTransform transform, PaintEvent e, DiagramStyleProvider styleProvider) {
        switch (this.mType) {
            case NORMAL: {
                this.drawNormal(transform, e, styleProvider);
                break;
            }
            case ARROW: {
                this.drawArrow(transform, e, styleProvider);
                break;
            }
            default: {
                LOGGER.warning((Object)((Object)this.mType) + " type of pin not supported. Pin will be drawn as normal");
                this.drawNormal(transform, e, styleProvider);
            }
        }
    }

    private void drawSignalDirection(@NonNull AffineTransform transform, @NonNull PaintEvent e, @NonNull Point2D pinPosition) {
        Point2D.Double bottom;
        Point2D.Double top;
        Point2D.Double base;
        double zoomX = transform.getScaleX();
        double zoomY = transform.getScaleY();
        switch (this.mDir) {
            case TO_UP: {
                base = new Point2D.Double(pinPosition.getX(), pinPosition.getY());
                top = new Point2D.Double(pinPosition.getX() - 1.0 * zoomX, pinPosition.getY() + 1.5 * zoomY);
                bottom = new Point2D.Double(pinPosition.getX() + 1.0 * zoomX, pinPosition.getY() + 1.5 * zoomY);
                break;
            }
            case TO_DOWN: {
                base = new Point2D.Double(pinPosition.getX(), pinPosition.getY());
                top = new Point2D.Double(pinPosition.getX() - 1.0 * zoomX, pinPosition.getY() - 1.5 * zoomY);
                bottom = new Point2D.Double(pinPosition.getX() + 1.0 * zoomX, pinPosition.getY() - 1.5 * zoomY);
                break;
            }
            case TO_LEFT: {
                base = new Point2D.Double(pinPosition.getX(), pinPosition.getY());
                top = new Point2D.Double(pinPosition.getX() + 1.5 * zoomX, pinPosition.getY() - 1.0 * zoomY);
                bottom = new Point2D.Double(pinPosition.getX() + 1.5 * zoomX, pinPosition.getY() + 1.0 * zoomY);
                break;
            }
            case TO_RIGHT: {
                base = new Point2D.Double(pinPosition.getX(), pinPosition.getY());
                top = new Point2D.Double(pinPosition.getX() - 1.5 * zoomX, pinPosition.getY() - 1.0 * zoomY);
                bottom = new Point2D.Double(pinPosition.getX() - 1.5 * zoomX, pinPosition.getY() + 1.0 * zoomY);
                break;
            }
            default: {
                return;
            }
        }
        Color bgColor = e.gc.getBackground();
        e.gc.setBackground(e.gc.getForeground());
        e.gc.fillPolygon(new int[]{(int)((Point2D)base).getX(), (int)((Point2D)base).getY(), (int)((Point2D)bottom).getX(), (int)((Point2D)bottom).getY(), (int)((Point2D)top).getX(), (int)((Point2D)top).getY()});
        e.gc.setBackground(bgColor);
    }

    protected void drawNormal(@NonNull AffineTransform transform, @NonNull PaintEvent e, @NonNull DiagramStyleProvider styleProvider) {
        Point2D startCS = transform.transform(this.mStartDS, null);
        Point2D endCS = transform.transform(this.mEndDS, null);
        Style style = styleProvider.getStyle(this, this.mDrawState);
        LineStyle lineStyle = style.LineStyle;
        lineStyle.set(e);
        e.gc.drawLine((int)startCS.getX(), (int)startCS.getY(), (int)endCS.getX(), (int)endCS.getY());
        if (this.mInput && style.isSignalDirectionEnabled) {
            int origLineCap = e.gc.getLineCap();
            e.gc.setLineCap(2);
            this.drawSignalDirection(transform, e, endCS);
            e.gc.setLineCap(origLineCap);
        }
        lineStyle.unset(e);
    }

    protected @NonNull Direction getDir() {
        double EPSILON = 0.01;
        Direction dir = Math.abs(this.mStartDS.getX() - this.mEndDS.getX()) < EPSILON ? (this.mStartDS.getY() > this.mEndDS.getY() ? Direction.TO_UP : Direction.TO_DOWN) : (this.mStartDS.getX() > this.mEndDS.getX() ? Direction.TO_LEFT : Direction.TO_RIGHT);
        return dir;
    }

    public void setDir(@NonNull Direction direction) {
        this.mDir = direction;
    }

    protected void drawArrow(@NonNull AffineTransform transform, @NonNull PaintEvent e, @NonNull DiagramStyleProvider styleProvider) {
        Point2D startCS = transform.transform(this.mStartDS, null);
        Point2D endCS = transform.transform(this.mEndDS, null);
        LineStyle style = styleProvider.getStyle((GraphicalElement)this, (DrawState)this.mDrawState).LineStyle;
        style.set(e);
        int origLineCap = e.gc.getLineCap();
        e.gc.setLineCap(2);
        e.gc.drawLine((int)startCS.getX(), (int)startCS.getY(), (int)endCS.getX(), (int)endCS.getY());
        e.gc.drawPolygon(Pin.unroll(this.getArrowHead(endCS, transform.getScaleX(), this.mDir)));
        e.gc.setLineCap(origLineCap);
        style.unset(e);
    }

    protected @NonNull Point2D[] getArrowHead(@NonNull Point2D offsetDS, double zoom, @NonNull Direction dir) {
        Point2D.Double p1 = new Point2D.Double(-1.2 * zoom, 0.0);
        Point2D.Double p2 = new Point2D.Double(1.0 * zoom, 0.0);
        Point2D.Double p3 = new Point2D.Double(0.0, -2.0 * zoom);
        double angleRad = 0.0;
        if (Direction.TO_DOWN.equals((Object)dir)) {
            angleRad = Math.PI;
        }
        if (Direction.TO_RIGHT.equals((Object)dir)) {
            angleRad = 1.5707963267948966;
        }
        if (Direction.TO_LEFT.equals((Object)dir)) {
            angleRad = -1.5707963267948966;
        }
        AffineTransform trans = AffineTransform.getTranslateInstance(offsetDS.getX(), offsetDS.getY());
        trans.rotate(angleRad);
        Point2D[] dest = new Point2D[3];
        trans.transform(new Point2D[]{p1, p2, p3}, 0, dest, 0, 3);
        return dest;
    }

    @Override
    protected Pin makeCopy() {
        Point2D.Double s = new Point2D.Double(this.mStartDS.getX(), this.mStartDS.getY());
        Point2D.Double e = new Point2D.Double(this.mEndDS.getX(), this.mEndDS.getY());
        Pin copy = new Pin((Point2D)s, e, this.mDir, this.mType, this.mInput);
        return copy;
    }

    @Override
    public boolean isHitBy(@NonNull Point2D p) {
        if (this.mBoundingBoxDS.isHitBy(p)) {
            switch (this.mType) {
                case ARROW: {
                    return this.inTriangle(this.getArrowHead(this.mEndDS, 1.0, this.mDir), p);
                }
            }
            return false;
        }
        return false;
    }

    protected boolean inTriangle(Point2D[] triangle, @NonNull Point2D p) {
        double x1 = triangle[0].getX();
        double y1 = triangle[0].getY();
        double x2 = triangle[1].getX();
        double y2 = triangle[1].getY();
        double x3 = triangle[2].getX();
        double y3 = triangle[2].getY();
        double denominator = (y2 - y3) * (x1 - x3) + (x3 - x2) * (y1 - y3);
        double a = ((y2 - y3) * (p.getX() - x3) + (x3 - x2) * (p.getY() - y3)) / denominator;
        double b = ((y3 - y1) * (p.getX() - x3) + (x1 - x3) * (p.getY() - y3)) / denominator;
        double c = 1.0 - a - b;
        return this.inRange(a, 0.0, 1.0) && this.inRange(b, 0.0, 1.0) && this.inRange(c, 0.0, 1.0);
    }

    protected boolean inRange(double num, double lower, double upper) {
        return lower <= num && num <= upper;
    }

    protected void calculateBB() {
        this.mBoundingBoxDS.setTopLeftCorner(this.mStartDS.getX(), this.mStartDS.getY());
        this.mBoundingBoxDS.setBottomRightCorner(this.mEndDS.getX(), this.mEndDS.getY());
        this.mBoundingBoxDS.orderCorners();
        Point2D tlc = this.mBoundingBoxDS.getTopLeftCornerDS();
        Point2D brc = this.mBoundingBoxDS.getBottomRightCornerDS();
        switch (this.mType) {
            case NORMAL: {
                break;
            }
            case ARROW: {
                switch (this.mDir) {
                    case TO_UP: {
                        tlc.setLocation(tlc.getX() - 1.2, tlc.getY() - 2.0);
                        brc.setLocation(brc.getX() + 1.0, brc.getY());
                        break;
                    }
                    case TO_DOWN: {
                        tlc.setLocation(tlc.getX() - 1.0, tlc.getY());
                        brc.setLocation(brc.getX() + 1.2, brc.getY() + 2.0);
                        break;
                    }
                    case TO_LEFT: {
                        tlc.setLocation(tlc.getX() - 2.0, tlc.getY() - 1.0);
                        brc.setLocation(brc.getX(), brc.getY() + 1.2);
                        break;
                    }
                    case TO_RIGHT: {
                        tlc.setLocation(tlc.getX(), tlc.getY() - 1.2);
                        brc.setLocation(brc.getX() + 2.0, brc.getY() + 1.0);
                    }
                }
                break;
            }
        }
    }

    @Override
    public void applyTransform(AffineTransform transformDS) {
        transformDS.transform(this.mStartDS, this.mStartDS);
        transformDS.transform(this.mEndDS, this.mEndDS);
        if (this.mStartDS.getX() - this.mEndDS.getX() != 0.0 || this.mStartDS.getY() - this.mStartDS.getY() != 0.0) {
            this.mDir = this.getDir();
        }
        this.calculateBB();
    }

    public boolean isInput() {
        return this.mInput;
    }

    public @NonNull Point2D getStartDS() {
        return this.mStartDS;
    }

    public @NonNull Point2D getEndDS() {
        return this.mEndDS;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.mStartDS + ", " + this.mEndDS + "]";
    }

    public static enum Direction {
        TO_UP,
        TO_DOWN,
        TO_LEFT,
        TO_RIGHT;

    }

    public static enum Type {
        NORMAL,
        DOT,
        ARROW,
        UNUSED0,
        UNUSED1,
        UNUSED2,
        CROSS;

    }
}

